/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.utils.Clock;

public abstract class TemporalType<T>
extends AbstractType<T> {
    protected TemporalType(AbstractType.ComparisonType comparisonType) {
        super(comparisonType);
    }

    public ByteBuffer now() {
        return this.fromTimeInMillis(Clock.Global.currentTimeMillis());
    }

    public long toTimeInMillis(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer fromTimeInMillis(long timeInMillis) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer addDuration(ByteBuffer temporal, ByteBuffer duration) {
        long timeInMillis = this.toTimeInMillis(temporal);
        Duration d = (Duration)DurationType.instance.compose(duration);
        this.validateDuration(d);
        return this.fromTimeInMillis(d.addTo(timeInMillis));
    }

    public ByteBuffer substractDuration(ByteBuffer temporal, ByteBuffer duration) {
        long timeInMillis = this.toTimeInMillis(temporal);
        Duration d = (Duration)DurationType.instance.compose(duration);
        this.validateDuration(d);
        return this.fromTimeInMillis(d.substractFrom(timeInMillis));
    }

    protected void validateDuration(Duration duration) {
    }
}

