/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class SQLStatementMenuItem
extends JMenuItem
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    SQLConnection connection_ = null;
    String sql_ = null;
    transient SQLWarning warnings_ = null;
    transient Statement statement_ = null;

    public SQLStatementMenuItem() {
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(Icon icon) {
        super(icon);
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(String text) {
        super(text);
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(String text, Icon icon) {
        super(text, icon);
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(String text, Icon icon, SQLConnection connection, String SQLStatement) {
        super(text, icon);
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = connection;
        if (SQLStatement == null) {
            throw new NullPointerException("SQLStatement");
        }
        this.sql_ = SQLStatement;
        this.addActionListener(new MenuListener_());
    }

    public void addActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.addActionCompletedListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingListeners_.addWorkingListener(listener);
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public void getMoreResults() {
        if (this.statement_ != null) {
            this.workingListeners_.fireStartWorking();
            try {
                this.statement_.getMoreResults();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
            this.workingListeners_.fireStopWorking();
        }
    }

    public ResultSet getResultSet() {
        if (this.statement_ == null) {
            return null;
        }
        this.workingListeners_.fireStartWorking();
        ResultSet result = null;
        try {
            result = this.statement_.getResultSet();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        this.workingListeners_.fireStopWorking();
        return result;
    }

    public String getSQLStatement() {
        if (this.sql_ == null) {
            return "";
        }
        return this.sql_;
    }

    public int getUpdateCount() {
        if (this.statement_ == null) {
            return -1;
        }
        try {
            return this.statement_.getUpdateCount();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
            return 0;
        }
    }

    public SQLWarning getWarnings() {
        if (this.statement_ == null) {
            return null;
        }
        SQLWarning s_warnings = null;
        try {
            s_warnings = this.statement_.getWarnings();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        if (this.warnings_ != null) {
            SQLWarning next;
            if (s_warnings == null) {
                return this.warnings_;
            }
            SQLWarning last = this.warnings_;
            while ((next = last.getNextWarning()) != null) {
                last = next;
            }
            last.setNextWarning(s_warnings);
            return this.warnings_;
        }
        return s_warnings;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.warnings_ = null;
        this.statement_ = null;
        this.addActionListener(new MenuListener_());
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.removeActionCompletedListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingListeners_.removeWorkingListener(listener);
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.fireVetoableChange("connection", this.connection_, connection);
        SQLConnection old = this.connection_;
        this.connection_ = connection;
        if (old != connection) {
            if (this.statement_ != null) {
                try {
                    this.statement_.close();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
            }
            this.statement_ = null;
            this.warnings_ = null;
        }
        this.firePropertyChange("connection", old, this.connection_);
    }

    public void setSQLStatement(String SQLStatement) throws PropertyVetoException {
        if (SQLStatement == null) {
            throw new NullPointerException("SQLStatement");
        }
        String old = this.getSQLStatement();
        this.fireVetoableChange("SQLStatement", old, SQLStatement);
        this.sql_ = SQLStatement;
        this.firePropertyChange("SQLStatement", old, this.sql_);
    }

    private class MenuListener_
    implements ActionListener {
        private MenuListener_() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (SQLStatementMenuItem.this.connection_ == null) {
                IllegalStateException e = new IllegalStateException("connection");
                SQLStatementMenuItem.this.errorListeners_.fireError(e);
                return;
            }
            if (SQLStatementMenuItem.this.sql_ == null) {
                IllegalStateException e = new IllegalStateException("SQLStatement");
                SQLStatementMenuItem.this.errorListeners_.fireError(e);
                return;
            }
            Trace.log(3, "Running menu, sql is:  " + SQLStatementMenuItem.this.sql_);
            SQLStatementMenuItem.this.workingListeners_.fireStartWorking();
            SQLStatementMenuItem.this.worker_.startWorking(new WorkingEvent(this));
            if (SQLStatementMenuItem.this.statement_ == null) {
                Connection conn;
                try {
                    conn = SQLStatementMenuItem.this.connection_.getConnection();
                    SQLStatementMenuItem.this.statement_ = conn.createStatement();
                }
                catch (SQLException e) {
                    SQLStatementMenuItem.this.errorListeners_.fireError(e);
                    SQLStatementMenuItem.this.worker_.stopWorking(new WorkingEvent(this));
                    SQLStatementMenuItem.this.workingListeners_.fireStopWorking();
                    return;
                }
                try {
                    SQLStatementMenuItem.this.warnings_ = conn.getWarnings();
                }
                catch (SQLException e) {
                    SQLStatementMenuItem.this.errorListeners_.fireError(e);
                }
            } else {
                SQLStatementMenuItem.this.warnings_ = null;
                try {
                    SQLStatementMenuItem.this.statement_.clearWarnings();
                }
                catch (SQLException e) {
                    SQLStatementMenuItem.this.errorListeners_.fireError(e);
                }
            }
            try {
                SQLStatementMenuItem.this.statement_.execute(SQLStatementMenuItem.this.sql_);
            }
            catch (SQLException e) {
                SQLStatementMenuItem.this.errorListeners_.fireError(e);
            }
            SQLStatementMenuItem.this.actionListeners_.fireActionCompleted();
            SQLStatementMenuItem.this.worker_.stopWorking(new WorkingEvent(this));
            SQLStatementMenuItem.this.workingListeners_.fireStopWorking();
        }
    }
}

