/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.shared;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.history.AuditList;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.IAuditManager;
import org.apache.hop.ui.core.gui.HopNamespace;

public class AuditManagerGuiUtil {
    public static final String CONST_IN_GROUP = " in group ";

    public static final String getLastUsedValue(String type) {
        try {
            AuditList list = AuditManager.getActive().retrieveList(HopNamespace.getNamespace(), type);
            if (list == null || list.getNames() == null || list.getNames().isEmpty()) {
                return "";
            }
            return (String)list.getNames().get(0);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Unable to get last used value from audit manager type: " + type + CONST_IN_GROUP + HopNamespace.getNamespace(), (Throwable)e);
            return "";
        }
    }

    public static final String[] getLastUsedValues(String type) {
        try {
            AuditList list = AuditManager.getActive().retrieveList(HopNamespace.getNamespace(), type);
            if (list == null || list.getNames() == null || list.getNames().isEmpty()) {
                return new String[0];
            }
            return list.getNames().toArray(new String[0]);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Unable to get last used values from audit manager type: " + type + CONST_IN_GROUP + HopNamespace.getNamespace(), (Throwable)e);
            return new String[0];
        }
    }

    public static final void addLastUsedValue(String type, String value) {
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        IAuditManager auditManager = AuditManager.getActive();
        try {
            List names;
            int index;
            AuditList list = auditManager.retrieveList(HopNamespace.getNamespace(), type);
            if (list == null) {
                list = new AuditList();
            }
            if ((index = (names = list.getNames()).indexOf(value)) >= 0) {
                names.remove(index);
            }
            names.add(0, value);
            while (list.getNames().size() > 50) {
                list.getNames().remove(list.getNames().size() - 1);
            }
            auditManager.storeList(HopNamespace.getNamespace(), type, list);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Unable to store list using audit manager with type: " + type + CONST_IN_GROUP + HopNamespace.getNamespace(), (Throwable)e);
        }
    }

    public static final Map<String, String> getUsageMap(String type) {
        if (StringUtil.isEmpty((String)type)) {
            return new HashMap<String, String>();
        }
        IAuditManager auditManager = AuditManager.getActive();
        try {
            HashMap map = auditManager.loadMap(HopNamespace.getNamespace(), type);
            if (map == null) {
                map = new HashMap();
            }
            return map;
        }
        catch (Exception e) {
            LogChannel.UI.logError("Unable to retrieve the usage map for type " + type + CONST_IN_GROUP + HopNamespace.getNamespace(), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public static final void saveUsageMap(String type, Map<String, String> map) {
        if (StringUtil.isEmpty((String)type)) {
            return;
        }
        IAuditManager auditManager = AuditManager.getActive();
        try {
            auditManager.saveMap(HopNamespace.getNamespace(), type, map);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Unable to save the usage map for type " + type + CONST_IN_GROUP + HopNamespace.getNamespace(), (Throwable)e);
        }
    }
}

