/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.opencensus.trace;

import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.vendor.grpc.v1p60p1.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p60p1.io.opencensus.trace.BigendianEncoding;

@Immutable
public final class SpanId
implements Comparable<SpanId> {
    public static final int SIZE = 8;
    public static final SpanId INVALID = new SpanId(0L);
    private static final int BASE16_SIZE = 16;
    private static final long INVALID_ID = 0L;
    private final long id;

    private SpanId(long id) {
        this.id = id;
    }

    public static SpanId fromBytes(byte[] src) {
        Utils.checkNotNull(src, "src");
        Utils.checkArgument(src.length == 8, "Invalid size: expected %s, got %s", 8, src.length);
        return SpanId.fromBytes(src, 0);
    }

    public static SpanId fromBytes(byte[] src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new SpanId(BigendianEncoding.longFromByteArray(src, srcOffset));
    }

    public static SpanId fromLowerBase16(CharSequence src) {
        Utils.checkNotNull(src, "src");
        Utils.checkArgument(src.length() == 16, "Invalid size: expected %s, got %s", 16, src.length());
        return SpanId.fromLowerBase16(src, 0);
    }

    public static SpanId fromLowerBase16(CharSequence src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new SpanId(BigendianEncoding.longFromBase16String(src, srcOffset));
    }

    public static SpanId generateRandomId(Random random) {
        long id;
        while ((id = random.nextLong()) == 0L) {
        }
        return new SpanId(id);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[8];
        BigendianEncoding.longToByteArray(this.id, bytes, 0);
        return bytes;
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        BigendianEncoding.longToByteArray(this.id, dest, destOffset);
    }

    public void copyLowerBase16To(char[] dest, int destOffset) {
        BigendianEncoding.longToBase16String(this.id, dest, destOffset);
    }

    public boolean isValid() {
        return this.id != 0L;
    }

    public String toLowerBase16() {
        char[] chars = new char[16];
        this.copyLowerBase16To(chars, 0);
        return new String(chars);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanId)) {
            return false;
        }
        SpanId that = (SpanId)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "SpanId{spanId=" + this.toLowerBase16() + "}";
    }

    @Override
    public int compareTo(SpanId that) {
        return this.id < that.id ? -1 : (this.id == that.id ? 0 : 1);
    }
}

