/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutputenhanced;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.BaseFileOutputMeta;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutput;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputData;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputField;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputKeyField;
import org.w3c.dom.Node;

@Transform(id="EnhancedJsonOutput", image="JSO.svg", name="i18n::EnhancedJsonOutput.name", description="i18n::EnhancedJsonOutput.description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::JsonOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/enhancedjsonoutput.html")
@InjectionSupported(localizationPrefix="JsonOutput.Injection.", groups={"GENERAL", "FIELDS"})
public class JsonOutputMeta
extends BaseFileOutputMeta<JsonOutput, JsonOutputData> {
    private static final Class<?> PKG = JsonOutputMeta.class;
    public static final String CONST_SPACES_LONG = "        ";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_OUTPUT_VALUE = "outputValue";
    public static final String CONST_KEY_FIELD = "key_field";
    public static final String CONST_FIELD = "field";
    @Injection(name="OPERATION", group="GENERAL")
    private int operationType;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.OutputValue", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.WriteToFile", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.Both", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"outputvalue", "writetofile", "both"};
    public static final int OPERATION_TYPE_OUTPUT_VALUE = 0;
    public static final int OPERATION_TYPE_WRITE_TO_FILE = 1;
    public static final int OPERATION_TYPE_BOTH = 2;
    @Injection(name="ENCODING", group="GENERAL")
    private String encoding;
    @Injection(name="OUTPUT_VALUE", group="GENERAL")
    private String outputValue;
    @Injection(name="JSON_BLOC_NAME", group="GENERAL")
    private String jsonBloc;
    @Injection(name="PRITTIFY", group="GENERAL")
    private boolean jsonPrittified;
    @InjectionDeep
    private JsonOutputField[] outputFields;
    @InjectionDeep
    private JsonOutputKeyField[] keyFields;
    @Injection(name="ADD_TO_RESULT", group="GENERAL")
    private boolean addToResult;
    @Injection(name="APPEND", group="GENERAL")
    private boolean fileAppended;
    @Injection(name="FORCE_JSON_ARRAYS", group="GENERAL")
    private boolean useArrayWithSingleInstance;
    @Injection(name="FORCE_SINGLE_ITEM", group="GENERAL")
    private boolean useSingleItemPerGroup;
    @Injection(name="CREATE_PARENT_FOLDER", group="GENERAL")
    private boolean createparentfolder;
    private boolean doNotOpenNewFileInit;
    private String jsonSizeFieldname;

    public String getJsonSizeFieldname() {
        return this.jsonSizeFieldname;
    }

    public void setJsonSizeFieldname(String jsonSizeFieldname) {
        this.jsonSizeFieldname = jsonSizeFieldname;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    @Override
    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean addToResult() {
        return this.addToResult;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JsonOutputMeta.getOperationTypeByCode(tt);
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public JsonOutputField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(JsonOutputField[] outputFields) {
        this.outputFields = outputFields;
    }

    public JsonOutputKeyField[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(JsonOutputKeyField[] keyFields) {
        this.keyFields = keyFields;
    }

    public void loadXml(Node transformnode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new JsonOutputField[nrfields];
    }

    public void allocateKey(int nrfields) {
        this.keyFields = new JsonOutputKeyField[nrfields];
    }

    public Object clone() {
        JsonOutputMeta retval = (JsonOutputMeta)((Object)super.clone());
        int nrOutputFields = this.outputFields.length;
        retval.allocate(nrOutputFields);
        for (int i = 0; i < nrOutputFields; ++i) {
            retval.outputFields[i] = (JsonOutputField)this.outputFields[i].clone();
        }
        int nrKeyFields = this.keyFields.length;
        retval.allocateKey(nrKeyFields);
        for (int i = 0; i < nrKeyFields; ++i) {
            retval.keyFields[i] = (JsonOutputKeyField)this.keyFields[i].clone();
        }
        return retval;
    }

    public void setAddToResult(boolean addToResult) {
        this.addToResult = addToResult;
    }

    private void readData(Node transformnode) throws HopXmlException {
        try {
            this.outputValue = XmlHandler.getTagValue((Node)transformnode, (String)CONST_OUTPUT_VALUE);
            this.jsonBloc = XmlHandler.getTagValue((Node)transformnode, (String)"jsonBloc");
            this.operationType = JsonOutputMeta.getOperationTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformnode, (String)"operation_type"), (String)""));
            this.useArrayWithSingleInstance = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"use_arrays_with_single_instance"));
            this.useSingleItemPerGroup = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"use_single_item_per_group"));
            this.jsonPrittified = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"json_prittified"));
            this.encoding = XmlHandler.getTagValue((Node)transformnode, (String)"encoding");
            this.addToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"addToResult"));
            this.fileName = XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"name");
            this.splitOutputAfter = Integer.parseInt(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"split_output_after"));
            this.createparentfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"create_parent_folder"));
            this.extension = Const.NVL((String)XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"extention"), (String)XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"extension"));
            this.fileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"append"));
            this.transformNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"add_time"));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"doNotOpenNewFileInit"));
            Node keyFieldNodes = XmlHandler.getSubNode((Node)transformnode, (String)"key_fields");
            int nrKeyFields = XmlHandler.countNodes((Node)keyFieldNodes, (String)CONST_KEY_FIELD);
            this.allocateKey(nrKeyFields);
            for (int i = 0; i < nrKeyFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)keyFieldNodes, (String)CONST_KEY_FIELD, (int)i);
                this.keyFields[i] = new JsonOutputKeyField();
                this.keyFields[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"key_field_name"));
                this.keyFields[i].setElementName(XmlHandler.getTagValue((Node)fnode, (String)"key_field_element"));
            }
            Node fields = XmlHandler.getSubNode((Node)transformnode, (String)"fields");
            int nrfields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.outputFields[i] = new JsonOutputField();
                this.outputFields[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setElementName(XmlHandler.getTagValue((Node)fnode, (String)"element"));
                this.outputFields[i].setJSONFragment(!"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"json_fragment")));
                this.outputFields[i].setWithoutEnclosing("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"is_without_enclosing")));
                this.outputFields[i].setRemoveIfBlank(!"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"remove_if_blank")));
            }
            this.jsonSizeFieldname = XmlHandler.getTagValue((Node)transformnode, (String)"additional_fields", (String)"json_size_field");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load Transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.encoding = "UTF-8";
        this.outputValue = CONST_OUTPUT_VALUE;
        this.jsonBloc = "result";
        this.splitOutputAfter = 0;
        this.operationType = 1;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new JsonOutputField();
            this.outputFields[i].setFieldName(CONST_FIELD + i);
            this.outputFields[i].setElementName(CONST_FIELD + i);
            this.outputFields[i].setJSONFragment(false);
            this.outputFields[i].setRemoveIfBlank(false);
        }
        int nrKeyFields = 0;
        this.allocateKey(nrKeyFields);
        for (int i = 0; i < nrKeyFields; ++i) {
            this.keyFields[i] = new JsonOutputKeyField();
            this.keyFields[i].setFieldName(CONST_KEY_FIELD + i);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.getOperationType() != 1) {
            IRowMeta rowMeta = row.clone();
            row.clear();
            JsonOutputKeyField[] keyFields = this.getKeyFields();
            for (int i = 0; i < this.getKeyFields().length; ++i) {
                IValueMeta vmi = rowMeta.getValueMeta(rowMeta.indexOfValue(keyFields[i].getFieldName()));
                row.addValueMeta(i, vmi);
            }
            ValueMetaString vm = new ValueMetaString(this.getOutputValue());
            row.addValueMeta(this.getKeyFields().length, (IValueMeta)vm);
            int fieldLength = this.getKeyFields().length + 1;
            if (this.jsonSizeFieldname != null && this.jsonSizeFieldname.length() > 0) {
                row.addValueMeta(fieldLength, (IValueMeta)new ValueMetaInteger(this.jsonSizeFieldname));
                ++fieldLength;
            }
        }
    }

    public String getXml() {
        int i;
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)CONST_OUTPUT_VALUE, (String)this.outputValue));
        retval.append("    ").append(XmlHandler.addTagValue((String)"jsonBloc", (String)this.jsonBloc));
        retval.append("    ").append(XmlHandler.addTagValue((String)"operation_type", (String)JsonOutputMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"use_arrays_with_single_instance", (boolean)this.useArrayWithSingleInstance));
        retval.append("    ").append(XmlHandler.addTagValue((String)"use_single_item_per_group", (boolean)this.useSingleItemPerGroup));
        retval.append("    ").append(XmlHandler.addTagValue((String)"json_prittified", (boolean)this.jsonPrittified));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"addtoresult", (boolean)this.addToResult));
        retval.append("    <file>" + Const.CR);
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"split_output_after", (String)Integer.toString(this.splitOutputAfter)));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"split", (boolean)this.transformNrInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"doNotOpenNewFileInit", (boolean)this.doNotOpenNewFileInit));
        retval.append("      </file>" + Const.CR);
        retval.append("     <additional_fields>" + Const.CR);
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"json_size_field", (String)this.jsonSizeFieldname));
        retval.append("      </additional_fields>" + Const.CR);
        retval.append("    <key_fields>").append(Const.CR);
        for (i = 0; i < this.keyFields.length; ++i) {
            JsonOutputKeyField keyField = this.keyFields[i];
            if (keyField.getFieldName() == null || keyField.getFieldName().length() == 0) continue;
            retval.append("      <key_field>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"key_field_name", (String)keyField.getFieldName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"key_field_element", (String)keyField.getElementName()));
            retval.append("    </key_field>" + Const.CR);
        }
        retval.append("    </key_fields>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.outputFields.length; ++i) {
            JsonOutputField field = this.outputFields[i];
            if (field.getFieldName() == null || field.getFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"element", (String)field.getElementName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"json_fragment", (boolean)field.isJSONFragment()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"is_without_enclosing", (boolean)field.isWithoutEnclosing()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"remove_if_blank", (boolean)field.isRemoveIfBlank()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.getOperationType() != 1 && Utils.isEmpty((CharSequence)variables.resolve(this.getOutputValue()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)variables.resolve(this.getFileName()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingTargetFilename", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getFieldName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.outputFields[i].getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getJsonBloc() {
        return this.jsonBloc;
    }

    public void setJsonBloc(String jsonBloc) {
        this.jsonBloc = jsonBloc;
    }

    public String getOutputValue() {
        return this.outputValue;
    }

    public void setOutputValue(String outputValue) {
        this.outputValue = outputValue;
    }

    public boolean isUseArrayWithSingleInstance() {
        return this.useArrayWithSingleInstance;
    }

    public void setUseArrayWithSingleInstance(boolean useArrayWithSingleInstance) {
        this.useArrayWithSingleInstance = useArrayWithSingleInstance;
    }

    public boolean isJsonPrittified() {
        return this.jsonPrittified;
    }

    public void setJsonPrittified(boolean jsonPrittified) {
        this.jsonPrittified = jsonPrittified;
    }

    public boolean isUseSingleItemPerGroup() {
        return this.useSingleItemPerGroup;
    }

    public void setUseSingleItemPerGroup(boolean useSingleItemPerGroup) {
        this.useSingleItemPerGroup = useSingleItemPerGroup;
    }
}

