/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class DirtyState
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized State> dirty = new AtomicReference<State>(State.CLEAN);

    public void afterModification() {
        this.dirty.set(State.DIRTY);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean beforeCommit() {
        State state;
        while ((state = this.dirty.get()) != State.CLEAN && !this.dirty.compareAndSet(state, State.COMMITTING)) {
        }
        return state != State.CLEAN;
    }

    public void afterCommit() {
        this.dirty.compareAndSet(State.COMMITTING, State.CLEAN);
    }

    public void reset() {
        this.dirty.set(State.CLEAN);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof DirtyState) {
            DirtyState dirtyState = (DirtyState)object;
            return Objects.equals((Object)this.dirty.get(), (Object)dirtyState.dirty.get());
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.dirty.get().hashCode();
    }

    private static enum State {
        DIRTY,
        CLEAN,
        COMMITTING;

    }
}

