/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapoutput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocolFactory;
import org.apache.hop.pipeline.transforms.ldapoutput.LdapOutput;
import org.apache.hop.pipeline.transforms.ldapoutput.LdapOutputData;
import org.w3c.dom.Node;

@Transform(id="LDAPOutput", name="i18n::LdapOutput.Name", description="i18n::LdapOutput.Description", image="ldapoutput.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::LdapOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/ldapoutput.html")
public class LdapOutputMeta
extends BaseTransformMeta<LdapOutput, LdapOutputData>
implements ILdapMeta {
    private static final Class<?> PKG = LdapOutputMeta.class;
    public static final String CONST_SPACES = "        ";
    public static final String CONST_FIELD = "field";
    private boolean useAuthentication;
    private String host;
    private String userName;
    private String password;
    private String port;
    private String dnFieldName;
    private boolean failIfNotExist;
    private String[] updateLookup;
    private String[] updateStream;
    private Boolean[] update;
    private String searchBase;
    private String multiValuedSeparator;
    private int operationType;
    private String oldDnFieldName;
    private String newDnFieldName;
    private boolean deleteRDN;
    static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LdapOutputMeta.operationType.Insert", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.operationType.Upsert", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.operationType.Update", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.operationType.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.operationType.Delete", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.operationType.Rename", (String[])new String[0])};
    public static final String CONST_UPDATE = "update";
    static final String[] operationTypeCode = new String[]{"insert", "upsert", "update", "add", "delete", "rename"};
    public static final int OPERATION_TYPE_INSERT = 0;
    public static final int OPERATION_TYPE_UPSERT = 1;
    public static final int OPERATION_TYPE_UPDATE = 2;
    public static final int OPERATION_TYPE_ADD = 3;
    public static final int OPERATION_TYPE_DELETE = 4;
    public static final int OPERATION_TYPE_RENAME = 5;
    private int referralType;
    public static final String[] referralTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LdapOutputMeta.referralType.Follow", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.referralType.Ignore", (String[])new String[0])};
    static final String[] referralTypeCode = new String[]{"follow", "ignore"};
    public static final int REFERRAL_TYPE_FOLLOW = 0;
    public static final int REFERRAL_TYPE_IGNORE = 1;
    private int derefAliasesType;
    static final String[] derefAliasesTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LdapOutputMeta.derefAliasesType.Always", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.derefAliasesType.Never", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.derefAliasesType.Searching", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapOutputMeta.derefAliasesType.Finding", (String[])new String[0])};
    static final String[] derefAliasesTypeCode = new String[]{"always", "never", "searching", "finding"};
    public static final int DEREFALIASES_TYPE_ALWAYS = 0;
    public static final int DEREFALIASES_TYPE_NEVER = 1;
    public static final int DEREFALIASES_TYPE_SEARCHING = 2;
    public static final int DEREFALIASES_TYPE_FINDING = 3;
    private String protocol;
    private boolean useCertificate;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean trustAllCertificates;

    @Override
    public boolean isUseCertificate() {
        return this.useCertificate;
    }

    public void setUseCertificate(boolean value) {
        this.useCertificate = value;
    }

    @Override
    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean value) {
        this.trustAllCertificates = value;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String value) {
        this.trustStorePassword = value;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String value) {
        this.trustStorePath = value;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String value) {
        this.protocol = value;
    }

    public Boolean[] getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean[] update) {
        this.update = update;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public int getReferralType() {
        return this.referralType;
    }

    public int getDerefAliasesType() {
        return this.derefAliasesType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LdapOutputMeta.getOperationTypeByCode(tt);
    }

    public static int getReferralTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < referralTypeDesc.length; ++i) {
            if (!referralTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LdapOutputMeta.getReferralTypeByCode(tt);
    }

    public static int getDerefAliasesTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < derefAliasesTypeDesc.length; ++i) {
            if (!derefAliasesTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LdapOutputMeta.getReferralTypeByCode(tt);
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getReferralTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < referralTypeCode.length; ++i) {
            if (!referralTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getDerefAliasesTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < derefAliasesTypeCode.length; ++i) {
            if (!derefAliasesTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public void setReferralType(int value) {
        this.referralType = value;
    }

    public void setDerefAliasesType(int value) {
        this.derefAliasesType = value;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    public static String getReferralTypeDesc(int i) {
        if (i < 0 || i >= referralTypeDesc.length) {
            return referralTypeDesc[0];
        }
        return referralTypeDesc[i];
    }

    public static String getDerefAliasesTypeDesc(int i) {
        if (i < 0 || i >= derefAliasesTypeDesc.length) {
            return derefAliasesTypeDesc[0];
        }
        return derefAliasesTypeDesc[i];
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDnField(String value) {
        this.dnFieldName = value;
    }

    public String getDnField() {
        return this.dnFieldName;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isFailIfNotExist() {
        return this.failIfNotExist;
    }

    public void setFailIfNotExist(boolean failIfNotExist) {
        this.failIfNotExist = failIfNotExist;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        LdapOutputMeta retval = (LdapOutputMeta)super.clone();
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrvalues);
        System.arraycopy(this.updateLookup, 0, retval.updateLookup, 0, nrvalues);
        System.arraycopy(this.updateStream, 0, retval.updateStream, 0, nrvalues);
        System.arraycopy(this.update, 0, retval.update, 0, nrvalues);
        return retval;
    }

    public void setDeleteRDN(boolean value) {
        this.deleteRDN = value;
    }

    public boolean isDeleteRDN() {
        return this.deleteRDN;
    }

    public void setNewDnFieldName(String value) {
        this.newDnFieldName = value;
    }

    public String getNewDnFieldName() {
        return this.newDnFieldName;
    }

    public void setOldDnFieldName(String value) {
        this.oldDnFieldName = value;
    }

    public String getOldDnFieldName() {
        return this.oldDnFieldName;
    }

    public void setSearchBaseDN(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getSearchBaseDN() {
        return this.searchBase;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void allocate(int nrvalues) {
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.update = new Boolean[nrvalues];
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    public static String getReferralTypeCode(int i) {
        if (i < 0 || i >= referralTypeCode.length) {
            return referralTypeCode[0];
        }
        return referralTypeCode[i];
    }

    public static String getDerefAliasesCode(int i) {
        if (i < 0 || i >= derefAliasesTypeCode.length) {
            return derefAliasesTypeCode[0];
        }
        return derefAliasesTypeCode[i];
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"useauthentication", (boolean)this.useAuthentication));
        retval.append("    ").append(XmlHandler.addTagValue((String)"host", (String)this.host));
        retval.append("    ").append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dnFieldName", (String)this.dnFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"failIfNotExist", (boolean)this.failIfNotExist));
        retval.append("    ").append(XmlHandler.addTagValue((String)"operationType", (String)LdapOutputMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"multivaluedseparator", (String)this.multiValuedSeparator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"searchBase", (String)this.searchBase));
        retval.append("    ").append(XmlHandler.addTagValue((String)"referralType", (String)LdapOutputMeta.getReferralTypeCode(this.referralType)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"derefAliasesType", (String)LdapOutputMeta.getDerefAliasesCode(this.derefAliasesType)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"oldDnFieldName", (String)this.oldDnFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"newDnFieldName", (String)this.newDnFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"deleteRDN", (boolean)this.deleteRDN));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)CONST_FIELD, (String)this.updateStream[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)CONST_UPDATE, (boolean)this.update[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustStorePath", (String)this.trustStorePath));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustStorePassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustAllCertificates", (boolean)this.trustAllCertificates));
        retval.append("    ").append(XmlHandler.addTagValue((String)"useCertificate", (boolean)this.useCertificate));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.useAuthentication = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useauthentication"));
            this.host = XmlHandler.getTagValue((Node)transformNode, (String)"host");
            this.userName = XmlHandler.getTagValue((Node)transformNode, (String)"username");
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"password")));
            this.port = XmlHandler.getTagValue((Node)transformNode, (String)"port");
            this.dnFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"dnFieldName");
            this.failIfNotExist = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"failIfNotExist"));
            this.operationType = LdapOutputMeta.getOperationTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"operationType"), (String)""));
            this.multiValuedSeparator = XmlHandler.getTagValue((Node)transformNode, (String)"multivaluedseparator");
            this.searchBase = XmlHandler.getTagValue((Node)transformNode, (String)"searchBase");
            this.referralType = LdapOutputMeta.getReferralTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"referralType"), (String)""));
            this.derefAliasesType = LdapOutputMeta.getDerefAliasesTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"derefAliasesType"), (String)""));
            this.oldDnFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"oldDnFieldName");
            this.newDnFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"newDnFieldName");
            this.deleteRDN = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"deleteRDN"));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                String updateValue;
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.updateLookup[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.updateStream[i] = XmlHandler.getTagValue((Node)fnode, (String)CONST_FIELD);
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.update[i] = (updateValue = XmlHandler.getTagValue((Node)fnode, (String)CONST_UPDATE)) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
            this.protocol = XmlHandler.getTagValue((Node)transformNode, (String)"protocol");
            this.trustStorePath = XmlHandler.getTagValue((Node)transformNode, (String)"trustStorePath");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"trustStorePassword"));
            this.trustAllCertificates = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"trustAllCertificates"));
            this.useCertificate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useCertificate"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"LdapOutputMeta.UnableToLoadFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.useAuthentication = false;
        this.host = "";
        this.userName = "";
        this.password = "";
        this.port = "389";
        this.dnFieldName = null;
        this.failIfNotExist = true;
        this.multiValuedSeparator = ";";
        this.searchBase = null;
        this.oldDnFieldName = null;
        this.newDnFieldName = null;
        this.deleteRDN = true;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.updateLookup[i] = "name" + (i + 1);
            this.updateStream[i] = CONST_FIELD + (i + 1);
            this.update[i] = Boolean.TRUE;
        }
        this.operationType = 0;
        this.referralType = 0;
        this.derefAliasesType = 0;
        this.trustStorePath = null;
        this.trustStorePassword = null;
        this.trustAllCertificates = false;
        this.protocol = LdapProtocolFactory.getConnectionTypes(this.log).get(0);
        this.useCertificate = false;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapOutputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapOutputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.host) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapOutputMeta.CheckResult.HostnameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapOutputMeta.CheckResult.HostnameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.updateLookup.length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapOutputUpdateMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapOutputUpdateMeta.CheckResult.FieldsOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String toString() {
        return "LdapConnection " + this.getName();
    }

    @Override
    public String getDerefAliases() {
        return LdapOutputMeta.getDerefAliasesCode(this.getDerefAliasesType());
    }

    @Override
    public String getReferrals() {
        return LdapOutputMeta.getReferralTypeCode(this.getReferralType());
    }
}

