/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutput;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutputData;

@Transform(id="GoogleSheetsOutput", image="google-sheets-output.svg", name="i18n::GoogleSheetsOutput.transform.Name", description="i18n::GoogleSheetsOutput.transform.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/google-sheets-output.html")
public class GoogleSheetsOutputMeta
extends BaseTransformMeta<GoogleSheetsOutput, GoogleSheetsOutputData> {
    @HopMetadataProperty(key="jsonCredentialPath", injectionGroupKey="SHEET")
    private String jsonCredentialPath;
    @HopMetadataProperty(key="spreadsheetKey", injectionGroupKey="SHEET")
    private String spreadsheetKey;
    @HopMetadataProperty(key="worksheetId", injectionGroupKey="SHEET")
    private String worksheetId;
    @HopMetadataProperty(key="SHAREEMAIL", injectionGroupKey="SHEET")
    private String shareEmail;
    @HopMetadataProperty(key="SHAREDOMAIN", injectionGroupKey="SHEET")
    private String shareDomain;
    @HopMetadataProperty(key="CREATE", injectionGroupKey="SHEET")
    private Boolean create = true;
    @HopMetadataProperty(key="APPEND", injectionGroupKey="SHEET")
    private Boolean append;
    @HopMetadataProperty(key="timeout", injectionGroupKey="SHEET")
    private String timeout;
    @HopMetadataProperty(key="impersonation", injectionGroupKey="SHEET")
    private String impersonation;
    @HopMetadataProperty(key="appName", injectionGroupKey="SHEET")
    private String appName;

    public void setDefault() {
        this.jsonCredentialPath = "client_secret.json";
        this.spreadsheetKey = "";
        this.worksheetId = "";
        this.shareDomain = "";
        this.shareEmail = "";
        this.create = true;
        this.append = false;
        this.impersonation = "";
        this.appName = "";
        this.timeout = "5";
    }

    public String getJsonCredentialPath() {
        return this.jsonCredentialPath == null ? "" : this.jsonCredentialPath;
    }

    public void setJsonCredentialPath(String key) {
        this.jsonCredentialPath = key;
    }

    public String getSpreadsheetKey() {
        return this.spreadsheetKey == null ? "" : this.spreadsheetKey;
    }

    public void setSpreadsheetKey(String key) {
        this.spreadsheetKey = key;
    }

    public String getShareEmail() {
        return this.shareEmail == null ? "" : this.shareEmail;
    }

    public void setShareEmail(String shareEmail) {
        this.shareEmail = shareEmail;
    }

    public String getShareDomain() {
        return this.shareDomain == null ? "" : this.shareDomain;
    }

    public void setShareDomain(String shareDomain) {
        this.shareDomain = shareDomain;
    }

    public Boolean isCreate() {
        return this.create == null ? false : this.create;
    }

    public void setCreate(Boolean create) {
        this.create = create;
    }

    public void setAppend(Boolean append) {
        this.append = append;
    }

    public Boolean isAppend() {
        return this.append == null ? false : this.append;
    }

    public String getWorksheetId() {
        return this.worksheetId == null ? "" : this.worksheetId;
    }

    public void setWorksheetId(String id) {
        this.worksheetId = id;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getImpersonation() {
        return this.impersonation;
    }

    public void setImpersonation(String impersonation) {
        this.impersonation = impersonation;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Object clone() {
        GoogleSheetsOutputMeta retval = (GoogleSheetsOutputMeta)((Object)super.clone());
        retval.setJsonCredentialPath(this.jsonCredentialPath);
        retval.setSpreadsheetKey(this.spreadsheetKey);
        retval.setWorksheetId(this.worksheetId);
        retval.setCreate(this.create);
        retval.setAppend(this.append);
        retval.setShareEmail(this.shareEmail);
        retval.setShareDomain(this.shareDomain);
        return retval;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        if (prev == null || prev.size() == 0) {
            remarks.add((ICheckResult)new CheckResult(1, "Not receiving any fields from previous transforms.", (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, String.format("Transform is connected to previous one, receiving %1$d fields", prev.size()), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(4, "Transform is receiving info from other transforms!", (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, "No input received from other transforms.", (ICheckResultSource)transformMeta));
        }
    }
}

