/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.writetolog;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.writetolog.LogField;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLog;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLogData;

@Transform(id="WriteToLog", image="writetolog.svg", name="i18n::WriteToLog.Name", description="i18n::WriteToLog.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::WriteToLog.Keyword"}, documentationUrl="/pipeline/transforms/writetolog.html")
public class WriteToLogMeta
extends BaseTransformMeta<WriteToLog, WriteToLogData> {
    private static final Class<?> PKG = WriteToLogMeta.class;
    @HopMetadataProperty(key="displayHeader", injectionKey="DISPLAY_HEADER", injectionKeyDescription="WriteToLogMeta.Injection.DisplayHeader")
    private boolean displayHeader;
    @HopMetadataProperty(key="limitRows", injectionKey="LIMIT_ROWS", injectionKeyDescription="WriteToLogMeta.Injection.LimitRows")
    private boolean limitRows;
    @HopMetadataProperty(key="limitRowsNumber", injectionKey="LIMIT_ROWS_NUMBER", injectionKeyDescription="WriteToLogMeta.Injection.LimitRowsNumber")
    private int limitRowsNumber;
    @HopMetadataProperty(key="logmessage", injectionKey="LOG_MESSAGE", injectionKeyDescription="WriteToLogMeta.Injection.LogMessage")
    private String logMessage;
    @HopMetadataProperty(key="loglevel", storeWithCode=true, injectionKeyDescription="WriteToLogMeta.Injection.LogLevel")
    private LogLevel logLevel;
    @HopMetadataProperty(key="field", groupKey="fields", injectionGroupDescription="WriteToLogMeta.Injection.Fields", injectionKeyDescription="WriteToLogMeta.Injection.Field")
    private List<LogField> logFields = new ArrayList<LogField>();

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Object clone() {
        WriteToLogMeta retval = (WriteToLogMeta)((Object)super.clone());
        return retval;
    }

    public List<LogField> getLogFields() {
        return this.logFields;
    }

    public void setLogFields(List<LogField> fields) {
        this.logFields = fields;
    }

    public boolean isDisplayHeader() {
        return this.displayHeader;
    }

    public void setDisplayHeader(boolean displayheader) {
        this.displayHeader = displayheader;
    }

    public boolean isLimitRows() {
        return this.limitRows;
    }

    public void setLimitRows(boolean limitRows) {
        this.limitRows = limitRows;
    }

    public int getLimitRowsNumber() {
        return this.limitRowsNumber;
    }

    public void setLimitRowsNumber(int limitRowsNumber) {
        this.limitRowsNumber = limitRowsNumber;
    }

    public String getLogMessage() {
        if (this.logMessage == null) {
            this.logMessage = "";
        }
        return this.logMessage;
    }

    public void setLogMessage(String message) {
        this.logMessage = message;
    }

    public void setDefault() {
        this.displayHeader = true;
        this.logLevel = LogLevel.BASIC;
        this.logMessage = "";
        this.logFields = new ArrayList<LogField>();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (LogField field : this.logFields) {
                int idx = prev.indexOfValue(field.getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + field.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (this.logFields.isEmpty()) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"WriteToLogMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

