/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.actions.runtests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.testing.actions.runtests.RunPipelineTestsField;
import org.apache.hop.testing.util.UnitTestUtil;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="RunPipelineTests", name="i18n::RunPipelineTests.Name", description="i18n::RunPipelineTests.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::RunPipelineTests.Keywords"}, image="Test_tube_icon.svg", documentationUrl="/workflow/actions/runpipelinetests.html")
public class RunPipelineTests
extends ActionBase
implements IAction,
Cloneable {
    public static final String TEST_NAMES = "test_names";
    public static final String TEST_NAME = "test_name";
    @HopMetadataProperty(key="test_name", groupKey="test_names")
    private List<RunPipelineTestsField> testNames = new ArrayList<RunPipelineTestsField>();

    public RunPipelineTests(String name, String description) {
        super(name, description);
    }

    public RunPipelineTests() {
        this("", "");
    }

    public RunPipelineTests clone() {
        return (RunPipelineTests)super.clone();
    }

    public Result execute(Result prevResult, int nr) throws HopException {
        IHopMetadataSerializer testSerializer = this.getMetadataProvider().getSerializer(PipelineUnitTest.class);
        AtomicBoolean success = new AtomicBoolean(true);
        for (RunPipelineTestsField testName : this.testNames) {
            PipelineUnitTest test = (PipelineUnitTest)testSerializer.load(testName.getTestName());
            UnitTestUtil.executeUnitTest(test, (ILoggingObject)this, this.getLogLevel(), prevResult, this.getMetadataProvider(), (IVariables)this, (pipeline, result) -> {
                if (result.getNrErrors() > 0L) {
                    this.logError("There was an error running the pipeline for unit test '" + test.getName() + "'");
                    success.set(false);
                }
            }, (pipeline, testResults) -> {
                int errorCount = 0;
                for (UnitTestResult testResult : testResults) {
                    if (!testResult.isError()) continue;
                    this.logError("Error in validating test data set '" + testResult.getDataSetName() + " : " + testResult.getComment());
                    ++errorCount;
                }
                if (errorCount > 0) {
                    this.logError("There were test result evaluation errors in pipeline unit test '" + test.getName());
                    success.set(false);
                }
            }, (test1, pipelineMeta, e) -> {
                if (test == null) {
                    this.logError("Unable to load unit test for '" + testName, e);
                } else {
                    this.logError("There was an exception executing pipeline unit test '" + test.getName(), e);
                }
                success.set(false);
            });
        }
        if (success.get()) {
            prevResult.setNrErrors(0L);
            prevResult.setResult(true);
        } else {
            prevResult.setNrErrors(prevResult.getNrErrors() + 1L);
            prevResult.setResult(false);
        }
        return prevResult;
    }

    public String[] getReferencedObjectDescriptions() {
        String[] descriptions = new String[this.testNames.size()];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = "Pipeline of unit test : " + this.testNames.get(i);
        }
        return descriptions;
    }

    public boolean[] isReferencedObjectEnabled() {
        boolean[] enabled = new boolean[this.testNames.size()];
        for (int i = 0; i < enabled.length; ++i) {
            enabled[i] = true;
        }
        return enabled;
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        RunPipelineTestsField testName;
        IHopMetadataSerializer testSerializer = metadataProvider.getSerializer(PipelineUnitTest.class);
        PipelineUnitTest test = (PipelineUnitTest)testSerializer.load((testName = this.testNames.get(index)).getTestName());
        if (test == null) {
            throw new HopException("Unit test '" + testName + "' could not be found");
        }
        return UnitTestUtil.loadTestPipeline(test, metadataProvider, variables);
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    @Generated
    public List<RunPipelineTestsField> getTestNames() {
        return this.testNames;
    }

    @Generated
    public void setTestNames(List<RunPipelineTestsField> testNames) {
        this.testNames = testNames;
    }
}

