/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.database.DatabaseTestResults;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="This is the editor for database connection metadata")
public class DatabaseMetaEditor
extends MetadataEditor<DatabaseMeta> {
    private static final Class<?> PKG = DatabaseMetaEditor.class;
    private CTabFolder wTabFolder;
    private Composite wGeneralComp;
    private Text wName;
    private Combo wConnectionType;
    private Label wDriverInfo;
    private TextVar wManualUrl;
    private Label wlUsername;
    private TextVar wUsername;
    private Label wlPassword;
    private TextVar wPassword;
    private Composite wDatabaseSpecificComp;
    private GuiCompositeWidgets guiCompositeWidgets;
    private Button wSupportsBoolean;
    private Button wSupportsTimestamp;
    private Button wQuoteAll;
    private Button wForceLowercase;
    private Button wForceUppercase;
    private Button wPreserveCase;
    private TextVar wPreferredSchema;
    private TextVar wSqlStatements;
    private TableView wOptions;
    private PropsUi props;
    private int middle;
    private int margin;
    private Map<Class<? extends IDatabase>, IDatabase> metaMap;
    private AtomicBoolean busyChangingConnectionType = new AtomicBoolean(false);

    public DatabaseMetaEditor(HopGui hopGui, MetadataManager<DatabaseMeta> manager, DatabaseMeta databaseMeta) {
        super(hopGui, manager, databaseMeta);
        this.props = PropsUi.getInstance();
        this.metaMap = this.populateMetaMap();
        this.metaMap.put(databaseMeta.getIDatabase().getClass(), databaseMeta.getIDatabase());
    }

    private Map<Class<? extends IDatabase>, IDatabase> populateMetaMap() {
        this.metaMap = new HashMap<Class<? extends IDatabase>, IDatabase>();
        List plugins = PluginRegistry.getInstance().getPlugins(DatabasePluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IDatabase database = (IDatabase)PluginRegistry.getInstance().loadClass(plugin);
                if (database.getDefaultDatabasePort() > 0) {
                    database.setPort(Integer.toString(database.getDefaultDatabasePort()));
                }
                database.setPluginId(plugin.getIds()[0]);
                database.setPluginName(plugin.getName());
                database.addDefaultOptions();
                this.metaMap.put(database.getClass(), database);
            }
            catch (Exception e) {
                HopGui.getInstance().getLog().logError("Error instantiating database metadata", (Throwable)e);
            }
        }
        return this.metaMap;
    }

    @Override
    public void createControl(Composite parent) {
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ConnectionName", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, this.margin);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment((Control)wIcon, -this.margin);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wTabFolder = new CTabFolder(parent, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, 4);
        this.addGeneralTab();
        this.addAdvancedTab();
        this.addOptionsTab();
        this.wTabFolder.setSelection(0);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)spacer, 15);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.setWidgetsContent();
        this.resetChanged();
        Listener modifyListener = event -> {
            this.setChanged();
            MetadataPerspective.getInstance().updateEditor(this);
        };
        this.wName.addListener(24, modifyListener);
        this.wConnectionType.addListener(24, modifyListener);
        this.wConnectionType.addListener(24, event -> this.changeConnectionType());
        this.wUsername.addListener(24, modifyListener);
        this.wPassword.addListener(24, modifyListener);
        this.wManualUrl.addListener(24, modifyListener);
        this.wSupportsBoolean.addListener(13, modifyListener);
        this.wSupportsTimestamp.addListener(13, modifyListener);
        this.wQuoteAll.addListener(13, modifyListener);
        this.wForceLowercase.addListener(13, modifyListener);
        this.wForceUppercase.addListener(13, modifyListener);
        this.wPreserveCase.addListener(13, modifyListener);
        this.wPreferredSchema.addListener(24, modifyListener);
        this.wSqlStatements.addListener(24, modifyListener);
        this.wOptions.addListener(24, modifyListener);
    }

    private void addGeneralTab() {
        CTabItem wGeneralTab = new CTabItem(this.wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText("   " + BaseMessages.getString(PKG, (String)"DatabaseDialog.DbTab.title", (String[])new String[0]) + "   ");
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)this.wGeneralComp);
        FormLayout genLayout = new FormLayout();
        genLayout.marginWidth = PropsUi.getFormMargin() * 2;
        genLayout.marginHeight = PropsUi.getFormMargin() * 2;
        this.wGeneralComp.setLayout((Layout)genLayout);
        Label wlConnectionType = new Label(this.wGeneralComp, 131072);
        PropsUi.setLook((Widget)wlConnectionType);
        wlConnectionType.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ConnectionType", (String[])new String[0]));
        FormData fdlConnectionType = new FormData();
        fdlConnectionType.top = new FormAttachment(0, this.margin);
        fdlConnectionType.left = new FormAttachment(0, 0);
        fdlConnectionType.right = new FormAttachment(this.middle, -this.margin);
        wlConnectionType.setLayoutData((Object)fdlConnectionType);
        ToolBar wToolBar = new ToolBar(this.wGeneralComp, 0x800100);
        FormData fdToolBar = new FormData();
        fdToolBar.right = new FormAttachment(100, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        wToolBar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)wToolBar, 0);
        ToolItem item = new ToolItem(wToolBar, 8);
        item.setImage(GuiResource.getInstance().getImageHelpWeb());
        item.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        item.addListener(13, e -> this.onHelpDatabaseType());
        this.wConnectionType = new Combo(this.wGeneralComp, 18436);
        this.wConnectionType.setItems(this.getConnectionTypes());
        PropsUi.setLook((Widget)this.wConnectionType);
        FormData fdConnectionType = new FormData();
        fdConnectionType.top = new FormAttachment((Control)wlConnectionType, 0, 0x1000000);
        fdConnectionType.left = new FormAttachment(this.middle, 0);
        fdConnectionType.right = new FormAttachment((Control)wToolBar, -this.margin);
        this.wConnectionType.setLayoutData((Object)fdConnectionType);
        Object lastControl = this.wConnectionType;
        Label wlDriverInfo = new Label(this.wGeneralComp, 131072);
        PropsUi.setLook((Widget)wlDriverInfo);
        wlDriverInfo.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.InstalledDriver", (String[])new String[0]));
        FormData fdlDriverInfo = new FormData();
        fdlDriverInfo.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdlDriverInfo.left = new FormAttachment(0, 0);
        fdlDriverInfo.right = new FormAttachment(this.middle, -this.margin);
        wlDriverInfo.setLayoutData((Object)fdlDriverInfo);
        this.wDriverInfo = new Label(this.wGeneralComp, 16384);
        this.wDriverInfo.setEnabled(false);
        PropsUi.setLook((Widget)this.wDriverInfo);
        FormData fdDriverInfo = new FormData();
        fdDriverInfo.top = new FormAttachment((Control)wlDriverInfo, 0, 0x1000000);
        fdDriverInfo.left = new FormAttachment(this.middle, 0);
        fdDriverInfo.right = new FormAttachment(100, 0);
        this.wDriverInfo.setLayoutData((Object)fdDriverInfo);
        lastControl = this.wDriverInfo;
        this.wlUsername = new Label(this.wGeneralComp, 131072);
        PropsUi.setLook((Widget)this.wlUsername);
        this.wlUsername.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.Username", (String[])new String[0]));
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(this.middle, -this.margin);
        this.wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar(this.manager.getVariables(), this.wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)this.wlUsername, 0, 0x1000000);
        fdUsername.left = new FormAttachment(this.middle, 0);
        fdUsername.right = new FormAttachment(100, 0);
        this.wUsername.setLayoutData(fdUsername);
        lastControl = this.wUsername;
        this.wlPassword = new Label(this.wGeneralComp, 131072);
        PropsUi.setLook((Widget)this.wlPassword);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.Password", (String[])new String[0]));
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(this.middle, -this.margin);
        this.wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new TextVar(this.manager.getVariables(), this.wGeneralComp, 0x404804);
        PropsUi.setLook((Widget)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)this.wlPassword, 0, 0x1000000);
        fdPassword.left = new FormAttachment(this.middle, 0);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData(fdPassword);
        lastControl = this.wPassword;
        this.wDatabaseSpecificComp = new Composite(this.wGeneralComp, 8);
        this.wDatabaseSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdDatabaseSpecificComp = new FormData();
        fdDatabaseSpecificComp.left = new FormAttachment(0, 0);
        fdDatabaseSpecificComp.right = new FormAttachment(100, 0);
        fdDatabaseSpecificComp.top = new FormAttachment((Control)lastControl, this.margin);
        this.wDatabaseSpecificComp.setLayoutData((Object)fdDatabaseSpecificComp);
        PropsUi.setLook((Widget)this.wDatabaseSpecificComp);
        lastControl = this.wDatabaseSpecificComp;
        this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.guiCompositeWidgets.createCompositeWidgets(((DatabaseMeta)this.getMetadata()).getIDatabase(), null, this.wDatabaseSpecificComp, "DatabaseMeta-PluginSpecific-Options", null);
        this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

            @Override
            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                DatabaseMetaEditor.this.setChanged();
                DatabaseMetaEditor.this.updateDriverInfo();
            }
        });
        this.addCompositeWidgetsUsernamePassword();
        Label wlManualUrl = new Label(this.wGeneralComp, 131072);
        PropsUi.setLook((Widget)wlManualUrl);
        wlManualUrl.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ManualUrl", (String[])new String[0]));
        FormData fdlManualUrl = new FormData();
        fdlManualUrl.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdlManualUrl.left = new FormAttachment(0, 0);
        fdlManualUrl.right = new FormAttachment(this.middle, -this.margin);
        wlManualUrl.setLayoutData((Object)fdlManualUrl);
        this.wManualUrl = new TextVar(this.manager.getVariables(), this.wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wManualUrl);
        FormData fdManualUrl = new FormData();
        fdManualUrl.top = new FormAttachment((Control)wlManualUrl, 0, 0x1000000);
        fdManualUrl.left = new FormAttachment(this.middle, 0);
        fdManualUrl.right = new FormAttachment(100, 0);
        this.wManualUrl.setLayoutData(fdManualUrl);
        this.wManualUrl.addListener(24, e -> this.enableFields());
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)fdGeneralComp);
        this.wGeneralComp.layout();
        wGeneralTab.setControl((Control)this.wGeneralComp);
    }

    private void addCompositeWidgetsUsernamePassword() {
        this.guiCompositeWidgets.getWidgetsMap().put("username-label", (Control)this.wlUsername);
        this.guiCompositeWidgets.getWidgetsMap().put("username-widget", (Control)this.wUsername);
        this.guiCompositeWidgets.getWidgetsMap().put("password-label", (Control)this.wlPassword);
        this.guiCompositeWidgets.getWidgetsMap().put("password-widget", (Control)this.wPassword);
    }

    private void changeConnectionType() {
        if (this.busyChangingConnectionType.get()) {
            return;
        }
        this.busyChangingConnectionType.set(true);
        DatabaseMeta databaseMeta = (DatabaseMeta)this.getMetadata();
        Class<?> oldClass = databaseMeta.getIDatabase().getClass();
        String oldTypeName = databaseMeta.getPluginName();
        String newTypeName = this.wConnectionType.getText();
        this.wConnectionType.setText(databaseMeta.getPluginName());
        this.getWidgetsContent(databaseMeta);
        this.metaMap.put(oldClass, databaseMeta.getIDatabase());
        this.wConnectionType.setText(newTypeName);
        databaseMeta.setDatabaseType(newTypeName);
        databaseMeta.setIDatabase(this.metaMap.get(databaseMeta.getIDatabase().getClass()));
        for (Control child : this.wDatabaseSpecificComp.getChildren()) {
            child.dispose();
        }
        this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.guiCompositeWidgets.createCompositeWidgets(databaseMeta.getIDatabase(), null, this.wDatabaseSpecificComp, "DatabaseMeta-PluginSpecific-Options", null);
        this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

            @Override
            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                DatabaseMetaEditor.this.setChanged();
                DatabaseMetaEditor.this.updateDriverInfo();
            }
        });
        this.addCompositeWidgetsUsernamePassword();
        this.setWidgetsContent();
        this.wGeneralComp.layout(true, true);
        this.busyChangingConnectionType.set(false);
    }

    private void addAdvancedTab() {
        CTabItem wAdvancedTab = new CTabItem(this.wTabFolder, 0);
        wAdvancedTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdvancedTab.setText("   " + BaseMessages.getString(PKG, (String)"DatabaseDialog.AdvancedTab.title", (String[])new String[0]) + "   ");
        Composite wAdvancedComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wAdvancedComp);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginWidth = PropsUi.getFormMargin() * 2;
        advancedLayout.marginHeight = PropsUi.getFormMargin() * 2;
        wAdvancedComp.setLayout((Layout)advancedLayout);
        Label wlSupportsBoolean = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlSupportsBoolean);
        wlSupportsBoolean.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ConnectionSupportsBoolean", (String[])new String[0]));
        FormData fdlSupportsBoolean = new FormData();
        fdlSupportsBoolean.top = new FormAttachment(0, 0);
        fdlSupportsBoolean.left = new FormAttachment(0, 0);
        fdlSupportsBoolean.right = new FormAttachment(this.middle, 0);
        wlSupportsBoolean.setLayoutData((Object)fdlSupportsBoolean);
        this.wSupportsBoolean = new Button(wAdvancedComp, 16416);
        PropsUi.setLook((Widget)this.wSupportsBoolean);
        FormData fdSupportsBoolean = new FormData();
        fdSupportsBoolean.top = new FormAttachment((Control)wlSupportsBoolean, 0, 0x1000000);
        fdSupportsBoolean.left = new FormAttachment(this.middle, this.margin);
        fdSupportsBoolean.right = new FormAttachment(100, 0);
        this.wSupportsBoolean.setLayoutData((Object)fdSupportsBoolean);
        Object lastControl = this.wSupportsBoolean;
        Label wlSupportsTimestamp = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlSupportsTimestamp);
        wlSupportsTimestamp.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ConnectionSupportsTimestamp", (String[])new String[0]));
        FormData fdlSupportsTimestamp = new FormData();
        fdlSupportsTimestamp.top = new FormAttachment((Control)lastControl, this.margin);
        fdlSupportsTimestamp.left = new FormAttachment(0, 0);
        fdlSupportsTimestamp.right = new FormAttachment(this.middle, 0);
        wlSupportsTimestamp.setLayoutData((Object)fdlSupportsTimestamp);
        this.wSupportsTimestamp = new Button(wAdvancedComp, 16416);
        PropsUi.setLook((Widget)this.wSupportsTimestamp);
        FormData fdSupportsTimestamp = new FormData();
        fdSupportsTimestamp.top = new FormAttachment((Control)wlSupportsTimestamp, 0, 0x1000000);
        fdSupportsTimestamp.left = new FormAttachment(this.middle, this.margin);
        fdSupportsTimestamp.right = new FormAttachment(100, 0);
        this.wSupportsTimestamp.setLayoutData((Object)fdSupportsTimestamp);
        lastControl = this.wSupportsTimestamp;
        Label wlQuoteAll = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlQuoteAll);
        wlQuoteAll.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.AdvancedQuoteAllFields", (String[])new String[0]));
        FormData fdlQuoteAll = new FormData();
        fdlQuoteAll.top = new FormAttachment((Control)lastControl, this.margin);
        fdlQuoteAll.left = new FormAttachment(0, 0);
        fdlQuoteAll.right = new FormAttachment(this.middle, 0);
        wlQuoteAll.setLayoutData((Object)fdlQuoteAll);
        this.wQuoteAll = new Button(wAdvancedComp, 16416);
        PropsUi.setLook((Widget)this.wQuoteAll);
        FormData fdQuoteAll = new FormData();
        fdQuoteAll.top = new FormAttachment((Control)wlQuoteAll, 0, 0x1000000);
        fdQuoteAll.left = new FormAttachment(this.middle, this.margin);
        fdQuoteAll.right = new FormAttachment(100, 0);
        this.wQuoteAll.setLayoutData((Object)fdQuoteAll);
        lastControl = this.wQuoteAll;
        Label wlForceLowercase = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlForceLowercase);
        wlForceLowercase.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.AdvancedForceIdentifiersLowerCase", (String[])new String[0]));
        FormData fdlForceLowercase = new FormData();
        fdlForceLowercase.top = new FormAttachment((Control)lastControl, this.margin);
        fdlForceLowercase.left = new FormAttachment(0, 0);
        fdlForceLowercase.right = new FormAttachment(this.middle, 0);
        wlForceLowercase.setLayoutData((Object)fdlForceLowercase);
        this.wForceLowercase = new Button(wAdvancedComp, 16416);
        PropsUi.setLook((Widget)this.wForceLowercase);
        FormData fdForceLowercase = new FormData();
        fdForceLowercase.top = new FormAttachment((Control)wlForceLowercase, 0, 0x1000000);
        fdForceLowercase.left = new FormAttachment(this.middle, this.margin);
        fdForceLowercase.right = new FormAttachment(100, 0);
        this.wForceLowercase.setLayoutData((Object)fdForceLowercase);
        lastControl = this.wForceLowercase;
        Label wlForceUppercase = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlForceUppercase);
        wlForceUppercase.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.AdvancedForceIdentifiersUpperCase", (String[])new String[0]));
        FormData fdlForceUppercase = new FormData();
        fdlForceUppercase.top = new FormAttachment((Control)lastControl, this.margin);
        fdlForceUppercase.left = new FormAttachment(0, 0);
        fdlForceUppercase.right = new FormAttachment(this.middle, 0);
        wlForceUppercase.setLayoutData((Object)fdlForceUppercase);
        this.wForceUppercase = new Button(wAdvancedComp, 16416);
        PropsUi.setLook((Widget)this.wForceUppercase);
        FormData fdForceUppercase = new FormData();
        fdForceUppercase.top = new FormAttachment((Control)wlForceUppercase, 0, 0x1000000);
        fdForceUppercase.left = new FormAttachment(this.middle, this.margin);
        fdForceUppercase.right = new FormAttachment(100, 0);
        this.wForceUppercase.setLayoutData((Object)fdForceUppercase);
        lastControl = this.wForceUppercase;
        Label wlPreserveCase = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlPreserveCase);
        wlPreserveCase.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ConnectionPreserveCase", (String[])new String[0]));
        FormData fdlPreserveCase = new FormData();
        fdlPreserveCase.top = new FormAttachment((Control)lastControl, this.margin);
        fdlPreserveCase.left = new FormAttachment(0, 0);
        fdlPreserveCase.right = new FormAttachment(this.middle, 0);
        wlPreserveCase.setLayoutData((Object)fdlPreserveCase);
        this.wPreserveCase = new Button(wAdvancedComp, 16416);
        PropsUi.setLook((Widget)this.wPreserveCase);
        FormData fdPreserveCase = new FormData();
        fdPreserveCase.top = new FormAttachment((Control)wlPreserveCase, 0, 0x1000000);
        fdPreserveCase.left = new FormAttachment(this.middle, this.margin);
        fdPreserveCase.right = new FormAttachment(100, 0);
        this.wPreserveCase.setLayoutData((Object)fdPreserveCase);
        lastControl = this.wPreserveCase;
        Label wlPreferredSchema = new Label(wAdvancedComp, 131072);
        PropsUi.setLook((Widget)wlPreferredSchema);
        wlPreferredSchema.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.PreferredSchemaName", (String[])new String[0]));
        FormData fdlPreferredSchema = new FormData();
        fdlPreferredSchema.top = new FormAttachment((Control)lastControl, this.margin);
        fdlPreferredSchema.left = new FormAttachment(0, 0);
        fdlPreferredSchema.right = new FormAttachment(this.middle, 0);
        wlPreferredSchema.setLayoutData((Object)fdlPreferredSchema);
        this.wPreferredSchema = new TextVar(this.manager.getVariables(), wAdvancedComp, 18436);
        PropsUi.setLook((Widget)this.wPreferredSchema);
        FormData fdPreferredSchema = new FormData();
        fdPreferredSchema.top = new FormAttachment((Control)wlPreferredSchema, 0, 0x1000000);
        fdPreferredSchema.left = new FormAttachment(this.middle, this.margin);
        fdPreferredSchema.right = new FormAttachment(100, 0);
        this.wPreferredSchema.setLayoutData(fdPreferredSchema);
        lastControl = this.wPreferredSchema;
        Label wlSqlStatements = new Label(wAdvancedComp, 16384);
        PropsUi.setLook((Widget)wlSqlStatements);
        wlSqlStatements.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.ConnectionSQLStatements", (String[])new String[0]));
        FormData fdlSqlStatements = new FormData();
        fdlSqlStatements.top = new FormAttachment((Control)lastControl, this.margin);
        fdlSqlStatements.left = new FormAttachment(0, 0);
        fdlSqlStatements.right = new FormAttachment(100, 0);
        wlSqlStatements.setLayoutData((Object)fdlSqlStatements);
        this.wSqlStatements = new TextVar(this.manager.getVariables(), wAdvancedComp, 19202);
        PropsUi.setLook((Widget)this.wSqlStatements);
        FormData fdSqlStatements = new FormData();
        fdSqlStatements.top = new FormAttachment((Control)wlSqlStatements, this.margin);
        fdSqlStatements.bottom = new FormAttachment(100, 0);
        fdSqlStatements.left = new FormAttachment(0, 0);
        fdSqlStatements.right = new FormAttachment(100, 0);
        this.wSqlStatements.setLayoutData(fdSqlStatements);
        FormData fdAdvancedComp = new FormData();
        fdAdvancedComp.left = new FormAttachment(0, 0);
        fdAdvancedComp.top = new FormAttachment(0, 0);
        fdAdvancedComp.right = new FormAttachment(100, 0);
        fdAdvancedComp.bottom = new FormAttachment(100, 0);
        wAdvancedComp.setLayoutData((Object)fdAdvancedComp);
        wAdvancedComp.layout();
        wAdvancedTab.setControl((Control)wAdvancedComp);
    }

    private void addOptionsTab() {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.getMetadata();
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOptionsTab.setText("   " + BaseMessages.getString(PKG, (String)"DatabaseDialog.OptionsTab.title", (String[])new String[0]) + "   ");
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wOptionsComp);
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginWidth = PropsUi.getFormMargin() * 2;
        optionsLayout.marginHeight = PropsUi.getFormMargin() * 2;
        wOptionsComp.setLayout((Layout)optionsLayout);
        ColumnInfo[] optionsColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseDialog.column.Parameter", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseDialog.column.Value", (String[])new String[0]), 1, false)};
        optionsColumns[0].setUsingVariables(true);
        optionsColumns[1].setUsingVariables(true);
        Label wlOptions = new Label(wOptionsComp, 16384);
        PropsUi.setLook((Widget)wlOptions);
        wlOptions.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.label.Options", (String[])new String[0]));
        FormData fdlOptions = new FormData();
        fdlOptions.top = new FormAttachment(0, 0);
        fdlOptions.left = new FormAttachment(0, 0);
        fdlOptions.right = new FormAttachment(100, 0);
        wlOptions.setLayoutData((Object)fdlOptions);
        this.wOptions = new TableView(this.manager.getVariables(), wOptionsComp, 2048, optionsColumns, databaseMeta.getExtraOptions().size(), event -> this.setChanged(), this.props);
        PropsUi.setLook((Widget)this.wOptions);
        FormData fdOptions = new FormData();
        fdOptions.top = new FormAttachment((Control)wlOptions, this.margin * 2);
        fdOptions.bottom = new FormAttachment(100, 0);
        fdOptions.left = new FormAttachment(0, 0);
        fdOptions.right = new FormAttachment(100, 0);
        this.wOptions.setLayoutData(fdOptions);
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        fdOptionsComp.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)fdOptionsComp);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void enableFields() {
        boolean manualUrl = StringUtils.isNotEmpty((String)this.wManualUrl.getText()) && StringUtils.isNotBlank((String)this.wManualUrl.getText());
        this.guiCompositeWidgets.enableWidgets(((DatabaseMeta)this.getMetadata()).getIDatabase(), "DatabaseMeta-PluginSpecific-Options", !manualUrl);
    }

    private void test() {
        DatabaseMeta meta = new DatabaseMeta();
        this.getWidgetsContent(meta);
        DatabaseMetaEditor.testConnection(this.getShell(), this.manager.getVariables(), meta);
    }

    private void explore() {
        DatabaseMeta meta = new DatabaseMeta();
        this.getWidgetsContent(meta);
        try {
            DatabaseExplorerDialog dialog = new DatabaseExplorerDialog(this.getShell(), 0, this.manager.getVariables(), meta, this.manager.getSerializer().loadAll());
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error exploring database", e);
        }
    }

    private void onHelpDatabaseType() {
        PluginRegistry registry = PluginRegistry.getInstance();
        String name = this.wConnectionType.getText();
        for (IPlugin plugin : registry.getPlugins(DatabasePluginType.class)) {
            if (!plugin.getName().equals(name)) continue;
            HelpUtils.openHelp(this.getShell(), plugin);
            break;
        }
    }

    @Override
    public void setWidgetsContent() {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.getMetadata();
        this.wName.setText(Const.NVL((String)databaseMeta.getName(), (String)""));
        this.wConnectionType.setText(Const.NVL((String)databaseMeta.getPluginName(), (String)""));
        this.wUsername.setText(Const.NVL((String)databaseMeta.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)databaseMeta.getPassword(), (String)""));
        this.guiCompositeWidgets.setWidgetsContents(databaseMeta.getIDatabase(), this.wDatabaseSpecificComp, "DatabaseMeta-PluginSpecific-Options");
        this.wManualUrl.setText(Const.NVL((String)databaseMeta.getManualUrl(), (String)""));
        this.wSupportsBoolean.setSelection(databaseMeta.supportsBooleanDataType());
        this.wSupportsTimestamp.setSelection(databaseMeta.supportsTimestampDataType());
        this.wQuoteAll.setSelection(databaseMeta.isQuoteAllFields());
        this.wForceLowercase.setSelection(databaseMeta.isForcingIdentifiersToLowerCase());
        this.wForceUppercase.setSelection(databaseMeta.isForcingIdentifiersToUpperCase());
        this.wPreserveCase.setSelection(databaseMeta.preserveReservedCase());
        this.wPreferredSchema.setText(Const.NVL((String)databaseMeta.getPreferredSchemaName(), (String)""));
        this.wSqlStatements.setText(Const.NVL((String)databaseMeta.getConnectSql(), (String)""));
        this.wOptions.clearAll(false);
        Map optionsMap = databaseMeta.getExtraOptionsMap();
        ArrayList options = new ArrayList(optionsMap.keySet());
        Collections.sort(options);
        for (String option : options) {
            String value = (String)optionsMap.get(option);
            TableItem item = new TableItem(this.wOptions.table, 0);
            item.setText(1, Const.NVL((String)option, (String)""));
            item.setText(2, Const.NVL((String)value, (String)""));
        }
        this.wOptions.removeEmptyRows();
        this.wOptions.setRowNums();
        this.wOptions.optWidth(true);
        this.updateDriverInfo();
        this.enableFields();
    }

    @Override
    public void getWidgetsContent(DatabaseMeta meta) {
        meta.setName(this.wName.getText());
        meta.setDatabaseType(this.wConnectionType.getText());
        this.guiCompositeWidgets.getWidgetsContents(meta.getIDatabase(), "DatabaseMeta-PluginSpecific-Options");
        meta.setAccessType(0);
        meta.setManualUrl(this.wManualUrl.getText());
        meta.setUsername(this.wUsername.getText());
        meta.setPassword(this.wPassword.getText());
        meta.setSupportsBooleanDataType(this.wSupportsBoolean.getSelection());
        meta.setSupportsTimestampDataType(this.wSupportsTimestamp.getSelection());
        meta.setQuoteAllFields(this.wQuoteAll.getSelection());
        meta.setForcingIdentifiersToLowerCase(this.wForceLowercase.getSelection());
        meta.setForcingIdentifiersToUpperCase(this.wForceUppercase.getSelection());
        meta.setPreserveReservedCase(this.wPreserveCase.getSelection());
        meta.setPreferredSchemaName(this.wPreferredSchema.getText());
        meta.setConnectSql(this.wSqlStatements.getText());
        meta.getExtraOptions().clear();
        for (int i = 0; i < this.wOptions.nrNonEmpty(); ++i) {
            TableItem item = this.wOptions.getNonEmpty(i);
            String option = item.getText(1);
            String value = item.getText(2);
            meta.addExtraOption(meta.getPluginId(), option, value);
        }
    }

    protected void updateDriverInfo() {
        try {
            DatabaseMeta databaseMeta = new DatabaseMeta();
            this.getWidgetsContent(databaseMeta);
            this.wDriverInfo.setText("");
            Object driverName = databaseMeta.getDriverClass(this.getVariables());
            if (!Utils.isEmpty((CharSequence)driverName)) {
                ClassLoader classLoader = databaseMeta.getIDatabase().getClass().getClassLoader();
                Class<?> driver = classLoader.loadClass((String)driverName);
                if (driver.getPackage().getImplementationVersion() != null) {
                    driverName = (String)driverName + " (" + driver.getPackage().getImplementationVersion() + ")";
                }
                this.wDriverInfo.setText((String)driverName);
            }
        }
        catch (Exception e) {
            this.wDriverInfo.setText("No driver installed");
        }
    }

    public static final void testConnection(Shell shell, IVariables variables, DatabaseMeta databaseMeta) {
        String[] remarks = databaseMeta.checkParameters();
        if (remarks.length == 0) {
            String title;
            DatabaseTestResults databaseTestResults = databaseMeta.testConnectionSuccess(variables);
            Object message = databaseTestResults.getMessage();
            boolean success = databaseTestResults.isSuccess();
            String string = title = success ? BaseMessages.getString(PKG, (String)"DatabaseDialog.DatabaseConnectionTestSuccess.title", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"DatabaseDialog.DatabaseConnectionTest.title", (String[])new String[0]);
            if (success && ((String)message).contains(Const.CR)) {
                message = ((String)message).substring(0, ((String)message).indexOf(Const.CR)) + Const.CR + ((String)message).substring(((String)message).indexOf(Const.CR));
                message = ((String)message).substring(0, ((String)message).lastIndexOf(Const.CR));
            }
            ShowMessageDialog msgDialog = new ShowMessageDialog(shell, 34, title, (String)message, ((String)message).length() > 300);
            msgDialog.setType(success ? 1 : 0);
            msgDialog.open();
        } else {
            Object message = "";
            for (int i = 0; i < remarks.length; ++i) {
                message = (String)message + "    * " + remarks[i] + Const.CR;
            }
            MessageBox mb = new MessageBox(shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.ErrorParameters2.title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseDialog.ErrorParameters2.description", (String[])new String[]{message}));
            mb.open();
        }
    }

    private String[] getConnectionTypes() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(DatabasePluginType.class);
        String[] types = new String[plugins.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((IPlugin)plugins.get(i)).getName();
        }
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        return types;
    }

    @Override
    public Button[] createButtonsForButtonBar(Composite parent) {
        Button wExplore = new Button(parent, 8);
        wExplore.setText(BaseMessages.getString(PKG, (String)"DatabaseDialog.button.Explore", (String[])new String[0]));
        wExplore.addListener(13, e -> this.explore());
        Button wTest = new Button(parent, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        return new Button[]{wExplore, wTest};
    }

    @Override
    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

