/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Props;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.AuditState;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class PropsUi
extends Props {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static double nativeZoomFactor;
    private static final String STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING = "ShowCopyOrDistributeWarning";
    private static final String SHOW_TOOL_TIPS = "ShowToolTips";
    private static final String SHOW_HELP_TOOL_TIPS = "ShowHelpToolTips";
    private static final String HIDE_MENU_BAR = "HideMenuBar";
    private static final String SORT_FIELD_BY_NAME = "SortFieldByName";
    private static final String CANVAS_GRID_SIZE = "CanvasGridSize";
    private static final String LEGACY_PERSPECTIVE_MODE = "LegacyPerspectiveMode";
    private static final String DISABLE_BROWSER_ENVIRONMENT_CHECK = "DisableBrowserEnvironmentCheck";
    private static final String USE_DOUBLE_CLICK_ON_CANVAS = "UseDoubleClickOnCanvas";
    private static final String DRAW_BORDER_AROUND_CANVAS_NAMES = "DrawBorderAroundCanvasNames";
    private static final String USE_GLOBAL_FILE_BOOKMARKS = "UseGlobalFileBookmarks";
    private static final String DARK_MODE = "DarkMode";
    private static final String GLOBAL_ZOOMFACTOR = "GlobalZoomFactor";
    private static final String MAX_EXECUTION_LOGGING_TEXT_SIZE = "MaxExecutionLoggingTextSize";
    public static final int DEFAULT_MAX_EXECUTION_LOGGING_TEXT_SIZE = 2000000;
    private Map<RGB, RGB> contrastingColors;
    private static PropsUi instance;
    protected static final String[] globalZoomFactorLevels;

    public static PropsUi getInstance() {
        if (instance == null) {
            instance = new PropsUi();
        }
        return instance;
    }

    private PropsUi() {
        String hopGuiZoomFactor = System.getProperty("HOP_GUI_ZOOM_FACTOR");
        if (StringUtils.isNotEmpty((String)hopGuiZoomFactor)) {
            this.setProperty(GLOBAL_ZOOMFACTOR, hopGuiZoomFactor);
        }
        this.reCalculateNativeZoomFactor();
        this.setDefault();
    }

    public void reCalculateNativeZoomFactor() {
        double globalZoom = this.getGlobalZoomFactor();
        if (EnvironmentUtils.getInstance().isWeb()) {
            nativeZoomFactor = globalZoom / 0.75;
        } else {
            org.eclipse.swt.graphics.Point extent = TextSizeUtilFacade.textExtent("The quick brown fox jumped over the lazy dog!");
            nativeZoomFactor = (double)extent.y / 16.0 * globalZoom;
        }
    }

    public void setDefault() {
        super.setDefault();
        Display display = Display.getCurrent();
        this.populateContrastingColors();
        if (!EnvironmentUtils.getInstance().isWeb() && !OsHelper.isWindows()) {
            if (Display.isSystemDarkTheme()) {
                if (!this.isDarkMode()) {
                    this.setDarkMode(true);
                }
            } else if (this.isDarkMode()) {
                this.setDarkMode(false);
            }
        }
        if (OsHelper.isWindows() && this.isDarkMode()) {
            display.setData("org.eclipse.swt.internal.win32.useDarkModeExplorerTheme", (Object)true);
            display.setData("org.eclipse.swt.internal.win32.useShellTitleColoring", (Object)true);
            display.setData("org.eclipse.swt.internal.win32.menuBarForegroundColor", (Object)new Color((Device)display, 208, 208, 208));
            display.setData("org.eclipse.swt.internal.win32.menuBarBackgroundColor", (Object)new Color((Device)display, 48, 48, 48));
            display.setData("org.eclipse.swt.internal.win32.menuBarBorderColor", (Object)new Color((Device)display, 80, 80, 80));
            display.setData("org.eclipse.swt.internal.win32.all.use_WS_BORDER", (Object)true);
            display.setData("org.eclipse.swt.internal.win32.Table.headerLineColor", (Object)new Color((Device)display, 80, 80, 80));
            display.setData("org.eclipse.swt.internal.win32.Label.disabledForegroundColor", (Object)new Color((Device)display, 128, 128, 128));
            display.setData("org.eclipse.swt.internal.win32.Combo.useDarkTheme", (Object)true);
            display.setData("org.eclipse.swt.internal.win32.ToolBar.backgroundColor", (Object)new Color((Device)display, 208, 208, 208));
            display.setData("org.eclipse.swt.internal.win32.Combo.backgroundColor", (Object)new Color((Device)display, 208, 208, 208));
            display.setData("org.eclipse.swt.internal.win32.ProgressBar.useColors", (Object)true);
        }
        if (display != null) {
            FontData fontData = this.getDefaultFont();
            this.setProperty("FontDefaultName", fontData.getName());
            this.setProperty("FontDefaultSize", "" + fontData.getHeight());
            this.setProperty("FontDefaultStyle", "" + fontData.getStyle());
            fontData = this.getFixedFont();
            this.setProperty("FontFixedName", fontData.getName());
            this.setProperty("FontFixedSize", "" + fontData.getHeight());
            this.setProperty("FontFixedStyle", "" + fontData.getStyle());
            fontData = this.getGraphFont();
            this.setProperty("FontGraphName", fontData.getName());
            this.setProperty("FontGraphSize", "" + fontData.getHeight());
            this.setProperty("FontGraphStyle", "" + fontData.getStyle());
            fontData = this.getNoteFont();
            this.setProperty("FontNoteName", fontData.getName());
            this.setProperty("FontNoteSize", "" + fontData.getHeight());
            this.setProperty("FontNoteStyle", "" + fontData.getStyle());
            this.setProperty("IconSize", "" + this.getIconSize());
            this.setProperty("LineWidth", "" + this.getLineWidth());
            this.setProperty("MaxUndo", "" + this.getMaxUndo());
        }
    }

    public void setFixedFont(FontData fd) {
        this.setProperty("FontFixedName", fd.getName());
        this.setProperty("FontFixedSize", "" + fd.getHeight());
        this.setProperty("FontFixedStyle", "" + fd.getStyle());
    }

    public FontData getFixedFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontFixedName");
        if (StringUtils.isEmpty((String)name)) {
            name = Const.isWindows() ? "Consolas" : (Const.isLinux() ? "Monospace" : (Const.isOSX() ? "Monaco" : (EnvironmentUtils.getInstance().isWeb() ? "monospace" : "Monospaced")));
        }
        int size = Const.toInt((String)this.getProperty("FontFixedSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontFixedStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public FontData getDefaultFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontDefaultName", def.getName());
        int size = Const.toInt((String)this.getProperty("FontDefaultSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontDefaultStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setDefaultFont(FontData fd) {
        this.setProperty("FontDefaultName", fd.getName());
        this.setProperty("FontDefaultSize", "" + fd.getHeight());
        this.setProperty("FontDefaultStyle", "" + fd.getStyle());
    }

    public void setGraphFont(FontData fd) {
        this.setProperty("FontGraphName", fd.getName());
        this.setProperty("FontGraphSize", "" + fd.getHeight());
        this.setProperty("FontGraphStyle", "" + fd.getStyle());
    }

    public FontData getGraphFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontGraphName", def.getName());
        int size = Const.toInt((String)this.getProperty("FontGraphSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontGraphStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setNoteFont(FontData fd) {
        this.setProperty("FontNoteName", fd.getName());
        this.setProperty("FontNoteSize", "" + fd.getHeight());
        this.setProperty("FontNoteStyle", "" + fd.getStyle());
    }

    public FontData getNoteFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontNoteName", def.getName());
        int size = Const.toInt((String)this.getProperty("FontNoteSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontNoteStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setIconSize(int size) {
        this.setProperty("IconSize", "" + size);
    }

    public int getIconSize() {
        return Const.toInt((String)this.getProperty("IconSize"), (int)32);
    }

    public void setZoomFactor(double factor) {
        this.setProperty("ZoomFactor", Double.toString(factor));
    }

    public double getZoomFactor() {
        return PropsUi.getNativeZoomFactor();
    }

    public static int getMargin() {
        return (int)Math.round(4.0 * PropsUi.getNativeZoomFactor());
    }

    public void setLineWidth(int width) {
        this.setProperty("LineWidth", "" + width);
    }

    public int getLineWidth() {
        return Const.toInt((String)this.getProperty("LineWidth"), (int)1);
    }

    public void setLastPreview(String[] lastpreview, int[] transformsize) {
        this.setProperty("LastPreviewTransform", "" + lastpreview.length);
        for (int i = 0; i < lastpreview.length; ++i) {
            this.setProperty("LastPreviewTransform" + (i + 1), lastpreview[i]);
            this.setProperty("LastPreviewSize" + (i + 1), "" + transformsize[i]);
        }
    }

    public String[] getLastPreview() {
        String snr = this.getProperty("LastPreviewTransform");
        int nr = Const.toInt((String)snr, (int)0);
        String[] lp = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lp[i] = this.getProperty("LastPreviewTransform" + (i + 1), "");
        }
        return lp;
    }

    public int[] getLastPreviewSize() {
        String snr = this.getProperty("LastPreviewTransform");
        int nr = Const.toInt((String)snr, (int)0);
        int[] si = new int[nr];
        for (int i = 0; i < nr; ++i) {
            si[i] = Const.toInt((String)this.getProperty("LastPreviewSize" + (i + 1), ""), (int)0);
        }
        return si;
    }

    public FontData getDefaultFontData() {
        return Display.getCurrent().getSystemFont().getFontData()[0];
    }

    public void setMaxUndo(int max) {
        this.setProperty("MaxUndo", "" + max);
    }

    public int getMaxUndo() {
        return Const.toInt((String)this.getProperty("MaxUndo"), (int)100);
    }

    public void setMiddlePct(int pct) {
        this.setProperty("MiddlePct", "" + pct);
    }

    public int getMiddlePct() {
        return Const.toInt((String)this.getProperty("MiddlePct"), (int)35);
    }

    public static int getFormMargin() {
        return (int)Math.round(5.0 * PropsUi.getNativeZoomFactor());
    }

    public void setScreen(WindowProperty windowProperty) {
        AuditManager.storeState((ILogChannel)LogChannel.UI, (String)"hop-gui", (String)"shells", (String)windowProperty.getName(), windowProperty.getStateProperties());
    }

    public WindowProperty getScreen(String windowName) {
        if (windowName == null) {
            return null;
        }
        AuditState auditState = AuditManager.retrieveState((ILogChannel)LogChannel.UI, (String)"hop-gui", (String)"shells", (String)windowName);
        if (auditState == null) {
            return null;
        }
        return new WindowProperty(windowName, auditState.getStateMap());
    }

    public void setOpenLastFile(boolean open) {
        this.setProperty("OpenLastFile", open ? "Y" : "N");
    }

    public boolean openLastFile() {
        String open = this.getProperty("OpenLastFile");
        return !"N".equalsIgnoreCase(open);
    }

    public void setAutoSave(boolean autosave) {
        this.setProperty("AutoSave", autosave ? "Y" : "N");
    }

    public boolean getAutoSave() {
        String autosave = this.getProperty("AutoSave");
        return "Y".equalsIgnoreCase(autosave);
    }

    public void setSaveConfirmation(boolean saveconf) {
        this.setProperty("SaveConfirmation", saveconf ? "Y" : "N");
    }

    public boolean getSaveConfirmation() {
        String saveconf = this.getProperty("SaveConfirmation");
        return "Y".equalsIgnoreCase(saveconf);
    }

    public void setAutoSplit(boolean autosplit) {
        this.setProperty("AutoSplit", autosplit ? "Y" : "N");
    }

    public boolean getAutoSplit() {
        String autosplit = this.getProperty("AutoSplit");
        return "Y".equalsIgnoreCase(autosplit);
    }

    public void setExitWarningShown(boolean show) {
        this.setProperty("ShowExitWarning", show ? "Y" : "N");
    }

    public boolean isShowCanvasGridEnabled() {
        String showCanvas = this.getProperty("ShowCanvasGrid", "N");
        return "Y".equalsIgnoreCase(showCanvas);
    }

    public void setShowCanvasGridEnabled(boolean anti) {
        this.setProperty("ShowCanvasGrid", anti ? "Y" : "N");
    }

    public boolean isHideViewportEnabled() {
        String showViewport = this.getProperty("HideViewport", "N");
        return "Y".equalsIgnoreCase(showViewport);
    }

    public void setHideViewportEnabled(boolean anti) {
        this.setProperty("HideViewport", anti ? "Y" : "N");
    }

    public boolean showExitWarning() {
        String show = this.getProperty("ShowExitWarning", "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public boolean isShowTableViewToolbar() {
        String show = this.getProperty("ShowTableViewToolbar", "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public void setShowTableViewToolbar(boolean show) {
        this.setProperty("ShowTableViewToolbar", show ? "Y" : "N");
    }

    public static void setLook(Widget widget) {
        int style = 0;
        if (widget instanceof Table) {
            style = 2;
        } else if (widget instanceof Tree) {
            style = 7;
        } else if (widget instanceof ToolBar) {
            style = 5;
        } else if (widget instanceof CTabFolder) {
            style = 4;
        } else if (OS.contains("mac") && widget instanceof Group) {
            style = 3;
        } else if (widget instanceof Button) {
            style = Const.isWindows() && (widget.getStyle() & 0x30) != 0 ? 0 : 6;
        }
        PropsUi.setLook(widget, style);
        if (widget instanceof Composite) {
            Composite compositeWidget;
            Composite composite = compositeWidget = (Composite)widget;
            for (Control child : composite.getChildren()) {
                PropsUi.setLook((Widget)child);
            }
        }
    }

    public static void setLook(Widget widget, int style) {
        if (OsHelper.isWindows()) {
            PropsUi.setLookOnWindows(widget, style);
        } else if (OsHelper.isMac()) {
            PropsUi.setLookOnMac(widget, style);
        } else {
            PropsUi.setLookOnLinux(widget, style);
        }
    }

    protected static void setLookOnWindows(Widget widget, int style) {
        Control controlWidget;
        GuiResource gui = GuiResource.getInstance();
        Font font = gui.getFontDefault();
        Color background = null;
        Color foreground = null;
        if (widget instanceof Shell) {
            Shell shellWidget = (Shell)widget;
            background = gui.getColorWhite();
            foreground = gui.getColorBlack();
            Shell shell = shellWidget;
            shell.setBackgroundMode(2);
            shell.setForeground(gui.getColorBlack());
            shell.setBackground(gui.getColorWhite());
            return;
        }
        switch (style) {
            case 0: {
                background = gui.getColorWhite();
                foreground = gui.getColorBlack();
                break;
            }
            case 1: {
                font = gui.getFontFixed();
                background = gui.getColorWhite();
                foreground = gui.getColorBlack();
                break;
            }
            case 2: {
                if (!PropsUi.getInstance().isDarkMode()) break;
                background = gui.getColorWhite();
                foreground = gui.getColorBlack();
                Table table = (Table)widget;
                table.setHeaderBackground(gui.getColorLightGray());
                table.setHeaderForeground(gui.getColorDarkGray());
                break;
            }
            case 7: {
                if (!PropsUi.getInstance().isDarkMode()) break;
                background = gui.getColorWhite();
                foreground = gui.getColorBlack();
                Tree tree = (Tree)widget;
                tree.setHeaderBackground(gui.getColorLightGray());
                tree.setHeaderForeground(gui.getColorDarkGray());
                break;
            }
            case 5: {
                if (!PropsUi.getInstance().isDarkMode()) break;
                background = gui.getColorLightGray();
                foreground = gui.getColorBlack();
                break;
            }
            case 4: {
                CTabFolder tabFolder = (CTabFolder)widget;
                tabFolder.setBorderVisible(true);
                tabFolder.setTabHeight(28);
                if (!PropsUi.getInstance().isDarkMode()) break;
                tabFolder.setBackground(gui.getColorWhite());
                tabFolder.setForeground(gui.getColorBlack());
                tabFolder.setSelectionBackground(gui.getColorWhite());
                tabFolder.setSelectionForeground(gui.getColorBlack());
                break;
            }
            case 6: {
                break;
            }
            default: {
                background = gui.getColorGray();
                font = null;
            }
        }
        if (font != null && !font.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setFont(font);
        }
        if (background != null && !background.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setBackground(background);
        }
        if (foreground != null && !foreground.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setForeground(foreground);
        }
    }

    protected static void setLookOnMac(Widget widget, int style) {
        Control controlWidget;
        GuiResource gui = GuiResource.getInstance();
        Font font = gui.getFontDefault();
        Color background = gui.getColorWhite();
        Color foreground = gui.getColorBlack();
        switch (style) {
            case 0: {
                break;
            }
            case 3: {
                background = gui.getColorWhite();
                foreground = gui.getColorBlack();
                font = gui.getFontDefault();
                Group group = (Group)widget;
                group.addPaintListener(paintEvent -> {
                    paintEvent.gc.setForeground(gui.getColorBlack());
                    paintEvent.gc.setBackground(gui.getColorWhite());
                    paintEvent.gc.fillRectangle(2, 0, group.getBounds().width - 8, group.getBounds().height - 20);
                });
                break;
            }
            case 1: {
                font = gui.getFontFixed();
                break;
            }
            case 2: {
                background = gui.getColorLightGray();
                foreground = gui.getColorDarkGray();
                Table table = (Table)widget;
                table.setHeaderBackground(gui.getColorLightGray());
                table.setHeaderForeground(gui.getColorDarkGray());
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                if (PropsUi.getInstance().isDarkMode()) {
                    background = gui.getColorLightGray();
                    break;
                }
                background = gui.getColorDemoGray();
                break;
            }
            case 4: {
                CTabFolder tabFolder = (CTabFolder)widget;
                tabFolder.setBorderVisible(true);
                tabFolder.setBackground(gui.getColorGray());
                tabFolder.setForeground(gui.getColorBlack());
                tabFolder.setSelectionBackground(gui.getColorWhite());
                tabFolder.setSelectionForeground(gui.getColorBlack());
                break;
            }
            case 6: {
                background = null;
                foreground = null;
                break;
            }
            default: {
                background = gui.getColorBackground();
                font = null;
            }
        }
        if (font != null && !font.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setFont(font);
        }
        if (background != null && !background.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setBackground(background);
        }
        if (foreground != null && !foreground.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setForeground(foreground);
        }
    }

    protected static void setLookOnLinux(Widget widget, int style) {
        Control controlWidget;
        GuiResource gui = GuiResource.getInstance();
        Font font = gui.getFontDefault();
        Color background = gui.getColorWhite();
        Color foreground = gui.getColorBlack();
        switch (style) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                font = gui.getFontFixed();
                break;
            }
            case 2: {
                background = gui.getColorLightGray();
                foreground = gui.getColorDarkGray();
                Table table = (Table)widget;
                table.setHeaderBackground(gui.getColorLightGray());
                table.setHeaderForeground(gui.getColorDarkGray());
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                if (PropsUi.getInstance().isDarkMode()) {
                    background = gui.getColorLightGray();
                    break;
                }
                background = gui.getColorDemoGray();
                break;
            }
            case 4: {
                CTabFolder tabFolder = (CTabFolder)widget;
                tabFolder.setBorderVisible(true);
                tabFolder.setBackground(gui.getColorGray());
                tabFolder.setForeground(gui.getColorBlack());
                tabFolder.setSelectionBackground(gui.getColorWhite());
                tabFolder.setSelectionForeground(gui.getColorBlack());
                break;
            }
            case 6: {
                background = null;
                foreground = null;
                break;
            }
            default: {
                background = gui.getColorBackground();
                font = null;
            }
        }
        if (font != null && !font.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setFont(font);
        }
        if (background != null && !background.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setBackground(background);
        }
        if (foreground != null && !foreground.isDisposed() && widget instanceof Control) {
            controlWidget = (Control)widget;
            controlWidget.setForeground(foreground);
        }
    }

    public static Display getDisplay() {
        return Display.getCurrent();
    }

    public void setDefaultPreviewSize(int size) {
        this.setProperty("DefaultPreviewSize", "" + size);
    }

    public int getDefaultPreviewSize() {
        return Const.toInt((String)this.getProperty("DefaultPreviewSize"), (int)1000);
    }

    public boolean showCopyOrDistributeWarning() {
        String show = this.getProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public void setShowCopyOrDistributeWarning(boolean show) {
        this.setProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, show ? "Y" : "N");
    }

    public void setDialogSize(Shell shell, String styleProperty) {
        String prop = this.getProperty(styleProperty);
        if (Utils.isEmpty((CharSequence)prop)) {
            return;
        }
        String[] xy = prop.split(",");
        if (xy.length != 2) {
            return;
        }
        shell.setSize(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
    }

    public boolean useDoubleClick() {
        return "Y".equalsIgnoreCase(this.getProperty(USE_DOUBLE_CLICK_ON_CANVAS, "N"));
    }

    public void setUseDoubleClickOnCanvas(boolean use) {
        this.setProperty(USE_DOUBLE_CLICK_ON_CANVAS, use ? "Y" : "N");
    }

    public boolean isBorderDrawnAroundCanvasNames() {
        return "Y".equalsIgnoreCase(this.getProperty(DRAW_BORDER_AROUND_CANVAS_NAMES, "N"));
    }

    public void setDrawBorderAroundCanvasNames(boolean draw) {
        this.setProperty(DRAW_BORDER_AROUND_CANVAS_NAMES, draw ? "Y" : "N");
    }

    public boolean useGlobalFileBookmarks() {
        return "Y".equalsIgnoreCase(this.getProperty(USE_GLOBAL_FILE_BOOKMARKS, "Y"));
    }

    public void setUseGlobalFileBookmarks(boolean use) {
        this.setProperty(USE_GLOBAL_FILE_BOOKMARKS, use ? "Y" : "N");
    }

    public boolean isDarkMode() {
        return "Y".equalsIgnoreCase(this.getProperty(DARK_MODE, "N"));
    }

    public void setDarkMode(boolean darkMode) {
        this.setProperty(DARK_MODE, darkMode ? "Y" : "N");
    }

    public boolean showToolTips() {
        return "Y".equalsIgnoreCase(this.getProperty(SHOW_TOOL_TIPS, "Y"));
    }

    public void setShowToolTips(boolean show) {
        this.setProperty(SHOW_TOOL_TIPS, show ? "Y" : "N");
    }

    public boolean isShowingHelpToolTips() {
        return "Y".equalsIgnoreCase(this.getProperty(SHOW_HELP_TOOL_TIPS, "Y"));
    }

    public void setHidingMenuBar(boolean show) {
        this.setProperty(HIDE_MENU_BAR, show ? "Y" : "N");
    }

    public boolean isHidingMenuBar() {
        return "Y".equalsIgnoreCase(System.getProperty("HOP_GUI_HIDE_MENU", this.getProperty(HIDE_MENU_BAR, "Y")));
    }

    public void setSortFieldByName(boolean sort) {
        this.setProperty(SORT_FIELD_BY_NAME, sort ? "Y" : "N");
    }

    public boolean isSortFieldByName() {
        return "Y".equalsIgnoreCase(System.getProperty(SORT_FIELD_BY_NAME, this.getProperty(SORT_FIELD_BY_NAME, "Y")));
    }

    public void setShowingHelpToolTips(boolean show) {
        this.setProperty(SHOW_HELP_TOOL_TIPS, show ? "Y" : "N");
    }

    public int getCanvasGridSize() {
        return Const.toInt((String)this.getProperty(CANVAS_GRID_SIZE, "16"), (int)16);
    }

    public void setCanvasGridSize(int gridSize) {
        this.setProperty(CANVAS_GRID_SIZE, Integer.toString(gridSize));
    }

    public int getSupportedVersion(String property) {
        return Integer.parseInt(this.getProperty(property));
    }

    public boolean isBrowserEnvironmentCheckDisabled() {
        return "Y".equalsIgnoreCase(this.getProperty(DISABLE_BROWSER_ENVIRONMENT_CHECK, "N"));
    }

    public boolean isLegacyPerspectiveMode() {
        return "Y".equalsIgnoreCase(this.getProperty(LEGACY_PERSPECTIVE_MODE, "N"));
    }

    public static void setLocation(IGuiPosition guiElement, int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        guiElement.setLocation(PropsUi.calculateGridPosition(new Point(x, y)));
    }

    public static Point calculateGridPosition(Point p) {
        int gridSize = PropsUi.getInstance().getCanvasGridSize();
        if (gridSize > 1) {
            return new Point(gridSize * Math.round((float)p.x / (float)gridSize), gridSize * Math.round((float)p.y / (float)gridSize));
        }
        return p;
    }

    public boolean isIndicateSlowPipelineTransformsEnabled() {
        String indicate = this.getProperty("IndicateSlowPipelineTransforms", "Y");
        return "Y".equalsIgnoreCase(indicate);
    }

    public void setIndicateSlowPipelineTransformsEnabled(boolean indicate) {
        this.setProperty("IndicateSlowPipelineTransforms", indicate ? "Y" : "N");
    }

    public static double getNativeZoomFactor() {
        return nativeZoomFactor;
    }

    public static void setNativeZoomFactor(double nativeZoomFactor) {
        PropsUi.nativeZoomFactor = nativeZoomFactor;
    }

    private void populateContrastingColors() {
        this.contrastingColors = new HashMap<RGB, RGB>();
        this.contrastingColors.put(this.toRGB("#000000"), this.toRGB("#ffffff"));
        this.contrastingColors.put(this.toRGB("#0e3a5a"), this.toRGB("#c8e7fa"));
        this.contrastingColors.put(this.toRGB("#0f3b5a"), this.toRGB("#c7e6fa"));
        this.contrastingColors.put(this.toRGB("#f0f0f0"), this.toRGB("#0f0f0f"));
        this.contrastingColors.put(this.toRGB("#e1e1e1"), this.toRGB("#303030"));
        this.contrastingColors.put(this.toRGB("#646464"), this.toRGB("#707070"));
        this.contrastingColors.put(this.toRGB("#ffd700"), this.toRGB("#0028ff"));
        this.contrastingColors.put(this.toRGB("#033d5d"), this.toRGB("#36b3f8"));
        this.contrastingColors.put(this.toRGB("#eeffaa"), this.toRGB("#556a00"));
        this.contrastingColors.put(this.toRGB("#c9e8fb"), this.toRGB("#0f88d2"));
        this.contrastingColors.put(new RGB(254, 254, 254), new RGB(35, 35, 35));
        this.contrastingColors.put(new RGB(245, 245, 245), new RGB(40, 40, 40));
        this.contrastingColors.put(new RGB(240, 240, 240), new RGB(45, 45, 45));
        this.contrastingColors.put(new RGB(235, 235, 235), new RGB(50, 50, 50));
        this.contrastingColors.put(new RGB(225, 225, 225), new RGB(70, 70, 70));
        this.contrastingColors.put(new RGB(215, 215, 215), new RGB(100, 100, 100));
        this.contrastingColors.put(new RGB(100, 100, 100), new RGB(215, 215, 215));
        this.contrastingColors.put(new RGB(50, 50, 50), new RGB(235, 235, 235));
        HashMap inverse = new HashMap();
        this.contrastingColors.keySet().stream().forEach(key -> inverse.put(this.contrastingColors.get(key), key));
        this.contrastingColors.putAll(inverse);
    }

    private RGB toRGB(String colorString) {
        int red = Integer.valueOf(colorString.substring(1, 3), 16);
        int green = Integer.valueOf(colorString.substring(3, 5), 16);
        int blue = Integer.valueOf(colorString.substring(5, 7), 16);
        return new RGB(red, green, blue);
    }

    public RGB contrastColor(RGB rgb) {
        RGB contrastingRGB;
        if (PropsUi.getInstance().isDarkMode() && (contrastingRGB = this.contrastingColors.get(rgb)) != null) {
            return contrastingRGB;
        }
        return rgb;
    }

    public RGB contrastColor(int r, int g, int b) {
        return this.contrastColor(new RGB(r, g, b));
    }

    public Map<String, String> getContrastingColorStrings() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<RGB, RGB> entry : this.contrastingColors.entrySet()) {
            RGB rgb = entry.getKey();
            RGB contrastingRGB = entry.getValue();
            String fromColor = this.toColorString(rgb);
            String toColor = this.toColorString(contrastingRGB);
            map.put(fromColor.toLowerCase(), toColor);
            map.put(fromColor.toUpperCase(), toColor);
        }
        return map;
    }

    private String toColorString(RGB rgb) {
        Object r = Integer.toString(rgb.red, 16);
        r = ((String)r).length() == 1 ? "0" + (String)r : r;
        Object g = Integer.toString(rgb.green, 16);
        g = ((String)g).length() == 1 ? "0" + (String)g : g;
        Object b = Integer.toString(rgb.blue, 16);
        b = ((String)b).length() == 1 ? "0" + (String)b : b;
        return ("#" + (String)r + (String)g + (String)b).toLowerCase();
    }

    public Map<RGB, RGB> getContrastingColors() {
        return this.contrastingColors;
    }

    public void setContrastingColors(Map<RGB, RGB> contrastingColors) {
        this.contrastingColors = contrastingColors;
    }

    public double getGlobalZoomFactor() {
        return Const.toDouble((String)this.getProperty(GLOBAL_ZOOMFACTOR, "1.0"), (double)1.0);
    }

    public void setGlobalZoomFactor(double globalZoomFactor) {
        this.setProperty(GLOBAL_ZOOMFACTOR, Double.toString(globalZoomFactor));
    }

    public int getMaxExecutionLoggingTextSize() {
        return Const.toInt((String)this.getProperty(MAX_EXECUTION_LOGGING_TEXT_SIZE, Integer.toString(2000000)), (int)2000000);
    }

    public void setMaxExecutionLoggingTextSize(int maxExecutionLoggingTextSize) {
        this.setProperty(MAX_EXECUTION_LOGGING_TEXT_SIZE, Integer.toString(maxExecutionLoggingTextSize));
    }

    public static final String[] getGlobalZoomFactorLevels() {
        return globalZoomFactorLevels;
    }

    public Layout createFormLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = PropsUi.getFormMargin();
        formLayout.marginTop = PropsUi.getFormMargin();
        formLayout.marginBottom = PropsUi.getFormMargin();
        formLayout.marginRight = PropsUi.getFormMargin();
        return formLayout;
    }

    static {
        globalZoomFactorLevels = new String[]{"200%", "175%", "150%", "140%", "130%", "120%", "110%", "100%", "90%", "80%", "70%"};
    }
}

