/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pipelineexecutor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorMeta;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorParameters;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PipelineExecutorDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = PipelineExecutorDialog.class;
    private static final int FIELD_DESCRIPTION = 1;
    private static final int FIELD_NAME = 2;
    private PipelineExecutorMeta pipelineExecutorMeta;
    private Label wlPath;
    private TextVar wPath;
    protected Label wlRunConfiguration;
    protected ComboVar wRunConfiguration;
    private Button wbPipelineNameInField;
    private Label wlPipelineNameField;
    private ComboVar wPipelineNameField;
    private CTabFolder wTabFolder;
    private PipelineMeta executorPipelineMeta = null;
    private Button wInheritAll;
    private TableView wPipelineExecutorParameters;
    private Label wlGroupSize;
    private TextVar wGroupSize;
    private Label wlGroupField;
    private CCombo wGroupField;
    private Label wlGroupTime;
    private TextVar wGroupTime;
    private CCombo wExecutionResultTarget;
    private TableItem tiExecutionTimeField;
    private TableItem tiExecutionResultField;
    private TableItem tiExecutionNrErrorsField;
    private TableItem tiExecutionLinesReadField;
    private TableItem tiExecutionLinesWrittenField;
    private TableItem tiExecutionLinesInputField;
    private TableItem tiExecutionLinesOutputField;
    private TableItem tiExecutionLinesRejectedField;
    private TableItem tiExecutionLinesUpdatedField;
    private TableItem tiExecutionLinesDeletedField;
    private TableItem tiExecutionFilesRetrievedField;
    private TableItem tiExecutionExitStatusField;
    private TableItem tiExecutionLogTextField;
    private TableItem tiExecutionLogChannelIdField;
    private String executorOutputTransform;
    private ColumnInfo[] parameterColumns;
    private CCombo wResultFilesTarget;
    private TextVar wResultFileNameField;
    private CCombo wOutputRowsSource;
    private TableView wOutputFields;
    private boolean gotPreviousFields = false;
    private final int middle = this.props.getMiddlePct();
    private final int margin = PropsUi.getMargin();

    public PipelineExecutorDialog(Shell parent, IVariables variables, PipelineExecutorMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.pipelineExecutorMeta = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.pipelineExecutorMeta);
        this.changed = this.pipelineExecutorMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Shell.Title", (String[])new String[0]));
        ModifyListener lsMod = e -> this.pipelineExecutorMeta.setChanged();
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wicon);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        PipelineExecutorDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)PropsUi.getMargin(), null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment((Control)wicon, 0, 0x1000000);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.right = new FormAttachment((Control)wicon, 0);
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)wicon, 0);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Pipeline.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(this.middle, -this.margin);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        Button wbBrowse = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbBrowse);
        wbBrowse.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, 0, 0x1000000);
        wbBrowse.setLayoutData((Object)fdBrowse);
        wbBrowse.addListener(13, e -> this.selectPipelineFile());
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(this.middle, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 0, 0x1000000);
        fdTransformation.right = new FormAttachment((Control)wbBrowse, -this.margin);
        this.wPath.setLayoutData((Object)fdTransformation);
        this.wbPipelineNameInField = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wbPipelineNameInField);
        this.wbPipelineNameInField.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.PipelineNameInField.Label", (String[])new String[0]));
        FormData fdPipelineNameInField = new FormData();
        fdPipelineNameInField.left = new FormAttachment(this.middle, 0);
        fdPipelineNameInField.top = new FormAttachment((Control)this.wPath, this.margin);
        this.wbPipelineNameInField.setLayoutData((Object)fdPipelineNameInField);
        this.wbPipelineNameInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineExecutorDialog.this.pipelineExecutorMeta.setChanged();
                PipelineExecutorDialog.this.activePipelineNameField();
            }
        });
        this.wlPipelineNameField = new Label((Composite)this.shell, 131072);
        this.wlPipelineNameField.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.PipelineNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPipelineNameField);
        FormData fdlPipelineNameField = new FormData();
        fdlPipelineNameField.left = new FormAttachment(0, 0);
        fdlPipelineNameField.right = new FormAttachment(this.middle, -this.margin);
        fdlPipelineNameField.top = new FormAttachment((Control)this.wbPipelineNameInField, this.margin);
        this.wlPipelineNameField.setLayoutData((Object)fdlPipelineNameField);
        this.wPipelineNameField = new ComboVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPipelineNameField);
        this.wPipelineNameField.addModifyListener(lsMod);
        FormData fdPipelineNameField = new FormData();
        fdPipelineNameField.left = new FormAttachment(this.middle, 0);
        fdPipelineNameField.top = new FormAttachment((Control)this.wlPipelineNameField, 0, 0x1000000);
        fdPipelineNameField.right = new FormAttachment(100, 0);
        this.wPipelineNameField.setLayoutData((Object)fdPipelineNameField);
        this.wPipelineNameField.setEnabled(false);
        this.wPipelineNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)PipelineExecutorDialog.this.shell.getDisplay(), 1);
                PipelineExecutorDialog.this.shell.setCursor(busy);
                PipelineExecutorDialog.this.getFields();
                PipelineExecutorDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlRunConfiguration = new Label((Composite)this.shell, 131072);
        this.wlRunConfiguration.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.RunConfiguration.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRunConfiguration);
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.left = new FormAttachment(0, 0);
        fdlRunConfiguration.top = new FormAttachment((Control)this.wPipelineNameField, this.margin);
        fdlRunConfiguration.right = new FormAttachment(this.middle, -this.margin);
        this.wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar(this.variables, (Composite)this.shell, 18432);
        PropsUi.setLook((Widget)this.wlRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(this.middle, 0);
        fdRunConfiguration.top = new FormAttachment((Control)this.wlRunConfiguration, 0, 0x1000000);
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
        PropsUi.setLook((Widget)this.wRunConfiguration);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.wTabFolder.setUnselectedCloseVisible(true);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wRunConfiguration, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addParametersTab();
        this.addExecutionResultTab();
        this.addRowGroupTab();
        this.addResultRowsTab();
        this.addResultFilesTab();
        this.getData();
        this.pipelineExecutorMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wPipelineNameField.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wPipelineNameField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wPipelineNameField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TextFileOutputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileOutputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/pipelineexecutor.svg", (int)48, (int)48);
    }

    private void selectPipelineFile() {
        String parentFolder = null;
        try {
            parentFolder = HopVfs.getFileObject((String)this.variables.resolve(this.pipelineMeta.getFilename()), (IVariables)this.variables).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            HopPipelineFileType fileType = HopGui.getDataOrchestrationPerspective().getPipelineFileType();
            String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])fileType.getFilterExtensions(), (String[])fileType.getFilterNames(), (boolean)true);
            if (filename != null) {
                this.loadPipelineFile(filename);
                if (parentFolder != null && filename.startsWith(parentFolder)) {
                    filename = filename.replace(parentFolder, "${Internal.Entry.Current.Folder}");
                }
                this.wPath.setText(filename);
            }
            if (filename != null) {
                this.replaceNameWithBaseFilename(filename);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingPipeline.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingPipeline.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadPipelineFile(String fname) throws HopException {
        String filename = this.variables.resolve(fname);
        this.executorPipelineMeta = new PipelineMeta(filename, this.metadataProvider, this.variables);
        this.executorPipelineMeta.clearChanged();
    }

    void loadPipeline() throws HopException {
        Object filename = this.wPath.getText();
        if (Utils.isEmpty((CharSequence)filename)) {
            return;
        }
        if (!((String)filename).endsWith(".hpl")) {
            filename = (String)filename + ".hpl";
            this.wPath.setText((String)filename);
        }
        this.loadPipelineFile((String)filename);
    }

    public void getData() {
        this.wPath.setText(Const.NVL((String)this.pipelineExecutorMeta.getFilename(), (String)""));
        try {
            List runConfigurations = this.metadataProvider.getSerializer(PipelineRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.pipelineExecutorMeta.getRunConfigurationName(), (String)""));
            this.wbPipelineNameInField.setSelection(this.pipelineExecutorMeta.isFilenameInField());
            if (this.pipelineExecutorMeta.getFilenameField() != null) {
                this.wPipelineNameField.setText(this.pipelineExecutorMeta.getFilenameField());
            }
            this.activePipelineNameField();
            if (Utils.isEmpty((CharSequence)this.pipelineExecutorMeta.getRunConfigurationName())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.pipelineExecutorMeta.getRunConfigurationName());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting pipeline run configurations", (Throwable)e);
        }
        try {
            Object[] prevTransforms = this.pipelineMeta.getTransformNames();
            Arrays.sort(prevTransforms);
            this.wExecutionResultTarget.setItems((String[])prevTransforms);
            this.wResultFilesTarget.setItems((String[])prevTransforms);
            this.wOutputRowsSource.setItems((String[])prevTransforms);
            String[] inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
            this.parameterColumns[1].setComboValues(inputFields);
            this.wGroupField.setItems(inputFields);
        }
        catch (Exception e) {
            this.log.logError("couldn't get previous transform list", (Throwable)e);
        }
        this.wGroupSize.setText(Const.NVL((String)this.pipelineExecutorMeta.getGroupSize(), (String)""));
        this.wGroupTime.setText(Const.NVL((String)this.pipelineExecutorMeta.getGroupTime(), (String)""));
        this.wGroupField.setText(Const.NVL((String)this.pipelineExecutorMeta.getGroupField(), (String)""));
        this.wExecutionResultTarget.setText(this.pipelineExecutorMeta.getExecutionResultTargetTransformMeta() == null ? "" : this.pipelineExecutorMeta.getExecutionResultTargetTransformMeta().getName());
        this.tiExecutionTimeField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionTimeField(), (String)""));
        this.tiExecutionResultField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionResultField(), (String)""));
        this.tiExecutionNrErrorsField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionNrErrorsField(), (String)""));
        this.tiExecutionLinesReadField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesReadField(), (String)""));
        this.tiExecutionLinesWrittenField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesWrittenField(), (String)""));
        this.tiExecutionLinesInputField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesInputField(), (String)""));
        this.tiExecutionLinesOutputField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesOutputField(), (String)""));
        this.tiExecutionLinesRejectedField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesRejectedField(), (String)""));
        this.tiExecutionLinesUpdatedField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesUpdatedField(), (String)""));
        this.tiExecutionLinesDeletedField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesDeletedField(), (String)""));
        this.tiExecutionFilesRetrievedField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionFilesRetrievedField(), (String)""));
        this.tiExecutionExitStatusField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionExitStatusField(), (String)""));
        this.tiExecutionLogTextField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLogTextField(), (String)""));
        this.tiExecutionLogChannelIdField.setText(2, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLogChannelIdField(), (String)""));
        if (this.pipelineExecutorMeta.getExecutorsOutputTransformMeta() != null) {
            this.executorOutputTransform = this.pipelineExecutorMeta.getExecutorsOutputTransformMeta().getName();
        }
        this.wResultFilesTarget.setText(this.pipelineExecutorMeta.getResultFilesTargetTransformMeta() == null ? "" : this.pipelineExecutorMeta.getResultFilesTargetTransformMeta().getName());
        this.wResultFileNameField.setText(Const.NVL((String)this.pipelineExecutorMeta.getResultFilesFileNameField(), (String)""));
        this.wOutputRowsSource.setText(this.pipelineExecutorMeta.getOutputRowsSourceTransformMeta() == null ? "" : this.pipelineExecutorMeta.getOutputRowsSourceTransformMeta().getName());
        for (int i = 0; i < this.pipelineExecutorMeta.getOutputRowsField().length; ++i) {
            TableItem item = new TableItem(this.wOutputFields.table, 0);
            item.setText(1, Const.NVL((String)this.pipelineExecutorMeta.getOutputRowsField()[i], (String)""));
            item.setText(2, ValueMetaFactory.getValueMetaName((int)this.pipelineExecutorMeta.getOutputRowsType()[i]));
            int length = this.pipelineExecutorMeta.getOutputRowsLength()[i];
            item.setText(3, length < 0 ? "" : Integer.toString(length));
            int precision = this.pipelineExecutorMeta.getOutputRowsPrecision()[i];
            item.setText(4, precision < 0 ? "" : Integer.toString(precision));
        }
        this.wOutputFields.removeEmptyRows();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        this.wTabFolder.setSelection(0);
        try {
            this.loadPipeline();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void addParametersTab() {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setFont(GuiResource.getInstance().getFontDefault());
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        Button wGetParameters = new Button(wParametersComposite, 8);
        wGetParameters.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.GetParameters", (String[])new String[0]));
        PropsUi.setLook((Widget)wGetParameters);
        FormData fdGetParameters = new FormData();
        fdGetParameters.bottom = new FormAttachment(100, 0);
        fdGetParameters.right = new FormAttachment(100, 0);
        wGetParameters.setLayoutData((Object)fdGetParameters);
        wGetParameters.setSelection(this.pipelineExecutorMeta.getParameters().isInheritingAllVariables());
        wGetParameters.addListener(13, e -> this.getParametersFromPipeline());
        Button wMapParameters = new Button(wParametersComposite, 8);
        wMapParameters.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.MapParameters", (String[])new String[0]));
        PropsUi.setLook((Widget)wMapParameters);
        FormData fdMapParameters = new FormData();
        fdMapParameters.bottom = new FormAttachment(100, 0);
        fdMapParameters.right = new FormAttachment((Control)wGetParameters, -PropsUi.getMargin());
        wMapParameters.setLayoutData((Object)fdMapParameters);
        wMapParameters.setSelection(this.pipelineExecutorMeta.getParameters().isInheritingAllVariables());
        wMapParameters.addListener(13, e -> this.mapFieldsToPipelineParameters());
        this.parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.column.Field", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.column.Input", (String[])new String[0]), 1, false, false)};
        this.parameterColumns[1].setUsingVariables(true);
        PipelineExecutorParameters parameters = this.pipelineExecutorMeta.getParameters();
        this.wPipelineExecutorParameters = new TableView(this.variables, wParametersComposite, 67586, this.parameterColumns, parameters.getVariable().length, false, null, this.props, false);
        PropsUi.setLook((Widget)this.wPipelineExecutorParameters);
        FormData fdPipelineExecutors = new FormData();
        fdPipelineExecutors.left = new FormAttachment(0, 0);
        fdPipelineExecutors.right = new FormAttachment(100, 0);
        fdPipelineExecutors.top = new FormAttachment(0, 0);
        fdPipelineExecutors.bottom = new FormAttachment((Control)wGetParameters, -10);
        this.wPipelineExecutorParameters.setLayoutData((Object)fdPipelineExecutors);
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = this.wPipelineExecutorParameters.table.getItem(i);
            tableItem.setText(1, Const.NVL((String)parameters.getVariable()[i], (String)""));
            tableItem.setText(2, Const.NVL((String)parameters.getField()[i], (String)""));
            tableItem.setText(3, Const.NVL((String)parameters.getInput()[i], (String)""));
        }
        this.wPipelineExecutorParameters.setRowNums();
        this.wPipelineExecutorParameters.optWidth(true);
        this.wInheritAll = new Button(wParametersComposite, 32);
        this.wInheritAll.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.InheritAll", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.top = new FormAttachment((Control)this.wPipelineExecutorParameters, 15);
        fdInheritAll.left = new FormAttachment(0, 0);
        this.wInheritAll.setLayoutData((Object)fdInheritAll);
        this.wInheritAll.setSelection(this.pipelineExecutorMeta.getParameters().isInheritingAllVariables());
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
    }

    protected void getParametersFromPipeline() {
        try {
            String[] parameters;
            this.loadPipeline();
            for (String name : parameters = this.executorPipelineMeta.listParameters()) {
                TableItem item = new TableItem(this.wPipelineExecutorParameters.table, 0);
                item.setText(1, Const.NVL((String)name, (String)""));
            }
            this.wPipelineExecutorParameters.removeEmptyRows();
            this.wPipelineExecutorParameters.setRowNums();
            this.wPipelineExecutorParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Message", (String[])new String[0]), e);
        }
    }

    protected void mapFieldsToPipelineParameters() {
        try {
            IRowMeta inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            String[] inputFieldNames = inputFields.getFieldNames();
            this.loadPipeline();
            String[] parameters = this.executorPipelineMeta.listParameters();
            List<SourceToTargetMapping> mappings = new ArrayList();
            for (TableItem item : this.wPipelineExecutorParameters.getNonEmptyItems()) {
                int sourceIndex = Const.indexOfString((String)item.getText(1), (String[])parameters);
                int targetIndex = Const.indexOfString((String)item.getText(2), (String[])inputFieldNames);
                if (sourceIndex < 0 || targetIndex < 0) continue;
                SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
                mappings.add(mapping);
            }
            EnterMappingDialog enterMappingDialog = new EnterMappingDialog(this.shell, inputFieldNames, parameters, mappings);
            if ((mappings = enterMappingDialog.open()) != null) {
                this.wPipelineExecutorParameters.removeAll();
                for (SourceToTargetMapping mapping : mappings) {
                    TableItem item = new TableItem(this.wPipelineExecutorParameters.table, 0);
                    item.setText(1, Const.NVL((String)mapping.getTargetString(parameters), (String)""));
                    item.setText(2, Const.NVL((String)mapping.getSourceString(inputFieldNames), (String)""));
                    item.setText(3, "");
                }
                this.wPipelineExecutorParameters.removeEmptyRows();
                this.wPipelineExecutorParameters.setRowNums();
                this.wPipelineExecutorParameters.optWidth(true);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingSpecifiedJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowExecutorDialog.ErrorLoadingSpecifiedJob.Message", (String[])new String[0]), e);
        }
    }

    private void activePipelineNameField() {
        this.wlPipelineNameField.setEnabled(this.wbPipelineNameInField.getSelection());
        this.wPipelineNameField.setEnabled(this.wbPipelineNameInField.getSelection());
        this.wPath.setEnabled(!this.wbPipelineNameInField.getSelection());
        this.wlPath.setEnabled(!this.wbPipelineNameInField.getSelection());
        if (this.wbPipelineNameInField.getSelection()) {
            this.wPath.setText("");
        } else {
            this.wPipelineNameField.setText("");
        }
    }

    private void addRowGroupTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setFont(GuiResource.getInstance().getFontDefault());
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.RowGroup.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.RowGroup.Tooltip", (String[])new String[0]));
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlGroupSize = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)this.wlGroupSize);
        this.wlGroupSize.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupSize.Label", (String[])new String[0]));
        this.wlGroupSize.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupSize.Tooltip", (String[])new String[0]));
        FormData fdlGroupSize = new FormData();
        fdlGroupSize.top = new FormAttachment(0, 0);
        fdlGroupSize.left = new FormAttachment(0, 0);
        fdlGroupSize.right = new FormAttachment(this.middle, -this.margin);
        this.wlGroupSize.setLayoutData((Object)fdlGroupSize);
        this.wGroupSize = new TextVar(this.variables, wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wGroupSize);
        FormData fdGroupSize = new FormData();
        fdGroupSize.right = new FormAttachment(100);
        fdGroupSize.top = new FormAttachment((Control)this.wlGroupSize, 0, 0x1000000);
        fdGroupSize.left = new FormAttachment(this.middle, 0);
        this.wGroupSize.setLayoutData((Object)fdGroupSize);
        this.wGroupSize.addListener(24, e -> this.setFlags());
        this.wlGroupField = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)this.wlGroupField);
        this.wlGroupField.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupField.Label", (String[])new String[0]));
        FormData fdlGroupField = new FormData();
        fdlGroupField.top = new FormAttachment((Control)this.wGroupSize, 10);
        fdlGroupField.left = new FormAttachment(0, 0);
        fdlGroupField.right = new FormAttachment(this.middle, -this.margin);
        this.wlGroupField.setLayoutData((Object)fdlGroupField);
        this.wGroupField = new CCombo(wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wGroupField);
        FormData fdGroupField = new FormData();
        fdGroupField.right = new FormAttachment(100);
        fdGroupField.top = new FormAttachment((Control)this.wlGroupField, 0, 0x1000000);
        fdGroupField.left = new FormAttachment(this.middle, 0);
        this.wGroupField.setLayoutData((Object)fdGroupField);
        this.wGroupField.addListener(24, e -> this.setFlags());
        this.wlGroupTime = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)this.wlGroupTime);
        this.wlGroupTime.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupTime.Label", (String[])new String[0]));
        FormData fdlGroupTime = new FormData();
        fdlGroupTime.top = new FormAttachment((Control)this.wGroupField, 10);
        fdlGroupTime.left = new FormAttachment(0, 0);
        fdlGroupTime.right = new FormAttachment(this.middle, -this.margin);
        this.wlGroupTime.setLayoutData((Object)fdlGroupTime);
        this.wGroupTime = new TextVar(this.variables, wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wGroupTime);
        FormData fdGroupTime = new FormData();
        fdGroupTime.right = new FormAttachment(100);
        fdGroupTime.top = new FormAttachment((Control)this.wlGroupTime, 0, 0x1000000);
        fdGroupTime.left = new FormAttachment(this.middle, 0);
        this.wGroupTime.setLayoutData((Object)fdGroupTime);
        wTab.setControl((Control)wInputComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addExecutionResultTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setFont(GuiResource.getInstance().getFontDefault());
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResults.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResults.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        PropsUi.setLook((Widget)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Label wlExecutionResultTarget = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)wlExecutionResultTarget);
        wlExecutionResultTarget.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResultTarget.Label", (String[])new String[0]));
        FormData fdlExecutionResultTarget = new FormData();
        fdlExecutionResultTarget.top = new FormAttachment(0, 0);
        fdlExecutionResultTarget.right = new FormAttachment(this.middle, -this.margin);
        wlExecutionResultTarget.setLayoutData((Object)fdlExecutionResultTarget);
        this.wExecutionResultTarget = new CCombo(wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wExecutionResultTarget);
        FormData fdExecutionResultTarget = new FormData();
        fdExecutionResultTarget.right = new FormAttachment(100);
        fdExecutionResultTarget.top = new FormAttachment((Control)wlExecutionResultTarget, 0, 0x1000000);
        fdExecutionResultTarget.left = new FormAttachment(this.middle, 0);
        this.wExecutionResultTarget.setLayoutData((Object)fdExecutionResultTarget);
        ColumnInfo[] executionResultColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ExecutionResults.FieldDescription.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ExecutionResults.FieldName.Label", (String[])new String[0]), 1, false, false)};
        executionResultColumns[1].setUsingVariables(true);
        TableView wExectionResults = new TableView(this.variables, wInputComposite, 67588, executionResultColumns, 14, false, null, this.props, false);
        PropsUi.setLook((Widget)wExectionResults);
        FormData fdExecutionResults = new FormData();
        fdExecutionResults.left = new FormAttachment(0);
        fdExecutionResults.right = new FormAttachment(100);
        fdExecutionResults.top = new FormAttachment((Control)this.wExecutionResultTarget, 10);
        fdExecutionResults.bottom = new FormAttachment(100);
        wExectionResults.setLayoutData((Object)fdExecutionResults);
        wExectionResults.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        int index = 0;
        this.tiExecutionTimeField = wExectionResults.table.getItem(index++);
        this.tiExecutionResultField = wExectionResults.table.getItem(index++);
        this.tiExecutionNrErrorsField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesReadField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesWrittenField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesInputField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesOutputField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesRejectedField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesUpdatedField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesDeletedField = wExectionResults.table.getItem(index++);
        this.tiExecutionFilesRetrievedField = wExectionResults.table.getItem(index++);
        this.tiExecutionExitStatusField = wExectionResults.table.getItem(index++);
        this.tiExecutionLogTextField = wExectionResults.table.getItem(index++);
        this.tiExecutionLogChannelIdField = wExectionResults.table.getItem(index);
        this.tiExecutionTimeField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionTimeField.Label", (String[])new String[0]));
        this.tiExecutionResultField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResultField.Label", (String[])new String[0]));
        this.tiExecutionNrErrorsField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionNrErrorsField.Label", (String[])new String[0]));
        this.tiExecutionLinesReadField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesReadField.Label", (String[])new String[0]));
        this.tiExecutionLinesWrittenField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesWrittenField.Label", (String[])new String[0]));
        this.tiExecutionLinesInputField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesInputField.Label", (String[])new String[0]));
        this.tiExecutionLinesOutputField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesOutputField.Label", (String[])new String[0]));
        this.tiExecutionLinesRejectedField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesRejectedField.Label", (String[])new String[0]));
        this.tiExecutionLinesUpdatedField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesUpdatedField.Label", (String[])new String[0]));
        this.tiExecutionLinesDeletedField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesDeletedField.Label", (String[])new String[0]));
        this.tiExecutionFilesRetrievedField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionFilesRetrievedField.Label", (String[])new String[0]));
        this.tiExecutionExitStatusField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionExitStatusField.Label", (String[])new String[0]));
        this.tiExecutionLogTextField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLogTextField.Label", (String[])new String[0]));
        this.tiExecutionLogChannelIdField.setText(1, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLogChannelIdField.Label", (String[])new String[0]));
        this.wPipelineExecutorParameters.setRowNums();
        this.wPipelineExecutorParameters.optWidth(true);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultFilesTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setFont(GuiResource.getInstance().getFontDefault());
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFiles.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFiles.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        PropsUi.setLook((Widget)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Label wlResultFilesTarget = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)wlResultFilesTarget);
        wlResultFilesTarget.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFilesTarget.Label", (String[])new String[0]));
        FormData fdlResultFilesTarget = new FormData();
        fdlResultFilesTarget.top = new FormAttachment(0, 0);
        fdlResultFilesTarget.left = new FormAttachment(0, 0);
        fdlResultFilesTarget.right = new FormAttachment(this.middle, -this.margin);
        wlResultFilesTarget.setLayoutData((Object)fdlResultFilesTarget);
        this.wResultFilesTarget = new CCombo(wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wResultFilesTarget);
        FormData fdResultFilesTarget = new FormData();
        fdResultFilesTarget.right = new FormAttachment(100);
        fdResultFilesTarget.top = new FormAttachment((Control)wlResultFilesTarget, 0, 0x1000000);
        fdResultFilesTarget.left = new FormAttachment(this.middle, 0);
        this.wResultFilesTarget.setLayoutData((Object)fdResultFilesTarget);
        Label wlResultFileNameField = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)wlResultFileNameField);
        wlResultFileNameField.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFileNameField.Label", (String[])new String[0]));
        FormData fdlResultFileNameField = new FormData();
        fdlResultFileNameField.top = new FormAttachment((Control)this.wResultFilesTarget, this.margin * 2);
        fdlResultFileNameField.left = new FormAttachment(0, 0);
        fdlResultFileNameField.right = new FormAttachment(this.middle, -this.margin);
        wlResultFileNameField.setLayoutData((Object)fdlResultFileNameField);
        this.wResultFileNameField = new TextVar(this.variables, wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wResultFileNameField);
        FormData fdResultFileNameField = new FormData();
        fdResultFileNameField.width = 250;
        fdResultFileNameField.top = new FormAttachment((Control)wlResultFileNameField, 0, 0x1000000);
        fdResultFileNameField.left = new FormAttachment(this.middle, 0);
        fdResultFileNameField.right = new FormAttachment(100);
        this.wResultFileNameField.setLayoutData((Object)fdResultFileNameField);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultRowsTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setFont(GuiResource.getInstance().getFontDefault());
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultRows.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultRows.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        PropsUi.setLook((Widget)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Label wlResultRowsTarget = new Label(wInputComposite, 131072);
        PropsUi.setLook((Widget)wlResultRowsTarget);
        wlResultRowsTarget.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.OutputRowsSource.Label", (String[])new String[0]));
        FormData fdlResultRowsTarget = new FormData();
        fdlResultRowsTarget.top = new FormAttachment(0, 0);
        fdlResultRowsTarget.left = new FormAttachment(0, 0);
        fdlResultRowsTarget.right = new FormAttachment(this.middle, -this.margin);
        wlResultRowsTarget.setLayoutData((Object)fdlResultRowsTarget);
        this.wOutputRowsSource = new CCombo(wInputComposite, 18436);
        PropsUi.setLook((Widget)this.wOutputRowsSource);
        FormData fdResultRowsTarget = new FormData();
        fdResultRowsTarget.right = new FormAttachment(100);
        fdResultRowsTarget.top = new FormAttachment((Control)wlResultRowsTarget, 0, 0x1000000);
        fdResultRowsTarget.left = new FormAttachment(this.middle, 0);
        this.wOutputRowsSource.setLayoutData((Object)fdResultRowsTarget);
        Label wlOutputFields = new Label(wInputComposite, 0);
        wlOutputFields.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutputFields);
        FormData fdlResultFields = new FormData();
        fdlResultFields.left = new FormAttachment(0, 0);
        fdlResultFields.top = new FormAttachment((Control)this.wOutputRowsSource, 10);
        wlOutputFields.setLayoutData((Object)fdlResultFields);
        int nrRows = this.pipelineExecutorMeta.getOutputRowsField() != null ? this.pipelineExecutorMeta.getOutputRowsField().length : 1;
        ColumnInfo[] ciResultFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Field", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wOutputFields = new TableView(this.variables, wInputComposite, 68354, ciResultFields, nrRows, false, null, this.props, false);
        FormData fdResultFields = new FormData();
        fdResultFields.left = new FormAttachment(0, 0);
        fdResultFields.top = new FormAttachment((Control)wlOutputFields, 5);
        fdResultFields.right = new FormAttachment(100, 0);
        fdResultFields.bottom = new FormAttachment(100, 0);
        this.wOutputFields.setLayoutData((Object)fdResultFields);
        this.wOutputFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 25, 25, 25, 25}));
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void setFlags() {
        if (this.wlGroupSize == null || this.wlGroupField == null || this.wGroupField == null || this.wlGroupTime == null || this.wGroupTime == null) {
            return;
        }
        boolean enableSize = Const.toInt((String)this.variables.resolve(this.wGroupSize.getText()), (int)-1) >= 0;
        boolean enableField = !Utils.isEmpty((CharSequence)this.wGroupField.getText());
        this.wlGroupSize.setEnabled(true);
        this.wGroupSize.setEnabled(true);
        this.wlGroupField.setEnabled(!enableSize);
        this.wGroupField.setEnabled(!enableSize);
        this.wlGroupTime.setEnabled(!enableSize && !enableField);
        this.wGroupTime.setEnabled(!enableSize && !enableField);
    }

    private void cancel() {
        this.transformName = null;
        this.pipelineExecutorMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        if (!this.wbPipelineNameInField.getSelection()) {
            if (Utils.isEmpty((CharSequence)this.wPath.getText())) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.FilenameMissing.Header", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.FilenameMissing.Message", (String[])new String[0]));
                mb.open();
                return;
            }
            if (this.isSelfReferencing()) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.SelfReference.Header", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.SelfReference.Message", (String[])new String[0]));
                mb.open();
                return;
            }
            try {
                this.loadPipeline();
            }
            catch (HopException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        this.pipelineExecutorMeta.setFilename(this.wPath.getText());
        this.pipelineExecutorMeta.setFilenameInField(this.wbPipelineNameInField.getSelection());
        this.pipelineExecutorMeta.setFilenameField(this.wPipelineNameField.getText());
        this.pipelineExecutorMeta.setRunConfigurationName(this.wRunConfiguration.getText());
        this.collectInformation();
        this.pipelineExecutorMeta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
        this.pipelineExecutorMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        PipelineExecutorParameters parameters = this.pipelineExecutorMeta.getParameters();
        int nrLines = this.wPipelineExecutorParameters.nrNonEmpty();
        String[] variables = new String[nrLines];
        String[] fields = new String[nrLines];
        String[] input = new String[nrLines];
        parameters.setVariable(variables);
        parameters.setField(fields);
        parameters.setInput(input);
        for (int i = 0; i < nrLines; ++i) {
            TableItem item = this.wPipelineExecutorParameters.getNonEmpty(i);
            variables[i] = item.getText(1);
            fields[i] = item.getText(2);
            input[i] = item.getText(3);
        }
        parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        this.pipelineExecutorMeta.setGroupSize(this.wGroupSize.getText());
        this.pipelineExecutorMeta.setGroupField(this.wGroupField.getText());
        this.pipelineExecutorMeta.setGroupTime(this.wGroupTime.getText());
        this.pipelineExecutorMeta.setExecutionResultTargetTransform(this.wExecutionResultTarget.getText());
        this.pipelineExecutorMeta.setExecutionResultTargetTransformMeta(this.pipelineMeta.findTransform(this.wExecutionResultTarget.getText()));
        this.pipelineExecutorMeta.setExecutionTimeField(this.tiExecutionTimeField.getText(2));
        this.pipelineExecutorMeta.setExecutionResultField(this.tiExecutionResultField.getText(2));
        this.pipelineExecutorMeta.setExecutionNrErrorsField(this.tiExecutionNrErrorsField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesReadField(this.tiExecutionLinesReadField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesWrittenField(this.tiExecutionLinesWrittenField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesInputField(this.tiExecutionLinesInputField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesOutputField(this.tiExecutionLinesOutputField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesRejectedField(this.tiExecutionLinesRejectedField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesUpdatedField(this.tiExecutionLinesUpdatedField.getText(2));
        this.pipelineExecutorMeta.setExecutionLinesDeletedField(this.tiExecutionLinesDeletedField.getText(2));
        this.pipelineExecutorMeta.setExecutionFilesRetrievedField(this.tiExecutionFilesRetrievedField.getText(2));
        this.pipelineExecutorMeta.setExecutionExitStatusField(this.tiExecutionExitStatusField.getText(2));
        this.pipelineExecutorMeta.setExecutionLogTextField(this.tiExecutionLogTextField.getText(2));
        this.pipelineExecutorMeta.setExecutionLogChannelIdField(this.tiExecutionLogChannelIdField.getText(2));
        this.pipelineExecutorMeta.setResultFilesTargetTransform(this.wResultFilesTarget.getText());
        this.pipelineExecutorMeta.setResultFilesTargetTransformMeta(this.pipelineMeta.findTransform(this.wResultFilesTarget.getText()));
        this.pipelineExecutorMeta.setResultFilesFileNameField(this.wResultFileNameField.getText());
        if (!Utils.isEmpty((CharSequence)this.executorOutputTransform)) {
            this.pipelineExecutorMeta.setExecutorsOutputTransform(this.executorOutputTransform);
            this.pipelineExecutorMeta.setExecutorsOutputTransformMeta(this.pipelineMeta.findTransform(this.executorOutputTransform));
        }
        this.pipelineExecutorMeta.setOutputRowsSourceTransform(this.wOutputRowsSource.getText());
        this.pipelineExecutorMeta.setOutputRowsSourceTransformMeta(this.pipelineMeta.findTransform(this.wOutputRowsSource.getText()));
        int nrFields = this.wOutputFields.nrNonEmpty();
        this.pipelineExecutorMeta.setOutputRowsField(new String[nrFields]);
        this.pipelineExecutorMeta.setOutputRowsType(new int[nrFields]);
        this.pipelineExecutorMeta.setOutputRowsLength(new int[nrFields]);
        this.pipelineExecutorMeta.setOutputRowsPrecision(new int[nrFields]);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wOutputFields.getNonEmpty(i);
            this.pipelineExecutorMeta.getOutputRowsField()[i] = item.getText(1);
            this.pipelineExecutorMeta.getOutputRowsType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            this.pipelineExecutorMeta.getOutputRowsLength()[i] = Const.toInt((String)item.getText(3), (int)-1);
            this.pipelineExecutorMeta.getOutputRowsPrecision()[i] = Const.toInt((String)item.getText(4), (int)-1);
        }
    }

    private boolean isSelfReferencing() {
        return this.variables.resolve(this.wPath.getText()).equals(this.variables.resolve(this.pipelineMeta.getFilename()));
    }
}

