/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.AbstractModelComposite;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class AnthropicComposite
extends AbstractModelComposite {
    private final Label baseUrlLabel = this.createLabel();
    private final TextVar baseUrlInput = this.createTextVar();
    private final Label apiKeyLabel;
    private final TextVar apiKeyInput;
    private final Label versionLabel;
    private final TextVar versionInput;
    private final Label modelNameLabel;
    private final TextVar modelNameInput;
    private final Label temperatureLabel;
    private final TextVar temperatureInput;
    private final Label topPLabel;
    private final TextVar topPInput;
    private final Label topKLabel;
    private final TextVar topKInput;
    private final Label maxTokensLabel;
    private final TextVar maxTokensInput;
    private final Label stopSequencesLabel;
    private final TextVar stopSequencesInput;
    private final Label seedLabel;
    private final TextVar seedInput;
    private final Label timeoutLabel;
    private final TextVar timeoutInput;
    private final Label maxRetriesLabel;
    private final TextVar maxRetriesInput;
    private final Button logRequestsButton;
    private final Button logResponsesButton;

    public AnthropicComposite(CompositeParameters parameters) {
        super(ModelType.ANTHROPIC, parameters);
        this.prepare("BaseUrl", this.baseUrlLabel, (Control)this.baseUrlInput);
        this.apiKeyLabel = this.createLabel();
        this.apiKeyInput = this.createTextVar();
        this.prepare("ApiKey", this.apiKeyLabel, (Control)this.apiKeyInput);
        this.versionLabel = this.createLabel();
        this.versionInput = this.createTextVar();
        this.prepare("Version", this.versionLabel, (Control)this.versionInput);
        this.modelNameLabel = this.createLabel();
        this.modelNameInput = this.createTextVar();
        this.prepare("ModelName", this.modelNameLabel, (Control)this.modelNameInput);
        this.temperatureLabel = this.createLabel();
        this.temperatureInput = this.createTextVar();
        this.prepare("Temperature", this.temperatureLabel, (Control)this.temperatureInput);
        this.topPLabel = this.createLabel();
        this.topPInput = this.createTextVar();
        this.prepare("TopP", this.topPLabel, (Control)this.topPInput);
        this.topKLabel = this.createLabel();
        this.topKInput = this.createTextVar();
        this.prepare("TopK", this.topKLabel, (Control)this.topKInput);
        this.maxTokensLabel = this.createLabel();
        this.maxTokensInput = this.createTextVar();
        this.prepare("MaxTokens", this.maxTokensLabel, (Control)this.maxTokensInput);
        this.stopSequencesLabel = this.createLabel();
        this.stopSequencesInput = this.createTextVar();
        this.stopSequencesLabel.setVisible(false);
        this.stopSequencesInput.setVisible(false);
        this.seedLabel = this.createLabel();
        this.seedInput = this.createTextVar();
        this.timeoutLabel = this.createLabel();
        this.timeoutInput = this.createTextVar();
        this.prepare("Timeout", this.timeoutLabel, (Control)this.timeoutInput);
        this.maxRetriesLabel = this.createLabel();
        this.maxRetriesInput = this.createTextVar();
        this.prepare("MaxRetries", this.maxRetriesLabel, (Control)this.maxRetriesInput);
        this.logRequestsButton = this.createButton();
        this.prepare("LogRequests", null, (Control)this.logRequestsButton);
        this.logResponsesButton = this.createButton();
        this.prepare("LogResponses", null, (Control)this.logResponsesButton);
    }

    @Override
    public void loadData() {
        if (!this.isSelectedModelType()) {
            return;
        }
        if (this.meta.getAnthropicBaseUrl() != null) {
            this.baseUrlInput.setText(this.meta.getAnthropicBaseUrl());
        }
        if (this.meta.getAnthropicApiKey() != null) {
            this.apiKeyInput.setText(this.meta.getAnthropicApiKey());
        }
        if (this.meta.getAnthropicVersion() != null) {
            this.versionInput.setText(this.meta.getAnthropicVersion());
        }
        if (this.meta.getAnthropicModelName() != null) {
            this.modelNameInput.setText(this.meta.getAnthropicModelName());
        }
        if (this.meta.getAnthropicTemperature() != null) {
            this.temperatureInput.setText("" + this.meta.getAnthropicTemperature());
        }
        if (this.meta.getAnthropicTopP() != null) {
            this.topPInput.setText("" + this.meta.getAnthropicTopP());
        }
        if (this.meta.getAnthropicTopK() != null) {
            this.topKInput.setText("" + this.meta.getAnthropicTopK());
        }
        if (this.meta.getAnthropicMaxTokens() != null) {
            this.maxTokensInput.setText("" + this.meta.getAnthropicMaxTokens());
        }
        if (this.meta.getAnthropicTimeout() != null) {
            this.timeoutInput.setText("" + this.meta.getAnthropicTimeout());
        }
        if (this.meta.getAnthropicMaxRetries() != null) {
            this.maxRetriesInput.setText("" + this.meta.getAnthropicMaxRetries());
        }
        this.logRequestsButton.setSelection(this.meta.isAnthropicLogRequests());
        this.logResponsesButton.setSelection(this.meta.isAnthropicLogResponses());
    }

    @Override
    public boolean validateInputs() {
        if (!this.isSelectedModelType()) {
            return true;
        }
        String temperature = StringUtils.trim((String)this.temperatureInput.getText());
        return StringUtils.isBlank((CharSequence)temperature) || NumberUtils.isCreatable((String)temperature);
    }

    @Override
    public void updateTransformMeta() {
        if (!this.validateInputs()) {
            return;
        }
        this.meta.setAnthropicBaseUrl(this.trimStringToNull(this.baseUrlInput.getText()));
        this.meta.setAnthropicApiKey(this.trimStringToNull(this.apiKeyInput.getText()));
        this.meta.setAnthropicVersion(this.trimStringToNull(this.versionInput.getText()));
        this.meta.setAnthropicModelName(this.trimStringToNull(this.modelNameInput.getText()));
        this.meta.setAnthropicTemperature(this.trimDoubleToNull(this.temperatureInput.getText()));
        this.meta.setAnthropicTopP(this.trimDoubleToNull(this.topPInput.getText()));
        this.meta.setAnthropicTopK(this.trimIntegerToNull(this.topKInput.getText()));
        this.meta.setAnthropicMaxTokens(this.trimIntegerToNull(this.maxTokensInput.getText()));
        this.meta.setAnthropicTimeout(this.trimIntegerToNull(this.timeoutInput.getText()));
        this.meta.setAnthropicMaxRetries(this.trimIntegerToNull(this.maxRetriesInput.getText()));
        this.meta.setAnthropicLogRequests(this.logRequestsButton.getSelection());
        this.meta.setAnthropicLogResponses(this.logResponsesButton.getSelection());
    }

    public Label getApiKeyLabel() {
        return this.apiKeyLabel;
    }

    public TextVar getApiKeyInput() {
        return this.apiKeyInput;
    }

    public Label getModelNameLabel() {
        return this.modelNameLabel;
    }

    public TextVar getModelNameInput() {
        return this.modelNameInput;
    }

    public Label getTemperatureLabel() {
        return this.temperatureLabel;
    }

    public TextVar getTemperatureInput() {
        return this.temperatureInput;
    }

    public Label getBaseUrlLabel() {
        return this.baseUrlLabel;
    }

    public TextVar getBaseUrlInput() {
        return this.baseUrlInput;
    }

    public Label getVersionLabel() {
        return this.versionLabel;
    }

    public TextVar getVersionInput() {
        return this.versionInput;
    }

    public Label getTopPLabel() {
        return this.topPLabel;
    }

    public TextVar getTopPInput() {
        return this.topPInput;
    }

    public Label getMaxTokensLabel() {
        return this.maxTokensLabel;
    }

    public TextVar getMaxTokensInput() {
        return this.maxTokensInput;
    }

    public Label getSeedLabel() {
        return this.seedLabel;
    }

    public TextVar getSeedInput() {
        return this.seedInput;
    }

    public Label getTopKLabel() {
        return this.topKLabel;
    }

    public TextVar getTopKInput() {
        return this.topKInput;
    }

    public Label getTimeoutLabel() {
        return this.timeoutLabel;
    }

    public TextVar getTimeoutInput() {
        return this.timeoutInput;
    }

    public Label getMaxRetriesLabel() {
        return this.maxRetriesLabel;
    }

    public TextVar getMaxRetriesInput() {
        return this.maxRetriesInput;
    }

    public Label getStopSequencesLabel() {
        return this.stopSequencesLabel;
    }

    public TextVar getStopSequencesInput() {
        return this.stopSequencesInput;
    }

    public Button getLogRequestsButton() {
        return this.logRequestsButton;
    }

    public Button getLogResponsesButton() {
        return this.logResponsesButton;
    }
}

