/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.FormDataBuilder;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.i18nUtil;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.IModelComposite;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractModelComposite
implements IModelComposite {
    protected final Composite composite;
    protected final LanguageModelChatMeta meta;
    protected Control control;
    protected final CompositeParameters parameters;
    protected final FormDataBuilder.Builder layout;
    protected final ModelType modelType;

    protected AbstractModelComposite(ModelType modelType, CompositeParameters parameters) {
        this.parameters = parameters;
        this.modelType = modelType;
        this.meta = (LanguageModelChatMeta)parameters.meta();
        this.composite = new Composite(parameters.parent(), 0);
        this.composite.setVisible(false);
        this.composite.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)fd);
        this.control = this.composite;
        this.layout = FormDataBuilder.Builder.buildFormData().margin(parameters.margin());
    }

    protected Label createLabel() {
        return new Label(this.composite, 131072);
    }

    protected TextVar createTextVar() {
        return new TextVar(this.parameters.variables(), this.composite, 18436);
    }

    protected Button createButton() {
        return new Button(this.composite, 32);
    }

    protected CCombo createComboBox() {
        return new CCombo(this.composite, 2056);
    }

    protected void prepare(String i18n, Label label, Control input) {
        Validate.notNull((Object)input, (String)"An input control must be provided", (Object[])new Object[0]);
        int middle = this.parameters.middlePct();
        int margin = this.parameters.margin();
        String i18nKey = i18nUtil.i18n("LanguageModelChatDialog." + this.modelType.name() + "." + i18n + ".Label");
        PropsUi.setLook((Widget)input);
        this.layout.control(this.control);
        input.setLayoutData((Object)this.layout.left(middle, 0).right(100, 0).build());
        if (label == null) {
            Validate.isTrue((boolean)(input instanceof Button), (String)"Only buttons don't need a label", (Object[])new Object[0]);
            ((Button)input).setText(i18nKey);
        } else {
            PropsUi.setLook((Widget)label);
            label.setText(i18nKey);
            label.setLayoutData((Object)this.layout.left(0, 0).right(middle, -margin).build());
        }
        this.control = input;
    }

    @Override
    public void updateLayouts() {
        this.composite().layout(true, true);
    }

    @Override
    public Composite composite() {
        return this.composite;
    }

    @Override
    public Control control() {
        return this.control;
    }

    public ModelType modelType() {
        return this.modelType;
    }

    @Override
    public boolean isSelectedModelType() {
        return this.modelType.code().equals(this.meta.getModelType());
    }

    @Override
    public boolean validateInputs() {
        return !this.isSelectedModelType();
    }

    String trimStringToNull(String input) {
        return StringUtils.trimToNull((String)input);
    }

    Double trimDoubleToNull(String input) {
        String v = StringUtils.trimToNull((String)input);
        return StringUtils.isBlank((CharSequence)v) || !NumberUtils.isCreatable((String)v) ? null : Double.valueOf(NumberUtils.toDouble((String)v));
    }

    Integer trimIntegerToNull(String input) {
        String v = StringUtils.trimToNull((String)input);
        return StringUtils.isBlank((CharSequence)v) || !NumberUtils.isCreatable((String)v) ? null : Integer.valueOf(NumberUtils.toInt((String)v));
    }
}

