/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotCategorizer;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;

public class SimpleCategorizer
implements ThreadSnapshotCategorizer {
    private String[] categories = new String[0];
    private ThreadSnapshotFilter[] filters = new ThreadSnapshotFilter[0];

    public SimpleCategorizer() {
    }

    public SimpleCategorizer(Map<String, ThreadSnapshotFilter> categories) {
        for (Map.Entry<String, ThreadSnapshotFilter> cat : categories.entrySet()) {
            this.addCategory(cat.getKey(), cat.getValue());
        }
    }

    public void addCategory(String category, ThreadSnapshotFilter filter) {
        for (String cat : this.categories) {
            if (!cat.equals(category)) continue;
            throw new IllegalArgumentException("Dupplicate category [" + cat + "]");
        }
        int n = this.categories.length;
        this.categories = Arrays.copyOf(this.categories, n + 1);
        this.filters = Arrays.copyOf(this.filters, n + 1);
        this.categories[n] = category;
        this.filters[n] = filter;
    }

    @Override
    public List<String> getCategories() {
        return Arrays.asList(this.categories);
    }

    @Override
    public String categorize(ThreadSnapshot snap) {
        for (int i = 0; i != this.categories.length; ++i) {
            if (!this.filters[i].evaluate(snap)) continue;
            return this.categories[i];
        }
        return null;
    }
}

