/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.reconciler;

import com.google.cloud.bigtable.data.v2.models.Range;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Internal
public class OrphanedMetadataCleaner {
    private static final @UnknownKeyFor @NonNull @Initialized Duration ORPHANED_NEW_PARTITION_WAIT = Duration.standardMinutes((long)15L);
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> newPartitions = new ArrayList<NewPartition>();
    @Nullable
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> missingPartitions = null;

    public void addIncompleteNewPartitions(@UnknownKeyFor @NonNull @Initialized NewPartition newPartition) {
        if (newPartition.getLastUpdated().plus((ReadableDuration)ORPHANED_NEW_PARTITION_WAIT).isBeforeNow()) {
            this.newPartitions.add(newPartition);
        }
    }

    public void addMissingPartitions(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> missingPartitions) {
        if (this.missingPartitions == null) {
            this.missingPartitions = new ArrayList<Range.ByteStringRange>();
        }
        this.missingPartitions.addAll(missingPartitions);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> getOrphanedNewPartitions() {
        ArrayList<NewPartition> orphanedNewPartitions = new ArrayList<NewPartition>();
        List<Range.ByteStringRange> missingPartitions = this.missingPartitions;
        if (missingPartitions == null) {
            return orphanedNewPartitions;
        }
        for (NewPartition newPartition : this.newPartitions) {
            boolean hasOverlap = false;
            for (Range.ByteStringRange missingPartition : missingPartitions) {
                if (!ByteStringRangeHelper.doPartitionsOverlap(newPartition.getPartition(), missingPartition)) continue;
                hasOverlap = true;
                break;
            }
            if (hasOverlap) continue;
            orphanedNewPartitions.add(newPartition);
        }
        return orphanedNewPartitions;
    }
}

