/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.injection.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.metadata.api.IStringObjectConverter;

public class BeanLevelInfo<Meta> {
    public BeanLevelInfo parent;
    public Class<Meta> leafClass;
    public Field field;
    public Method getter;
    public Method setter;
    public DIMENSION dim = DIMENSION.NONE;
    public InjectionTypeConverter converter;
    public IStringObjectConverter stringObjectConverter;
    public boolean convertEmpty;
    public String nameKey;
    public boolean stringList = false;
    public boolean storeWithName = false;

    public void init(BeanInjectionInfo info) {
        this.introspect(info, this.leafClass, new TreeMap<String, Type>());
    }

    public void init(BeanInjectionInfo info, Map<String, Type> ownerGenericsInfo) {
        this.introspect(info, this.leafClass, ownerGenericsInfo);
    }

    private void introspect(BeanInjectionInfo info, Type type, Map<String, Type> ownerGenericsInfo) {
        TreeMap<String, Type> genericsInfo = new TreeMap<String, Type>(ownerGenericsInfo);
        while (type != null) {
            Class clazz;
            ParameterizedType pt;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType;
                pt = parameterizedType = (ParameterizedType)type;
                clazz = (Class)pt.getRawType();
            } else {
                pt = null;
                clazz = (Class)type;
            }
            TypeVariable<Class<T>>[] tps = clazz.getTypeParameters();
            if (tps.length > 0) {
                if (pt == null) {
                    throw new RuntimeException("Can't introspect class with parameters on the high level");
                }
                Type[] args = pt.getActualTypeArguments();
                if (tps.length != args.length) {
                    throw new RuntimeException("Wrong generics declaration");
                }
                TreeMap<String, Type> prevGenerics = genericsInfo;
                genericsInfo = new TreeMap();
                for (int i = 0; i < tps.length; ++i) {
                    if (args[i] instanceof TypeVariable) {
                        TypeVariable argsi = (TypeVariable)args[i];
                        Type prev = (Type)prevGenerics.get(argsi.getName());
                        if (prev == null) {
                            throw new RuntimeException("Generic '" + args[i] + "' was not declared yet");
                        }
                        genericsInfo.put(tps[i].getName(), prev);
                        continue;
                    }
                    genericsInfo.put(tps[i].getName(), args[i]);
                }
            }
            this.introspect(info, clazz.getDeclaredFields(), clazz.getDeclaredMethods(), genericsInfo);
            for (Type intf : clazz.getGenericInterfaces()) {
                this.introspect(info, intf, genericsInfo);
            }
            type = clazz.getGenericSuperclass();
        }
    }

    protected void introspect(BeanInjectionInfo info, Field[] fields, Method[] methods, Map<String, Type> genericsInfo) {
        BeanLevelInfo<Meta> leaf;
        InjectionDeep annotationInjectionDeep;
        Injection annotationInjection;
        for (Field field : fields) {
            Type t;
            annotationInjection = field.getAnnotation(Injection.class);
            annotationInjectionDeep = field.getAnnotation(InjectionDeep.class);
            if (annotationInjection == null && annotationInjectionDeep == null) continue;
            if (annotationInjection != null && annotationInjectionDeep != null) {
                throw new RuntimeException("Field can't be annotated twice for injection " + field);
            }
            if (field.isSynthetic() || field.isEnumConstant() || Modifier.isStatic(field.getModifiers())) {
                throw new RuntimeException("Wrong modifier for annotated field " + field);
            }
            leaf = new BeanLevelInfo<Meta>();
            leaf.parent = this;
            leaf.field = field;
            if (field.getType().isArray()) {
                Type ff = field.getGenericType();
                leaf.dim = DIMENSION.ARRAY;
                if (ff instanceof GenericArrayType) {
                    GenericArrayType genericArrayType = (GenericArrayType)ff;
                    t = this.resolveGenericType(genericArrayType.getGenericComponentType(), genericsInfo);
                } else {
                    t = field.getType().getComponentType();
                }
            } else if (List.class.equals(field.getType())) {
                leaf.dim = DIMENSION.LIST;
                Type fieldType = field.getGenericType();
                Type listType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                try {
                    t = this.resolveGenericType(listType, genericsInfo);
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Can't retrieve type from List for " + field, ex);
                }
            } else {
                leaf.dim = DIMENSION.NONE;
                t = this.resolveGenericType(field.getGenericType(), genericsInfo);
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)t;
                leaf.leafClass = (Class)parameterizedType.getRawType();
            } else {
                leaf.leafClass = t;
            }
            if (annotationInjection != null) {
                try {
                    leaf.converter = annotationInjection.converter().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiate converter for " + field, ex);
                }
                leaf.convertEmpty = annotationInjection.convertEmpty();
                info.addInjectionProperty(annotationInjection, leaf);
                continue;
            }
            if (annotationInjectionDeep == null) continue;
            leaf.nameKey = this.calculateNameKey(annotationInjectionDeep.prefix(), annotationInjection != null ? annotationInjection.name() : "");
            TreeMap<String, Type> gi = new TreeMap<String, Type>(genericsInfo);
            leaf.introspect(info, t, gi);
        }
        for (AccessibleObject accessibleObject : methods) {
            annotationInjection = ((Method)accessibleObject).getAnnotation(Injection.class);
            annotationInjectionDeep = ((Method)accessibleObject).getAnnotation(InjectionDeep.class);
            if (annotationInjection == null && annotationInjectionDeep == null) continue;
            if (annotationInjection != null && annotationInjectionDeep != null) {
                throw new RuntimeException("Method can't be annotated twice for injection " + (Method)accessibleObject);
            }
            if (((Method)accessibleObject).isSynthetic() || Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                throw new RuntimeException("Wrong modifier for anotated method " + (Method)accessibleObject);
            }
            leaf = new BeanLevelInfo<Meta>();
            leaf.parent = this;
            if (annotationInjectionDeep != null) {
                Class getter;
                Type getterClass = this.isGetter((Method)accessibleObject);
                if (getterClass == null) {
                    throw new RuntimeException("Method should be getter: " + (Method)accessibleObject);
                }
                if (((Method)accessibleObject).getReturnType() != null && List.class.equals(((Method)accessibleObject).getReturnType())) {
                    leaf.dim = DIMENSION.LIST;
                    ParameterizedType getterType = (ParameterizedType)getterClass;
                    getterClass = getterType.getActualTypeArguments()[0];
                }
                if ((getter = (Class)this.resolveGenericType(getterClass, genericsInfo)).isArray()) {
                    throw new RuntimeException("Method should be getter: " + (Method)accessibleObject);
                }
                leaf.getter = accessibleObject;
                leaf.leafClass = getter;
                leaf.nameKey = this.calculateNameKey(annotationInjectionDeep.prefix(), annotationInjection != null ? annotationInjection.name() : "");
                leaf.init(info);
                continue;
            }
            Class<?> setterClass = this.isSetter((Method)accessibleObject);
            if (setterClass == null || setterClass.isArray()) {
                throw new RuntimeException("Method should be setter: " + (Method)accessibleObject);
            }
            leaf.setter = accessibleObject;
            leaf.leafClass = setterClass;
            try {
                leaf.converter = annotationInjection.converter().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error instantiate converter for " + (Method)accessibleObject, ex);
            }
            leaf.convertEmpty = annotationInjection.convertEmpty();
            info.addInjectionProperty(annotationInjection, leaf);
        }
    }

    private String calculateNameKey(String prefix, String name) {
        if (StringUtils.isEmpty((String)prefix)) {
            return name;
        }
        if (StringUtils.isEmpty((String)name)) {
            return prefix;
        }
        return prefix + "." + name;
    }

    private Type resolveGenericType(Type type, Map<String, Type> genericsInfo) {
        String name;
        if (type instanceof TypeVariable && (type = genericsInfo.get(name = ((TypeVariable)type).getName())) == null) {
            throw new RuntimeException("Unknown generics for '" + name + "'");
        }
        return type;
    }

    private Type isGetter(Method m) {
        if (m.getReturnType() == Void.TYPE) {
            return null;
        }
        if (m.getParameterTypes().length == 0) {
            return m.getGenericReturnType();
        }
        return null;
    }

    private Class<?> isSetter(Method m) {
        if (m.getReturnType() != Void.TYPE) {
            return null;
        }
        if (m.getParameterTypes().length == 1) {
            return m.getParameterTypes()[0];
        }
        return null;
    }

    protected List<BeanLevelInfo> createCallStack() {
        ArrayList<BeanLevelInfo> stack = new ArrayList<BeanLevelInfo>();
        BeanLevelInfo p = this;
        while (p != null) {
            if (p.field != null) {
                p.field.setAccessible(true);
            }
            stack.add(p);
            p = p.parent;
        }
        Collections.reverse(stack);
        return stack;
    }

    public String toString() {
        Object r = "";
        r = this.field != null ? (String)r + "field " + this.field.getName() : (String)r + "<root field>";
        r = (String)r + "(class " + this.leafClass.getSimpleName() + ")";
        return r;
    }

    public static enum DIMENSION {
        NONE,
        ARRAY,
        LIST;

    }
}

