/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrainput;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.databases.cassandra.spi.CqlRowHandler;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.util.CassandraUtils;
import org.apache.hop.databases.cassandra.util.Compression;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInputData;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInputMeta;

public class CassandraInput
extends BaseTransform<CassandraInputMeta, CassandraInputData> {
    protected ITableMetaData tableMetaData;
    protected CqlRowHandler cqlHandler;
    protected Map<String, Integer> outputFormatMap = new HashMap<String, Integer>();
    protected Object[] currentInputRowDrivingQuery = null;
    protected String tableName;

    public CassandraInput(TransformMeta transformMeta, CassandraInputMeta meta, CassandraInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (!this.isStopped()) {
            if (((CassandraInputMeta)this.meta).isExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery == null) {
                this.currentInputRowDrivingQuery = this.getRow();
                if (this.currentInputRowDrivingQuery == null) {
                    this.setOutputDone();
                    return false;
                }
                if (!this.first) {
                    this.initQuery();
                }
            }
            if (this.first) {
                this.first = false;
                String connectionName = this.resolve(((CassandraInputMeta)this.meta).getConnectionName());
                ((CassandraInputData)this.data).cassandraConnection = (CassandraConnection)this.metadataProvider.getSerializer(CassandraConnection.class).load(connectionName);
                String hostname = this.resolve(((CassandraInputData)this.data).cassandraConnection.getHostname());
                String port = this.resolve(((CassandraInputData)this.data).cassandraConnection.getPort());
                String maxLength = this.resolve(((CassandraInputMeta)this.meta).getMaxLength());
                String keyspace = this.resolve(((CassandraInputData)this.data).cassandraConnection.getKeyspace());
                if (Utils.isEmpty((CharSequence)keyspace)) {
                    throw new HopException("Please specify the keyspace to use.");
                }
                this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.Connecting", (String[])new String[]{hostname, port, keyspace}));
                Map<String, String> connectionOptions = ((CassandraInputData)this.data).cassandraConnection.getOptionsMap(this.variables);
                if (!Utils.isEmpty((CharSequence)maxLength)) {
                    connectionOptions.put("maxLength", maxLength);
                }
                if (connectionOptions.size() > 0) {
                    this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.UsingConnectionOptions", (String[])new String[]{CassandraUtils.optionsToString(connectionOptions)}));
                }
                try {
                    ((CassandraInputData)this.data).connection = ((CassandraInputData)this.data).cassandraConnection.createConnection((IVariables)this, connectionOptions, false);
                    ((CassandraInputData)this.data).keyspace = ((CassandraInputData)this.data).connection.getKeyspace(keyspace);
                }
                catch (Exception ex) {
                    this.closeConnection();
                    throw new HopException(ex.getMessage(), (Throwable)ex);
                }
                String cqlQuery = this.resolve(((CassandraInputMeta)this.meta).getCqlSelectQuery());
                this.tableName = CassandraUtils.getTableNameFromCQLSelectQuery(cqlQuery);
                if (Utils.isEmpty((CharSequence)this.tableName)) {
                    throw new HopException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.NonExistentTable", (String[])new String[]{this.tableName, keyspace}));
                }
                try {
                    if (!((CassandraInputData)this.data).keyspace.tableExists(this.tableName)) {
                        throw new HopException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.NonExistentTable", (String[])new String[]{CassandraUtils.removeQuotes(this.tableName), keyspace}));
                    }
                }
                catch (Exception ex) {
                    this.closeConnection();
                    throw new HopException(ex.getMessage(), (Throwable)ex);
                }
                ((CassandraInputData)this.data).outputRowMeta = new RowMeta();
                ((CassandraInputMeta)this.meta).getFields(((CassandraInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (((CassandraInputData)this.data).outputRowMeta.size() == 0) {
                    throw new HopException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.QueryWontProduceOutputFields", (String[])new String[0]));
                }
                for (int i = 0; i < ((CassandraInputData)this.data).outputRowMeta.size(); ++i) {
                    String fieldName = ((CassandraInputData)this.data).outputRowMeta.getValueMeta(i).getName();
                    this.outputFormatMap.put(fieldName, i);
                }
                try {
                    this.tableMetaData = ((CassandraInputData)this.data).keyspace.getTableMetaData(this.tableName);
                }
                catch (Exception e) {
                    this.closeConnection();
                    throw new HopException(e.getMessage(), (Throwable)e);
                }
                this.initQuery();
            }
            Object[][] outRowData = new Object[1][];
            try {
                outRowData = this.cqlHandler.getNextOutputRow(((CassandraInputData)this.data).outputRowMeta, this.outputFormatMap);
            }
            catch (Exception e) {
                throw new HopException(e.getMessage(), (Throwable)e);
            }
            if (outRowData != null) {
                for (Object[] r : outRowData) {
                    this.putRow(((CassandraInputData)this.data).outputRowMeta, r);
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(this.toString(), new Object[]{"Outputted row #" + this.getProcessed() + " : " + outRowData});
                }
                if (this.checkFeedback(this.getProcessed())) {
                    this.logBasic("Read " + this.getProcessed() + " rows from Cassandra");
                }
            }
            if (outRowData == null) {
                if (!((CassandraInputMeta)this.meta).isExecuteForEachIncomingRow()) {
                    this.closeConnection();
                    this.setOutputDone();
                    return false;
                }
                this.currentInputRowDrivingQuery = null;
            }
        } else {
            this.closeConnection();
            return false;
        }
        return true;
    }

    protected void initQuery() throws HopException {
        boolean usingCompression;
        String queryS = this.resolve(((CassandraInputMeta)this.meta).getCqlSelectQuery());
        if (((CassandraInputMeta)this.meta).isExecuteForEachIncomingRow()) {
            queryS = this.resolve(queryS, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
        }
        Compression compression = (usingCompression = ((CassandraInputData)this.data).cassandraConnection.isUsingCompression()) ? Compression.GZIP : Compression.NONE;
        try {
            this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.ExecutingQuery", (String[])new String[]{queryS, usingCompression ? BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.UsingGZIPCompression", (String[])new String[0]) : ""}));
            if (this.cqlHandler == null) {
                this.cqlHandler = ((CassandraInputData)this.data).keyspace.getCQLRowHandler();
            }
            this.cqlHandler.newRowQuery((ITransform)this, this.tableName, queryS, compression.name(), "", this.getLogChannel());
        }
        catch (Exception e) {
            this.closeConnection();
            throw new HopException(e.getMessage(), (Throwable)e);
        }
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
    }

    public void dispose() {
        try {
            this.closeConnection();
        }
        catch (HopException e) {
            e.printStackTrace();
        }
    }

    protected void closeConnection() throws HopException {
        if (((CassandraInputData)this.data).connection != null) {
            this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.ClosingConnection", (String[])new String[0]));
            try {
                ((CassandraInputData)this.data).connection.close();
                ((CassandraInputData)this.data).connection = null;
            }
            catch (Exception e) {
                throw new HopException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

