/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.qjournal.client.IPCLoggerChannel;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;

@Metrics(about="Journal client metrics", context="dfs")
class IPCLoggerChannelMetrics {
    final MetricsRegistry registry = new MetricsRegistry("NameNode");
    private volatile IPCLoggerChannel ch;
    private final MutableQuantiles[] writeEndToEndLatencyQuantiles;
    private final MutableQuantiles[] writeRpcLatencyQuantiles;
    private static final Map<String, IPCLoggerChannelMetrics> REGISTRY = Maps.newHashMap();

    private IPCLoggerChannelMetrics(IPCLoggerChannel ch) {
        this.ch = ch;
        HdfsConfiguration conf = new HdfsConfiguration();
        int[] intervals = conf.getInts("dfs.metrics.percentiles.intervals");
        if (intervals != null) {
            this.writeEndToEndLatencyQuantiles = new MutableQuantiles[intervals.length];
            this.writeRpcLatencyQuantiles = new MutableQuantiles[intervals.length];
            for (int i = 0; i < this.writeEndToEndLatencyQuantiles.length; ++i) {
                int interval = intervals[i];
                this.writeEndToEndLatencyQuantiles[i] = this.registry.newQuantiles("writesE2E" + interval + "s", "End-to-end time for write operations", "ops", "LatencyMicros", interval);
                this.writeRpcLatencyQuantiles[i] = this.registry.newQuantiles("writesRpc" + interval + "s", "RPC RTT for write operations", "ops", "LatencyMicros", interval);
            }
        } else {
            this.writeEndToEndLatencyQuantiles = null;
            this.writeRpcLatencyQuantiles = null;
        }
    }

    private void setChannel(IPCLoggerChannel ch) {
        assert (ch.getRemoteAddress().equals(this.ch.getRemoteAddress()));
        this.ch = ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IPCLoggerChannelMetrics create(IPCLoggerChannel ch) {
        String name = IPCLoggerChannelMetrics.getName(ch);
        Map<String, IPCLoggerChannelMetrics> map = REGISTRY;
        synchronized (map) {
            IPCLoggerChannelMetrics m = REGISTRY.get(name);
            if (m != null) {
                m.setChannel(ch);
            } else {
                m = new IPCLoggerChannelMetrics(ch);
                DefaultMetricsSystem.instance().register(name, null, (Object)m);
                REGISTRY.put(name, m);
            }
            return m;
        }
    }

    private static String getName(IPCLoggerChannel ch) {
        InetSocketAddress addr = ch.getRemoteAddress();
        String addrStr = addr.getAddress().getHostAddress();
        addrStr = addrStr.replace(':', '.');
        return "IPCLoggerChannel-" + addrStr + "-" + addr.getPort();
    }

    @Metric(value={"Is the remote logger out of sync with the quorum"})
    public String isOutOfSync() {
        return Boolean.toString(this.ch.isOutOfSync());
    }

    @Metric(value={"The number of transactions the remote log is lagging behind the quorum"})
    public long getCurrentLagTxns() {
        return this.ch.getLagTxns();
    }

    @Metric(value={"The number of milliseconds the remote log is lagging behind the quorum"})
    public long getLagTimeMillis() {
        return this.ch.getLagTimeMillis();
    }

    @Metric(value={"The number of bytes of pending data to be sent to the remote node"})
    public int getQueuedEditsSize() {
        return this.ch.getQueuedEditsSize();
    }

    public void addWriteEndToEndLatency(long micros) {
        if (this.writeEndToEndLatencyQuantiles != null) {
            for (MutableQuantiles q : this.writeEndToEndLatencyQuantiles) {
                q.add(micros);
            }
        }
    }

    public void addWriteRpcLatency(long micros) {
        if (this.writeRpcLatencyQuantiles != null) {
            for (MutableQuantiles q : this.writeRpcLatencyQuantiles) {
                q.add(micros);
            }
        }
    }
}

