/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.drools;

import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.drools.RuleResultItem;
import org.apache.hop.pipeline.transforms.drools.Rules;
import org.apache.hop.pipeline.transforms.drools.RulesExecutorMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RulesExecutorDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = Rules.class;
    private RulesExecutorMeta input;
    private Label wlRuleFilePath;
    private Button wbRulesInEditor;
    private TextVar wRuleFilePath;
    private StyledTextComp wRulesEditor;
    private Label wlPosition;
    private TableView wResultColumnsFields;

    public RulesExecutorDialog(Shell parent, IVariables variables, RulesExecutorMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RulesExecutor.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"RulesDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        wTabFolder.setUnselectedCloseVisible(true);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addRulesTab(wTabFolder, margin);
        this.addRulesResultsTab(wTabFolder, margin);
        FormData fdAgg = new FormData();
        fdAgg.left = new FormAttachment(0, 0);
        fdAgg.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        wTabFolder.setSelection(0);
        this.getData();
        this.activeRuleFilenameField();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activeRuleFilenameField() {
        this.wlRuleFilePath.setEnabled(!this.wbRulesInEditor.getSelection());
        this.wRuleFilePath.setEnabled(!this.wbRulesInEditor.getSelection());
        this.wRulesEditor.setEnabled(this.wbRulesInEditor.getSelection());
    }

    private void addRulesTab(CTabFolder wTabFolder, int margin) {
        ModifyListener lsMod = e -> this.input.setChanged();
        CTabItem wRulesTab = new CTabItem(wTabFolder, 0);
        wRulesTab.setFont(GuiResource.getInstance().getFontDefault());
        wRulesTab.setText(BaseMessages.getString(PKG, (String)"RulesDialog.Tabs.RuleDefinition", (String[])new String[0]));
        Composite wRulesComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wRulesComp);
        FormLayout rulesLayout = new FormLayout();
        rulesLayout.marginWidth = 3;
        rulesLayout.marginHeight = 3;
        wRulesComp.setLayout((Layout)rulesLayout);
        this.wlRuleFilePath = new Label(wRulesComp, 16384);
        PropsUi.setLook((Widget)this.wlRuleFilePath);
        this.wlRuleFilePath.setText(BaseMessages.getString(PKG, (String)"RulesDialog.RulesFile.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment(0, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlRuleFilePath.setLayoutData((Object)fdlTransformation);
        Button wbBrowse = new Button(wRulesComp, 8);
        PropsUi.setLook((Widget)wbBrowse);
        wbBrowse.setText(BaseMessages.getString(PKG, (String)"RulesDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)this.wlRuleFilePath, Const.isOSX() ? 0 : 5);
        wbBrowse.setLayoutData((Object)fdBrowse);
        wbBrowse.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wRuleFilePath, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.wRuleFilePath = new TextVar(this.variables, wRulesComp, 18436);
        FormData fdRuleFilePath = new FormData();
        fdRuleFilePath.left = new FormAttachment(0, 0);
        fdRuleFilePath.top = new FormAttachment((Control)this.wlRuleFilePath, 5);
        fdRuleFilePath.right = new FormAttachment((Control)wbBrowse, -PropsUi.getMargin());
        this.wRuleFilePath.setLayoutData((Object)fdRuleFilePath);
        this.wbRulesInEditor = new Button(wRulesComp, 32);
        PropsUi.setLook((Widget)this.wbRulesInEditor);
        this.wbRulesInEditor.setText(BaseMessages.getString(PKG, (String)"RulesDialog.RuleDefinition.EnableScriptEditor.Label", (String[])new String[0]));
        FormData fdPipelineNameInField = new FormData();
        fdPipelineNameInField.left = new FormAttachment(0, 0);
        fdPipelineNameInField.top = new FormAttachment((Control)this.wRuleFilePath, margin);
        this.wbRulesInEditor.setLayoutData((Object)fdPipelineNameInField);
        this.wbRulesInEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesExecutorDialog.this.input.setChanged();
                RulesExecutorDialog.this.activeRuleFilenameField();
            }
        });
        this.wRulesEditor = new StyledTextComp(this.variables, wRulesComp, 19202);
        PropsUi.setLook((Widget)this.wRulesEditor, (int)1);
        FormData fdRulesEditor = new FormData();
        fdRulesEditor.left = new FormAttachment(0, 0);
        fdRulesEditor.top = new FormAttachment((Control)this.wbRulesInEditor, 5);
        fdRulesEditor.right = new FormAttachment(100, -2 * margin);
        fdRulesEditor.bottom = new FormAttachment(100, -12 * margin);
        this.wRulesEditor.setLayoutData((Object)fdRulesEditor);
        this.wRulesEditor.addModifyListener(lsMod);
        this.wRulesEditor.addModifyListener(arg0 -> this.setPosition());
        this.wRulesEditor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                RulesExecutorDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                RulesExecutorDialog.this.setPosition();
            }
        });
        this.wRulesEditor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                RulesExecutorDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                RulesExecutorDialog.this.setPosition();
            }
        });
        this.wRulesEditor.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                RulesExecutorDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                RulesExecutorDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                RulesExecutorDialog.this.setPosition();
            }
        });
        this.wlPosition = new Label(wRulesComp, 0);
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.top = new FormAttachment((Control)this.wRulesEditor, margin);
        fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        FormData fdRulesComp = new FormData();
        fdRulesComp.left = new FormAttachment(0, 0);
        fdRulesComp.top = new FormAttachment(0, 0);
        fdRulesComp.right = new FormAttachment(100, 0);
        fdRulesComp.bottom = new FormAttachment(100, 0);
        wRulesComp.setLayoutData((Object)fdRulesComp);
        wRulesComp.layout();
        wRulesTab.setControl((Control)wRulesComp);
    }

    private void setPosition() {
        int lineNumber = this.wRulesEditor.getLineNumber();
        int columnNumber = this.wRulesEditor.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"RulesDialog.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    private void addRulesResultsTab(CTabFolder wTabFolder, int margin) {
        CTabItem wRulesResultsTab = new CTabItem(wTabFolder, 0);
        wRulesResultsTab.setFont(GuiResource.getInstance().getFontDefault());
        wRulesResultsTab.setText(BaseMessages.getString(PKG, (String)"RulesDialog.Tabs.ColumnSelection", (String[])new String[0]));
        Composite wRulesResultsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wRulesResultsComp);
        FormLayout rulesResultsLayout = new FormLayout();
        rulesResultsLayout.marginWidth = 3;
        rulesResultsLayout.marginHeight = 3;
        wRulesResultsComp.setLayout((Layout)rulesResultsLayout);
        int nrRows = this.input.getRuleResultColumns() != null ? this.input.getRuleResultColumns().size() : 1;
        ColumnInfo[] ciResultFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RulesDialog.ColumnSelection.ColumnName", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RulesDialog.ColumnSelection.ColumnType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames())};
        this.wResultColumnsFields = new TableView(this.variables, wRulesResultsComp, 68354, ciResultFields, nrRows, false, null, this.props, false);
        FormData fdResultFields = new FormData();
        fdResultFields.left = new FormAttachment(0, 0);
        fdResultFields.top = new FormAttachment(0, 5);
        fdResultFields.right = new FormAttachment(100, 0);
        fdResultFields.bottom = new FormAttachment(100, -margin * 8);
        this.wResultColumnsFields.setLayoutData((Object)fdResultFields);
        this.wResultColumnsFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 25, 25}));
        FormData fdRulesResultsComp = new FormData();
        fdRulesResultsComp.left = new FormAttachment(0, 0);
        fdRulesResultsComp.top = new FormAttachment(0, 0);
        fdRulesResultsComp.right = new FormAttachment(100, 0);
        fdRulesResultsComp.bottom = new FormAttachment(100, 0);
        wRulesResultsComp.setLayoutData((Object)fdRulesResultsComp);
        wRulesResultsComp.layout();
        wRulesResultsTab.setControl((Control)wRulesResultsComp);
        this.getData();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setRuleFile(this.wRuleFilePath.getText());
        this.input.setRuleDefinition(this.wRulesEditor.getText());
        this.input.getRuleResultColumns().clear();
        for (int i = 0; i < this.wResultColumnsFields.nrNonEmpty(); ++i) {
            TableItem item = this.wResultColumnsFields.getNonEmpty(i);
            if (Utils.isEmpty((CharSequence)item.getText(1))) continue;
            this.input.getRuleResultColumns().add(new RuleResultItem(item.getText(1), item.getText(2)));
        }
        this.dispose();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(false);
        this.dispose();
    }

    public void getData() {
        if (this.input.getRuleFile() != null) {
            this.wlRuleFilePath.setText(this.input.getRuleFile());
        }
        if (this.input.getRuleDefinition() != null) {
            this.wRulesEditor.setText(this.input.getRuleDefinition());
        }
        this.wbRulesInEditor.setSelection(this.input.getRuleDefinition() != null);
        for (int i = 0; i < this.input.getRuleResultColumns().size(); ++i) {
            TableItem ti = this.wResultColumnsFields.table.getItem(i);
            RuleResultItem ri = this.input.getRuleResultColumns().get(i);
            ti.setText(1, ri.getName());
            ti.setText(2, ri.getType());
        }
        this.wResultColumnsFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }
}

