/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.input.MappingInput;
import org.apache.hop.pipeline.transforms.mapping.RowDataInputMapper;
import org.apache.hop.pipeline.transforms.mapping.RowOutputDataMapper;
import org.apache.hop.pipeline.transforms.mapping.SimpleMappingData;
import org.apache.hop.pipeline.transforms.mapping.SimpleMappingMeta;
import org.apache.hop.pipeline.transforms.output.MappingOutput;

public class SimpleMapping
extends BaseTransform<SimpleMappingMeta, SimpleMappingData> {
    private static final Class<?> PKG = SimpleMappingMeta.class;

    public SimpleMapping(TransformMeta transformMeta, SimpleMappingMeta meta, SimpleMappingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        try {
            if (this.first) {
                this.first = false;
                ((SimpleMappingData)this.data).wasStarted = true;
                String mappingInputTransformName = ((SimpleMappingData)this.data).mappingInput.getTransformName();
                RowProducer rowProducer = ((SimpleMappingData)this.data).mappingPipeline.addRowProducer(mappingInputTransformName, 0);
                ((SimpleMappingData)this.data).rowDataInputMapper = new RowDataInputMapper(((SimpleMappingMeta)this.meta).getInputMapping(), rowProducer);
                String mappingOutputTransformName = ((SimpleMappingData)this.data).mappingOutput.getTransformName();
                ITransform iOutputTransform = ((SimpleMappingData)this.data).mappingPipeline.getTransform(mappingOutputTransformName, 0);
                RowOutputDataMapper outputDataMapper = new RowOutputDataMapper(((SimpleMappingMeta)this.meta).getInputMapping(), ((SimpleMappingMeta)this.meta).getOutputMapping(), (arg_0, arg_1) -> ((SimpleMapping)this).putRow(arg_0, arg_1));
                iOutputTransform.addRowListener((IRowListener)outputDataMapper);
                ((SimpleMappingData)this.data).mappingPipeline.startThreads();
            }
            Object[] row = this.getRow();
            boolean rowWasPut = false;
            if (row != null) {
                while (!((SimpleMappingData)this.data).mappingPipeline.isFinishedOrStopped() && !rowWasPut) {
                    rowWasPut = ((SimpleMappingData)this.data).rowDataInputMapper.putRow(this.getInputRowMeta(), row);
                }
            }
            if (!rowWasPut) {
                ((SimpleMappingData)this.data).rowDataInputMapper.finished();
                ((SimpleMappingData)this.data).mappingPipeline.waitUntilFinished();
                this.setOutputDone();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (((SimpleMappingData)this.data).mappingPipeline != null) {
                ((SimpleMappingData)this.data).mappingPipeline.stopAll();
            }
            throw new HopException((Throwable)e);
        }
    }

    public void prepareMappingExecution() throws HopException {
        String runConfigName;
        if (((SimpleMappingData)this.data).isBeamContext()) {
            ((SimpleMappingData)this.data).mappingPipelineMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
        }
        SimpleMappingData simpleMappingData = (SimpleMappingData)this.getData();
        if (simpleMappingData.mappingPipelineMeta == null) {
            simpleMappingData.mappingPipelineMeta = new PipelineMeta(this.variables.resolve(((SimpleMappingMeta)this.meta).getFilename()), this.metadataProvider, this.variables);
            simpleMappingData.mappingPipelineMeta.clearChanged();
        }
        if (StringUtils.isEmpty((String)(runConfigName = this.resolve(((SimpleMappingMeta)this.meta).getRunConfigurationName())))) {
            simpleMappingData.mappingPipeline = new LocalPipelineEngine(simpleMappingData.mappingPipelineMeta, (IVariables)this, (ILoggingObject)this);
        } else {
            PipelineRunConfiguration runConfig = (PipelineRunConfiguration)this.metadataProvider.getSerializer(PipelineRunConfiguration.class).load(runConfigName);
            if (runConfig == null) {
                throw new HopException("Unable to find run configuration with name " + runConfigName);
            }
            if (!(runConfig.getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) {
                throw new HopException("Apache Hop can only run simple mappings with a local pipeline engine, not with run configuration " + runConfigName);
            }
            simpleMappingData.mappingPipeline = (LocalPipelineEngine)PipelineEngineFactory.createPipelineEngine((IVariables)this, (String)runConfigName, (IHopMetadataProvider)this.metadataProvider, (PipelineMeta)simpleMappingData.mappingPipelineMeta);
        }
        simpleMappingData.mappingPipeline.copyParametersFromDefinitions((INamedParameterDefinitions)simpleMappingData.mappingPipelineMeta);
        TransformWithMappingMeta.activateParams((IVariables)simpleMappingData.mappingPipeline, (INamedParameters)simpleMappingData.mappingPipeline, (IVariables)this, (String[])simpleMappingData.mappingPipelineMeta.listParameters(), (String[])((SimpleMappingMeta)this.meta).getMappingParameters().getVariables(), (String[])((SimpleMappingMeta)this.meta).getMappingParameters().getInputs(), (boolean)((SimpleMappingMeta)this.meta).getMappingParameters().isInheritingAllVariables());
        simpleMappingData.mappingPipeline.setParentPipeline(this.getPipeline());
        simpleMappingData.mappingPipeline.setParent((ILoggingObject)this);
        simpleMappingData.mappingPipeline.setSafeModeEnabled(this.getPipeline().isSafeModeEnabled());
        simpleMappingData.mappingPipeline.setGatheringMetrics(this.getPipeline().isGatheringMetrics());
        try {
            simpleMappingData.mappingPipeline.prepareExecution();
        }
        catch (HopException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SimpleMapping.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        List<MappingInput> mappingInputs = SimpleMapping.findMappingInputs((Pipeline)simpleMappingData.mappingPipeline);
        if (mappingInputs.isEmpty()) {
            throw new HopException("The simple mapping transform needs one Mapping Input transform to write to in the sub-pipeline");
        }
        if (mappingInputs.size() > 1) {
            throw new HopException("The simple mapping transform does not support multiple Mapping Input transforms to write to in the sub-pipeline");
        }
        simpleMappingData.mappingInput = mappingInputs.get(0);
        List<MappingOutput> mappingOutputs = this.findMappingOutputs((Pipeline)simpleMappingData.mappingPipeline);
        if (mappingOutputs.isEmpty()) {
            throw new HopException("The simple mapping transform needs one Mapping Output transform to read from in the sub-pipeline");
        }
        if (mappingOutputs.size() > 1) {
            throw new HopException("The simple mapping transform does not support multiple Mapping Output transforms to read from in the sub-pipeline");
        }
        simpleMappingData.mappingOutput = mappingOutputs.get(0);
        this.getPipeline().addActiveSubPipeline(this.getTransformName(), (IPipelineEngine)simpleMappingData.mappingPipeline);
    }

    public static List<MappingInput> findMappingInputs(Pipeline mappingPipeline) {
        ArrayList<MappingInput> list = new ArrayList<MappingInput>();
        List components = mappingPipeline.getComponents();
        for (IEngineComponent component : components) {
            if (!(component instanceof MappingInput)) continue;
            list.add((MappingInput)component);
        }
        return list;
    }

    private List<MappingOutput> findMappingOutputs(Pipeline mappingPipeline) {
        ArrayList<MappingOutput> list = new ArrayList<MappingOutput>();
        List components = mappingPipeline.getComponents();
        for (IEngineComponent component : components) {
            if (!(component instanceof MappingOutput)) continue;
            list.add((MappingOutput)component);
        }
        return list;
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((SimpleMappingData)this.data).mappingPipelineMeta = TransformWithMappingMeta.loadMappingMeta((TransformWithMappingMeta)((TransformWithMappingMeta)this.meta), (IHopMetadataProvider)this.getMetadataProvider(), (IVariables)this);
                if (((SimpleMappingData)this.data).mappingPipelineMeta != null) {
                    this.prepareMappingExecution();
                    if (((SimpleMappingData)this.data).isBeamContext()) {
                        ((SimpleMappingData)this.data).executor = new SingleThreadedPipelineExecutor((Pipeline)((SimpleMappingData)this.data).mappingPipeline);
                    }
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping pipeline because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    public void dispose() {
        if (((SimpleMappingData)this.data).isBeamContext()) {
            try {
                ((SimpleMappingData)this.data).executor.dispose();
            }
            catch (Exception e) {
                this.logError("Error calling dispose() on single threaded Simple Mapping executor", e);
                this.setErrors(1L);
            }
        } else if (((SimpleMappingData)this.data).wasStarted && !((SimpleMappingData)this.data).mappingPipeline.isFinished()) {
            ((SimpleMappingData)this.data).mappingPipeline.waitUntilFinished();
        }
        if (((SimpleMappingData)this.getData()).mappingPipeline.getErrors() > 0) {
            this.logError(BaseMessages.getString(PKG, (String)"SimpleMapping.Log.ErrorOccurredInSubPipeline", (String[])new String[0]));
            this.setErrors(1L);
        }
        super.dispose();
    }

    public void batchComplete() throws HopException {
        if (((SimpleMappingData)this.data).isBeamContext()) {
            ((SimpleMappingData)this.data).executor.oneIteration();
        }
    }

    public void startBundle() throws HopException {
    }

    public void finishBundle() throws HopException {
    }

    public void stopRunning() {
        if (((SimpleMappingData)this.data).mappingPipeline != null) {
            ((SimpleMappingData)this.data).mappingPipeline.stopAll();
        }
    }

    public void stopAll() {
        if (((SimpleMappingData)this.data).mappingPipeline != null) {
            ((SimpleMappingData)this.data).mappingPipeline.stopAll();
        }
        super.stopAll();
    }

    public Pipeline getMappingPipeline() {
        return ((SimpleMappingData)this.data).mappingPipeline;
    }
}

