/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.systemdata;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataMeta;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataTypes;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SystemDataDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SystemDataMeta.class;
    private Text wTransformName;
    private TableView wFields;
    private final SystemDataMeta input;

    public SystemDataDialog(Shell parent, IVariables variables, SystemDataMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SystemDataDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        boolean isReceivingInput = !this.pipelineMeta.findPreviousTransforms(this.transformMeta).isEmpty();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"SystemDataDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.setEnabled(!isReceivingInput);
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SystemDataDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 2;
        int FieldsRows = this.input.getFieldName().length;
        final String[] functionDesc = new String[SystemDataTypes.values().length - 1];
        for (int i = 1; i < SystemDataTypes.values().length; ++i) {
            functionDesc[i - 1] = SystemDataTypes.values()[i].getDescription();
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SystemDataDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SystemDataDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd = new EnterSelectionDialog(SystemDataDialog.this.shell, functionDesc, BaseMessages.getString(PKG, (String)"SystemDataDialog.SelectInfoType.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.SelectInfoType.DialogMessage", (String[])new String[0]));
                String string = esd.open();
                if (string != null) {
                    TableView tv = (TableView)e.widget;
                    tv.setText(string, e.x, e.y);
                }
                SystemDataDialog.this.input.setChanged();
            }
        });
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            String name = this.input.getFieldName()[i];
            String type = this.input.getFieldType()[i].getDescription();
            if (name != null) {
                item.setText(1, name);
            }
            if (type == null) continue;
            item.setText(2, type);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), e);
        }
        this.dispose();
    }

    private void getInfo(SystemDataMeta in) {
        this.transformName = this.wTransformName.getText();
        int count = this.wFields.nrNonEmpty();
        in.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            in.getFieldName()[i] = item.getText(1);
            in.getFieldType()[i] = SystemDataTypes.getTypeFromString(item.getText(2));
        }
    }

    private void preview() {
        try {
            SystemDataMeta oneMeta = new SystemDataMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"SystemDataDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), e);
        }
    }
}

