/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.DropwizardNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.DropwizardSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultMetrics
implements Metrics {
    private final MetricRegistry registry;
    private final DropwizardSessionMetricUpdater sessionUpdater;

    public DefaultMetrics(MetricRegistry registry, DropwizardSessionMetricUpdater sessionUpdater) {
        this.registry = registry;
        this.sessionUpdater = sessionUpdater;
    }

    @Override
    @NonNull
    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Override
    @NonNull
    public <T extends Metric> Optional<T> getSessionMetric(@NonNull SessionMetric metric, String profileName) {
        return Optional.ofNullable(this.sessionUpdater.getMetric(metric, profileName));
    }

    @Override
    @NonNull
    public <T extends Metric> Optional<T> getNodeMetric(@NonNull Node node, @NonNull NodeMetric metric, String profileName) {
        NodeMetricUpdater nodeUpdater = ((DefaultNode)node).getMetricUpdater();
        return Optional.ofNullable(((DropwizardNodeMetricUpdater)nodeUpdater).getMetric(metric, profileName));
    }
}

