/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.OrFinallyTrigger;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public abstract class Trigger
implements Serializable {
    protected final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers;

    protected Trigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers) {
        this.subTriggers = subTriggers;
    }

    protected Trigger() {
        this(Collections.emptyList());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers() {
        return MoreObjects.firstNonNull(this.subTriggers, Collections.emptyList());
    }

    public @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger() {
        if (this.subTriggers == null) {
            return this.getContinuationTrigger(null);
        }
        ArrayList<Trigger> subTriggerContinuations = new ArrayList<Trigger>();
        for (Trigger subTrigger : this.subTriggers) {
            subTriggerContinuations.add(subTrigger.getContinuationTrigger());
        }
        return this.getContinuationTrigger(subTriggerContinuations);
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> var1);

    @Internal
    public abstract @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1);

    @Internal
    public abstract @UnknownKeyFor @NonNull @Initialized boolean mayFinish();

    @Internal
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized Trigger other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.subTriggers == null) {
            return other.subTriggers == null;
        }
        if (other.subTriggers == null) {
            return false;
        }
        if (this.subTriggers.size() != other.subTriggers.size()) {
            return false;
        }
        for (int i = 0; i < this.subTriggers.size(); ++i) {
            if (this.subTriggers.get(i).isCompatible(other.subTriggers.get(i))) continue;
            return false;
        }
        return true;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (this.getClass().getEnclosingClass() != null) {
            simpleName = this.getClass().getEnclosingClass().getSimpleName() + "." + simpleName;
        }
        if (this.subTriggers == null || this.subTriggers.isEmpty()) {
            return simpleName;
        }
        return simpleName + "(" + Joiner.on(", ").join(this.subTriggers) + ")";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger that = (Trigger)obj;
        return Objects.equals(this.getClass(), that.getClass()) && Objects.equals(this.subTriggers, that.subTriggers);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getClass(), this.subTriggers);
    }

    public @UnknownKeyFor @NonNull @Initialized OrFinallyTrigger orFinally(@UnknownKeyFor @NonNull @Initialized OnceTrigger until) {
        return new OrFinallyTrigger(this, until);
    }

    @Internal
    public static abstract class OnceTrigger
    extends Trigger {
        protected OnceTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers) {
            super(subTriggers);
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized boolean mayFinish() {
            return true;
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized OnceTrigger getContinuationTrigger() {
            Trigger continuation = super.getContinuationTrigger();
            if (!(continuation instanceof OnceTrigger)) {
                throw new IllegalStateException("Continuation of a OnceTrigger must be a OnceTrigger");
            }
            return (OnceTrigger)continuation;
        }
    }
}

