/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashingOutputStream;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@Deprecated
public class ApproximateUnique {
    public static <T> @UnknownKeyFor @NonNull @Initialized Globally<T> globally(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
        return new Globally(sampleSize);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Globally<T> globally(@UnknownKeyFor @NonNull @Initialized double maximumEstimationError) {
        return new Globally(maximumEstimationError);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKey<K, V> perKey(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
        return new PerKey(sampleSize);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKey<K, V> perKey(@UnknownKeyFor @NonNull @Initialized double maximumEstimationError) {
        return new PerKey(maximumEstimationError);
    }

    static @UnknownKeyFor @NonNull @Initialized long sampleSizeFromEstimationError(@UnknownKeyFor @NonNull @Initialized double estimationError) {
        return Math.round(Math.ceil(4.0 / Math.pow(estimationError, 2.0)));
    }

    private static void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, @UnknownKeyFor @NonNull @Initialized long sampleSize, @Nullable @UnknownKeyFor @Initialized Double maxEstimationError) {
        builder.add(DisplayData.item("sampleSize", sampleSize).withLabel("Sample Size")).addIfNotNull(DisplayData.item("maximumEstimationError", maxEstimationError).withLabel("Maximum Estimation Error"));
    }

    public static class ApproximateUniqueCombineFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, LargestUnique, Long> {
        static final @UnknownKeyFor @NonNull @Initialized double HASH_SPACE_SIZE = 1.8446744073709552E19;
        private final @UnknownKeyFor @NonNull @Initialized long sampleSize;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        public ApproximateUniqueCombineFn(@UnknownKeyFor @NonNull @Initialized long sampleSize, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.sampleSize = sampleSize;
            this.coder = coder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized LargestUnique createAccumulator() {
            return new LargestUnique(this.sampleSize);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized LargestUnique addInput(@UnknownKeyFor @NonNull @Initialized LargestUnique heap, T input) {
            try {
                heap.add(ApproximateUniqueCombineFn.hash(input, this.coder));
                return heap;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized LargestUnique mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized LargestUnique> heaps) {
            Iterator<LargestUnique> iterator = heaps.iterator();
            LargestUnique accumulator = iterator.next();
            while (iterator.hasNext()) {
                iterator.next().heap.forEach(h -> accumulator.add((long)h));
            }
            return accumulator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized LargestUnique heap) {
            return heap.getEstimate();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized LargestUnique> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
            return SerializableCoder.of(LargestUnique.class);
        }

        static <T> @UnknownKeyFor @NonNull @Initialized long hash(T element, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            try (HashingOutputStream stream = new HashingOutputStream(Hashing.murmur3_128(), ByteStreams.nullOutputStream());){
                coder.encode(element, stream, Coder.Context.OUTER);
                long l = stream.hash().asLong();
                return l;
            }
        }

        public static class LargestUnique
        implements Serializable {
            private @UnknownKeyFor @NonNull @Initialized TreeSet<@UnknownKeyFor @NonNull @Initialized Long> heap = new TreeSet();
            private @UnknownKeyFor @NonNull @Initialized long minHash = Long.MAX_VALUE;
            private final @UnknownKeyFor @NonNull @Initialized long sampleSize;

            public LargestUnique(@UnknownKeyFor @NonNull @Initialized long sampleSize) {
                this.sampleSize = sampleSize;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean add(@UnknownKeyFor @NonNull @Initialized long value) {
                if ((long)this.heap.size() >= this.sampleSize && value < this.minHash) {
                    return false;
                }
                if (this.heap.add(value)) {
                    if ((long)this.heap.size() > this.sampleSize) {
                        this.heap.remove(this.minHash);
                        this.minHash = this.heap.first();
                    } else if (value < this.minHash) {
                        this.minHash = value;
                    }
                }
                return true;
            }

            @UnknownKeyFor @NonNull @Initialized long getEstimate() {
                if ((long)this.heap.size() < this.sampleSize) {
                    return this.heap.size();
                }
                double sampleSpaceSize = 9.223372036854776E18 - (double)this.minHash;
                double estimate = Math.log1p((double)(-this.sampleSize) / sampleSpaceSize) / Math.log1p(-1.0 / sampleSpaceSize) * 1.8446744073709552E19 / sampleSpaceSize;
                return Math.round(estimate);
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LargestUnique that = (LargestUnique)o;
                return this.sampleSize == that.sampleSize && Iterables.elementsEqual(this.heap, that.heap);
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return Objects.hashCode(Lists.newArrayList(this.heap), this.sampleSize);
            }
        }
    }

    public static final class PerKey<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> {
        private final @UnknownKeyFor @NonNull @Initialized long sampleSize;
        private final @Nullable @UnknownKeyFor @Initialized Double maximumEstimationError;

        public PerKey(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
            if (sampleSize < 16) {
                throw new IllegalArgumentException("ApproximateUnique needs a sampleSize >= 16 for an estimation error <= 50%.  In general, the estimation error is about 2 / sqrt(sampleSize).");
            }
            this.sampleSize = sampleSize;
            this.maximumEstimationError = null;
        }

        public PerKey(@UnknownKeyFor @NonNull @Initialized double estimationError) {
            if (estimationError < 0.01 || estimationError > 0.5) {
                throw new IllegalArgumentException("ApproximateUnique.PerKey needs an estimation error between 1% (0.01) and 50% (0.5).");
            }
            this.sampleSize = ApproximateUnique.sampleSizeFromEstimationError(estimationError);
            this.maximumEstimationError = estimationError;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            Coder<KV<K, V>> inputCoder = input.getCoder();
            if (!(inputCoder instanceof KvCoder)) {
                throw new IllegalStateException("ApproximateUnique.PerKey requires its input to use KvCoder");
            }
            Coder coder = ((KvCoder)inputCoder).getValueCoder();
            return (PCollection)input.apply(Combine.perKey(new ApproximateUniqueCombineFn(this.sampleSize, coder)));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateUnique.populateDisplayData(builder, this.sampleSize, this.maximumEstimationError);
        }
    }

    public static final class Globally<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Long>> {
        private final @UnknownKeyFor @NonNull @Initialized long sampleSize;
        private final @Nullable @UnknownKeyFor @Initialized Double maximumEstimationError;

        public Globally(@UnknownKeyFor @NonNull @Initialized int sampleSize) {
            if (sampleSize < 16) {
                throw new IllegalArgumentException("ApproximateUnique needs a sampleSize >= 16 for an estimation error <= 50%.  In general, the estimation error is about 2 / sqrt(sampleSize).");
            }
            this.sampleSize = sampleSize;
            this.maximumEstimationError = null;
        }

        public Globally(@UnknownKeyFor @NonNull @Initialized double maximumEstimationError) {
            if (maximumEstimationError < 0.01 || maximumEstimationError > 0.5) {
                throw new IllegalArgumentException("ApproximateUnique needs an estimation error between 1% (0.01) and 50% (0.5).");
            }
            this.sampleSize = ApproximateUnique.sampleSizeFromEstimationError(maximumEstimationError);
            this.maximumEstimationError = maximumEstimationError;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Coder<T> coder = input.getCoder();
            return (PCollection)input.apply(Combine.globally(new ApproximateUniqueCombineFn<T>(this.sampleSize, coder)));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ApproximateUnique.populateDisplayData(builder, this.sampleSize, this.maximumEstimationError);
        }
    }
}

