/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class FromRowUsingCreator<@UnknownKeyFor T>
implements SerializableFunction<Row, T>,
Function<Row, T> {
    private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized GetterBasedSchemaProvider schemaProvider;
    private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator> schemaTypeCreatorFactory;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient @MonotonicNonNull @UnknownKeyFor @Initialized Function @UnknownKeyFor @NonNull @Initialized [] fieldConverters;

    public FromRowUsingCreator(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized GetterBasedSchemaProvider schemaProvider) {
        this(typeDescriptor, schemaProvider, new CachingFactory<SchemaUserTypeCreator>(schemaProvider::schemaTypeCreator), null);
    }

    private FromRowUsingCreator(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized GetterBasedSchemaProvider schemaProvider, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator> schemaTypeCreatorFactory, @Nullable @UnknownKeyFor @Initialized Function @UnknownKeyFor @NonNull @Initialized [] fieldConverters) {
        this.typeDescriptor = typeDescriptor;
        this.schemaProvider = schemaProvider;
        this.schemaTypeCreatorFactory = schemaTypeCreatorFactory;
        this.fieldConverters = fieldConverters;
    }

    @Override
    public T apply(@UnknownKeyFor @NonNull @Initialized Row row) {
        Object target;
        if (row == null) {
            return null;
        }
        if (row instanceof RowWithGetters && (target = ((RowWithGetters)row).getGetterTarget()).getClass().equals(this.typeDescriptor.getRawType())) {
            return (T)target;
        }
        if (this.fieldConverters == null) {
            this.initFieldConverters(row.getSchema());
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState(this.fieldConverters.length == row.getFieldCount(), "Unexpected field count");
        Object[] params = new Object[row.getFieldCount()];
        for (int i = 0; i < row.getFieldCount(); ++i) {
            params[i] = this.fieldConverters[i].apply(row.getValue(i));
        }
        SchemaUserTypeCreator creator = this.schemaTypeCreatorFactory.create(this.typeDescriptor, row.getSchema());
        return (T)creator.create(params);
    }

    private synchronized void initFieldConverters(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (this.fieldConverters == null) {
            CachingFactory<List<FieldValueTypeInformation>> typeFactory = new CachingFactory<List<FieldValueTypeInformation>>(this.schemaProvider::fieldValueTypeInformations);
            this.fieldConverters = this.fieldConverters(this.typeDescriptor, schema, typeFactory);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Function @UnknownKeyFor @NonNull @Initialized [] fieldConverters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation>> typeFactory) {
        List<FieldValueTypeInformation> typeInfos = typeFactory.create(typeDescriptor, schema);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState(typeInfos.size() == schema.getFieldCount(), "Did not have a matching number of type informations and fields.");
        Function[] converters = new Function[schema.getFieldCount()];
        for (int i = 0; i < converters.length; ++i) {
            converters[i] = this.fieldConverter(schema.getField(i).getType(), typeInfos.get(i), typeFactory);
        }
        return converters;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean needsConversion(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
        Schema.TypeName typeName = type.getTypeName();
        return typeName.equals((Object)Schema.TypeName.ROW) || typeName.isLogicalType() || (typeName.equals((Object)Schema.TypeName.ARRAY) || typeName.equals((Object)Schema.TypeName.ITERABLE)) && FromRowUsingCreator.needsConversion(type.getCollectionElementType()) || typeName.equals((Object)Schema.TypeName.MAP) && (FromRowUsingCreator.needsConversion(type.getMapKeyType()) || FromRowUsingCreator.needsConversion(type.getMapValueType()));
    }

    private @UnknownKeyFor @NonNull @Initialized Function fieldConverter(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type, @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation typeInfo, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation>> typeFactory) {
        if (!FromRowUsingCreator.needsConversion(type)) {
            return FieldConverter.IDENTITY;
        }
        if (Schema.TypeName.ROW.equals((Object)type.getTypeName())) {
            Function[] converters = this.fieldConverters(typeInfo.getType(), type.getRowSchema(), typeFactory);
            return new FromRowUsingCreator(typeInfo.getType(), this.schemaProvider, this.schemaTypeCreatorFactory, converters);
        }
        if (Schema.TypeName.ARRAY.equals((Object)type.getTypeName())) {
            return new ConvertCollection(this.fieldConverter(type.getCollectionElementType(), typeInfo.getElementType(), typeFactory));
        }
        if (Schema.TypeName.ITERABLE.equals((Object)type.getTypeName())) {
            return new ConvertIterable(this.fieldConverter(type.getCollectionElementType(), typeInfo.getElementType(), typeFactory));
        }
        if (Schema.TypeName.MAP.equals((Object)type.getTypeName())) {
            return new ConvertMap(this.fieldConverter(type.getMapKeyType(), typeInfo.getMapKeyType(), typeFactory), this.fieldConverter(type.getMapValueType(), typeInfo.getMapValueType(), typeFactory));
        }
        if (type.isLogicalType("OneOf")) {
            OneOfType oneOfType = type.getLogicalType(OneOfType.class);
            Schema schema = oneOfType.getOneOfSchema();
            HashMap<Integer, Function> readers = Maps.newHashMapWithExpectedSize(schema.getFieldCount());
            oneOfType.getCaseEnumType().getValuesMap().forEach((name, id) -> {
                Schema.FieldType caseType = schema.getField((String)name).getType();
                FieldValueTypeInformation caseTypeInfo = org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(typeInfo.getOneOfTypes().get(name));
                readers.put((Integer)id, this.fieldConverter(caseType, caseTypeInfo, typeFactory));
            });
            return new ConvertOneOf(oneOfType, readers);
        }
        if (type.getTypeName().isLogicalType()) {
            return new ConvertLogicalType(type.getLogicalType());
        }
        return FieldConverter.IDENTITY;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FromRowUsingCreator that = (FromRowUsingCreator)o;
        return this.typeDescriptor.equals(that.typeDescriptor) && this.schemaProvider.equals(that.schemaProvider);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.typeDescriptor, this.schemaProvider);
    }

    private static class ConvertLogicalType<@UnknownKeyFor FieldT, @UnknownKeyFor ValueT>
    implements FieldConverter<FieldT, ValueT> {
        final @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<FieldT, ValueT> logicalType;

        ConvertLogicalType(@UnknownKeyFor @NonNull @Initialized Schema.LogicalType<FieldT, ValueT> logicalType) {
            this.logicalType = logicalType;
        }

        @Override
        public ValueT convert(FieldT field) {
            return this.logicalType.toBaseType(field);
        }
    }

    private static class ConvertOneOf
    implements FieldConverter<OneOfType.Value, OneOfType.Value> {
        final @UnknownKeyFor @NonNull @Initialized OneOfType oneOfType;
        final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Function> converters;

        ConvertOneOf(@UnknownKeyFor @NonNull @Initialized OneOfType oneOfType, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Function> converters) {
            this.oneOfType = oneOfType;
            this.converters = converters;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OneOfType.Value convert(@UnknownKeyFor @NonNull @Initialized OneOfType.Value field) {
            EnumerationType.Value caseType = field.getCaseType();
            Function converter = Preconditions.checkStateNotNull(this.converters.get(caseType.getValue()), "Missing OneOf converter for case %s.");
            return this.oneOfType.createValue(caseType, converter.apply(field.getValue()));
        }
    }

    private static class ConvertMap
    implements FieldConverter<Map, Map> {
        final @UnknownKeyFor @NonNull @Initialized Function keyConverter;
        final @UnknownKeyFor @NonNull @Initialized Function valueConverter;

        ConvertMap(@UnknownKeyFor @NonNull @Initialized Function keyConverter, @UnknownKeyFor @NonNull @Initialized Function valueConverter) {
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map convert(@UnknownKeyFor @NonNull @Initialized Map field) {
            HashMap result = Maps.newHashMapWithExpectedSize(field.size());
            field.forEach((k, v) -> result.put(this.keyConverter.apply(k), this.valueConverter.apply(v)));
            return result;
        }
    }

    private static class ConvertIterable
    implements FieldConverter<Iterable, Iterable> {
        final @UnknownKeyFor @NonNull @Initialized Function converter;

        ConvertIterable(@UnknownKeyFor @NonNull @Initialized Function converter) {
            this.converter = converter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable convert(@UnknownKeyFor @NonNull @Initialized Iterable iterable) {
            return Iterables.transform(iterable, this.converter);
        }
    }

    private static class ConvertCollection
    implements FieldConverter<Collection, Collection> {
        final @UnknownKeyFor @NonNull @Initialized Function converter;

        ConvertCollection(@UnknownKeyFor @NonNull @Initialized Function converter) {
            this.converter = converter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection convert(@UnknownKeyFor @NonNull @Initialized Collection collection) {
            if (collection instanceof List) {
                return Lists.transform((List)collection, this.converter);
            }
            return Collections2.transform(collection, this.converter);
        }
    }

    private static interface FieldConverter<@UnknownKeyFor FieldT, @UnknownKeyFor ValueT>
    extends SerializableFunction<FieldT, ValueT>,
    Function<FieldT, ValueT> {
        public static final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> IDENTITY = v -> v;

        public ValueT convert(FieldT var1);

        @Override
        default public @Nullable ValueT apply(@Nullable FieldT fieldValue) {
            return fieldValue == null ? null : (ValueT)this.convert(fieldValue);
        }
    }
}

