/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.splitfieldtorows;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.splitfieldtorows.SplitFieldToRowsData;
import org.apache.hop.pipeline.transforms.splitfieldtorows.SplitFieldToRowsMeta;

public class SplitFieldToRows
extends BaseTransform<SplitFieldToRowsMeta, SplitFieldToRowsData> {
    private static final Class<?> PKG = SplitFieldToRowsMeta.class;

    public SplitFieldToRows(TransformMeta transformMeta, SplitFieldToRowsMeta meta, SplitFieldToRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private boolean splitField(IRowMeta rowMeta, Object[] rowData) throws HopException {
        String[] splitStrings;
        String originalString;
        if (this.first) {
            String realRowNumberField;
            this.first = false;
            ((SplitFieldToRowsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((SplitFieldToRowsMeta)this.meta).getFields(((SplitFieldToRowsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            String realSplitFieldName = this.resolve(((SplitFieldToRowsMeta)this.meta).getSplitField());
            ((SplitFieldToRowsData)this.data).fieldnr = rowMeta.indexOfValue(realSplitFieldName);
            int numErrors = 0;
            if (Utils.isEmpty((CharSequence)((SplitFieldToRowsMeta)this.meta).getNewFieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.NewFieldNameIsNull", (String[])new String[0]));
                ++numErrors;
            }
            if (((SplitFieldToRowsData)this.data).fieldnr < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.CouldNotFindFieldToSplit", (String[])new String[]{realSplitFieldName}));
                ++numErrors;
            }
            if (!rowMeta.getValueMeta(((SplitFieldToRowsData)this.data).fieldnr).isString()) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.SplitFieldNotValid", (String[])new String[]{realSplitFieldName}));
                ++numErrors;
            }
            if (((SplitFieldToRowsMeta)this.meta).isIncludeRowNumber() && Utils.isEmpty((CharSequence)(realRowNumberField = this.resolve(((SplitFieldToRowsMeta)this.meta).getRowNumberField())))) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Exception.RownrFieldMissing", (String[])new String[0]));
                ++numErrors;
            }
            if (numErrors > 0) {
                this.setErrors(numErrors);
                this.stopAll();
                return false;
            }
            ((SplitFieldToRowsData)this.data).splitMeta = rowMeta.getValueMeta(((SplitFieldToRowsData)this.data).fieldnr);
        }
        if ((originalString = ((SplitFieldToRowsData)this.data).splitMeta.getString(rowData[((SplitFieldToRowsData)this.data).fieldnr])) == null) {
            originalString = "";
        }
        if (((SplitFieldToRowsMeta)this.meta).isIncludeRowNumber() && ((SplitFieldToRowsMeta)this.meta).isResetRowNumber()) {
            ((SplitFieldToRowsData)this.data).rownr = 1L;
        }
        for (String string : splitStrings = ((SplitFieldToRowsData)this.data).delimiterPattern.split(originalString, -1)) {
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])rowData, (int)((SplitFieldToRowsData)this.data).outputRowMeta.size());
            outputRow[rowMeta.size()] = string;
            if (((SplitFieldToRowsMeta)this.meta).isIncludeRowNumber()) {
                outputRow[rowMeta.size() + 1] = ((SplitFieldToRowsData)this.data).rownr;
            }
            this.putRow(((SplitFieldToRowsData)this.data).outputRowMeta, outputRow);
            ++((SplitFieldToRowsData)this.data).rownr;
        }
        return true;
    }

    public synchronized boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        boolean ok = this.splitField(this.getInputRowMeta(), r);
        if (!ok) {
            this.setOutputDone();
            return false;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((SplitFieldToRowsData)this.data).rownr = 1L;
            try {
                String delimiter = Const.nullToEmpty((String)((SplitFieldToRowsMeta)this.meta).getDelimiter());
                ((SplitFieldToRowsData)this.data).delimiterPattern = ((SplitFieldToRowsMeta)this.meta).isIsDelimiterRegex() ? Pattern.compile(this.resolve(delimiter)) : Pattern.compile(Pattern.quote(this.resolve(delimiter)));
            }
            catch (PatternSyntaxException pse) {
                this.log.logError(pse.getMessage());
                throw pse;
            }
            return true;
        }
        return false;
    }
}

