/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.kotlin.grpcserver;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.SchemaEncoder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/squareup/wire/kotlin/grpcserver/FileDescriptorGenerator;", "", "()V", "FDS_CHUNK_SIZE", "", "addDescriptorDataProperty", "", "builder", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "schema", "Lcom/squareup/wire/schema/Schema;", "addDescriptorForFunction", "addDescriptorMapProperty", "encoded", "", "", "addFileDescriptorFunction", "encodeFileAndDependencies", "wire-grpc-server-generator"})
public final class FileDescriptorGenerator {
    @NotNull
    public static final FileDescriptorGenerator INSTANCE = new FileDescriptorGenerator();
    private static final int FDS_CHUNK_SIZE = 80;

    private FileDescriptorGenerator() {
    }

    public final void addDescriptorDataProperty(@NotNull TypeSpec.Builder builder, @Nullable ProtoFile protoFile, @NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.addDescriptorForFunction(builder);
        this.addFileDescriptorFunction(builder);
        if (protoFile != null) {
            Map<String, String> encoded = this.encodeFileAndDependencies(protoFile, schema);
            this.addDescriptorMapProperty(builder, encoded);
        }
    }

    private final Map<String, String> encodeFileAndDependencies(ProtoFile protoFile, Schema schema) {
        Map encoded = new LinkedHashMap();
        Set visited = new LinkedHashSet();
        Object[] objectArray = new String[]{protoFile.getLocation().getPath()};
        List todo = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)todo).isEmpty()) {
            String path = (String)CollectionsKt.removeLast((List)todo);
            if (visited.contains(path)) continue;
            visited.add(path);
            ProtoFile file = schema.protoFile(path);
            if (file == null) continue;
            todo.addAll(file.getImports());
            encoded.put(file.getLocation().getPath(), new SchemaEncoder(schema).encode(file).base64());
        }
        return encoded;
    }

    /*
     * WARNING - void declaration
     */
    private final void addDescriptorMapProperty(TypeSpec.Builder builder, Map<String, String> encoded) {
        void $this$fold$iv;
        void initial$iv;
        Object object = new KClass[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(DescriptorProtos.FileDescriptorProto.class)};
        PropertySpec.Builder builder2 = PropertySpec.Companion.builder("descriptorMap", (TypeName)ParameterizedTypeName.Companion.get(Reflection.getOrCreateKotlinClass(Map.class), object), new KModifier[0]);
        object = new KModifier[]{KModifier.PRIVATE};
        PropertySpec.Builder builder3 = builder2.addModifiers((KModifier[])object);
        object = MapsKt.toList(encoded);
        CodeBlock.Builder builder4 = CodeBlock.Companion.builder().addStatement("mapOf(", new Object[0]);
        PropertySpec.Builder builder5 = builder3;
        TypeSpec.Builder builder6 = builder;
        boolean $i$f$fold = false;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $this$withIndent$iv;
            CodeBlock.Builder builder7;
            CodeBlock.Builder builder8;
            void $dstr$name$data;
            Pair pair = (Pair)element$iv;
            void b = accumulator$iv;
            boolean bl = false;
            String name = (String)$dstr$name$data.component1();
            String data = (String)$dstr$name$data.component2();
            void $this$withIndent$iv2 = b;
            boolean $i$f$withIndent = false;
            CodeBlock.Builder $this$addDescriptorMapProperty_u24lambda_u2d3_u24lambda_u2d2 = builder8 = $this$withIndent$iv2.indent();
            boolean bl2 = false;
            CodeBlock.Builder builder9 = $this$addDescriptorMapProperty_u24lambda_u2d3_u24lambda_u2d2.addStatement('\"' + name + "\" to descriptorFor(arrayOf(", new Object[0]);
            boolean $i$f$withIndent2 = false;
            CodeBlock.Builder $this$addDescriptorMapProperty_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = builder7 = $this$withIndent$iv.indent();
            boolean bl3 = false;
            Iterable $this$fold$iv2 = StringsKt.chunked((CharSequence)data, (int)80);
            boolean $i$f$fold2 = false;
            CodeBlock.Builder accumulator$iv2 = $this$addDescriptorMapProperty_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1;
            for (Object element$iv2 : $this$fold$iv2) {
                void c;
                String string = (String)element$iv2;
                CodeBlock.Builder b2 = accumulator$iv2;
                boolean bl4 = false;
                accumulator$iv2 = b2.addStatement('\"' + (String)c + "\",", new Object[0]);
            }
            builder7.unindent().addStatement(")),", new Object[0]);
            accumulator$iv = builder8.unindent();
        }
        void var34_34 = accumulator$iv;
        builder6.addProperty(builder5.initializer(var34_34.addStatement(")", new Object[0]).build()).build());
    }

    private final void addFileDescriptorFunction(TypeSpec.Builder builder) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder2 = FunSpec.Companion.builder("fileDescriptor").addModifiers(kModifierArray).addParameter("path", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]);
        kModifierArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class)};
        builder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)builder2.addParameter("visited", (TypeName)ParameterizedTypeName.Companion.get(Reflection.getOrCreateKotlinClass(Set.class), (KClass[])kModifierArray), new KModifier[0]), (KClass)Reflection.getOrCreateKotlinClass(Descriptors.FileDescriptor.class), null, (int)2, null).addCode("val proto = descriptorMap[path]!!\nval deps = proto.dependencyList.filter { !visited.contains(it) }.map { fileDescriptor(it, visited + path) }\nreturn Descriptors.FileDescriptor.buildFrom(proto, deps.toTypedArray())", new Object[0]).build());
    }

    private final void addDescriptorForFunction(TypeSpec.Builder builder) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder2 = FunSpec.Companion.builder("descriptorFor").addModifiers(kModifierArray);
        kModifierArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class)};
        builder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)builder2.addParameter("data", (TypeName)ParameterizedTypeName.Companion.get(Reflection.getOrCreateKotlinClass(Object[].class), (KClass[])kModifierArray), new KModifier[0]), (KClass)Reflection.getOrCreateKotlinClass(DescriptorProtos.FileDescriptorProto.class), null, (int)2, null).addCode("val str = data.fold(java.lang.StringBuilder()) { b, s -> b.append(s) }.toString()\nval bytes = java.util.Base64.getDecoder().decode(str)\nreturn DescriptorProtos.FileDescriptorProto.parseFrom(bytes)", new Object[0]).build());
    }
}

