/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googleanalytics;

import com.google.analytics.data.v1beta.BetaAnalyticsDataClient;
import com.google.analytics.data.v1beta.BetaAnalyticsDataSettings;
import com.google.analytics.data.v1beta.DateRange;
import com.google.analytics.data.v1beta.Dimension;
import com.google.analytics.data.v1beta.DimensionHeader;
import com.google.analytics.data.v1beta.Metric;
import com.google.analytics.data.v1beta.MetricHeader;
import com.google.analytics.data.v1beta.MetricType;
import com.google.analytics.data.v1beta.RunReportRequest;
import com.google.analytics.data.v1beta.RunReportResponse;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.googleanalytics.BareBonesBrowserLaunch;
import org.apache.hop.pipeline.transforms.googleanalytics.GoogleAnalyticsField;
import org.apache.hop.pipeline.transforms.googleanalytics.GoogleAnalyticsMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GoogleAnalyticsDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = GoogleAnalyticsMeta.class;
    public static final String CONST_GOOGLE_ANALYTICS_DIALOG_QUERY_REFERENCE_LABEL = "GoogleAnalyticsDialog.Query.Reference.Label";
    private GoogleAnalyticsMeta input;
    private TextVar wOauthAccount;
    private Button fileChooser;
    private TextVar keyFilename;
    private TableView wFields;
    private TextVar wQuStartDate;
    private TextVar wQuEndDate;
    private TextVar wQuDimensions;
    private TextVar wQuMetrics;
    private TextVar wQuSort;
    private Group gConnect;
    private TextVar wGaAppName;
    private Text wLimit;
    private TextVar wGaPropertyId;
    private int middle;
    private int margin;
    private ModifyListener lsMod;
    static final String REFERENCE_SORT_URI = "https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/OrderBy";
    static final String REFERENCE_METRICS_URI = "https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#metrics";
    static final String REFERENCE_DIMENSIONS_URI = "https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#dimensions";
    static final String REFERENCE_DIMENSION_AND_METRIC_URI = "https://support.google.com/analytics/answer/9143382?hl=en";
    static final String REFERENCE_METRICAGGS_URI = "https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/MetricAggregation";

    public GoogleAnalyticsDialog(Shell parent, IVariables variables, GoogleAnalyticsMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.setInput(transformMeta);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.getInput());
        this.lsMod = e -> this.getInput().setChanged();
        this.backupChanged = this.getInput().hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wGet, this.wPreview, this.wCancel}, (int)this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.gConnect = new Group((Composite)this.shell, 16);
        this.gConnect.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ConnectGroup.Label", (String[])new String[0]));
        FormLayout gConnectLayout = new FormLayout();
        gConnectLayout.marginWidth = 3;
        gConnectLayout.marginHeight = 3;
        this.gConnect.setLayout((Layout)gConnectLayout);
        PropsUi.setLook((Widget)this.gConnect);
        FormData fdConnect = new FormData();
        fdConnect.left = new FormAttachment(0, 0);
        fdConnect.right = new FormAttachment(100, 0);
        fdConnect.top = new FormAttachment((Control)this.wTransformName, this.margin);
        this.gConnect.setLayoutData((Object)fdConnect);
        Label wlGaAppName = new Label((Composite)this.gConnect, 131072);
        wlGaAppName.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AppName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGaAppName);
        FormData fdlGaAppName = new FormData();
        fdlGaAppName.top = new FormAttachment(0, this.margin);
        fdlGaAppName.left = new FormAttachment(0, 0);
        fdlGaAppName.right = new FormAttachment(this.middle, -this.margin);
        wlGaAppName.setLayoutData((Object)fdlGaAppName);
        this.wGaAppName = new TextVar(this.variables, (Composite)this.gConnect, 18436);
        this.wGaAppName.addModifyListener(this.lsMod);
        this.wGaAppName.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AppName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wGaAppName);
        FormData fdGaAppName = new FormData();
        fdGaAppName.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdGaAppName.left = new FormAttachment(this.middle, 0);
        fdGaAppName.right = new FormAttachment(100, 0);
        this.wGaAppName.setLayoutData((Object)fdGaAppName);
        this.createOauthServiceCredentialsControls();
        Group gQuery = new Group((Composite)this.shell, 16);
        gQuery.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.QueryGroup.Label", (String[])new String[0]));
        FormLayout gQueryLayout = new FormLayout();
        gQueryLayout.marginWidth = 3;
        gQueryLayout.marginHeight = 3;
        gQuery.setLayout((Layout)gQueryLayout);
        PropsUi.setLook((Widget)gQuery);
        Label wlQuStartDate = new Label((Composite)gQuery, 131072);
        wlQuStartDate.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.StartDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlQuStartDate);
        FormData fdlQuStartDate = new FormData();
        fdlQuStartDate.top = new FormAttachment(0, this.margin);
        fdlQuStartDate.left = new FormAttachment(0, 0);
        fdlQuStartDate.right = new FormAttachment(this.middle, -this.margin);
        wlQuStartDate.setLayoutData((Object)fdlQuStartDate);
        this.wQuStartDate = new TextVar(this.variables, (Composite)gQuery, 18436);
        this.wQuStartDate.addModifyListener(this.lsMod);
        this.wQuStartDate.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.StartDate.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wQuStartDate);
        FormData fdQuStartDate = new FormData();
        fdQuStartDate.top = new FormAttachment(0, this.margin);
        fdQuStartDate.left = new FormAttachment(this.middle, 0);
        fdQuStartDate.right = new FormAttachment(100, 0);
        this.wQuStartDate.setLayoutData((Object)fdQuStartDate);
        Label wlQuEndDate = new Label((Composite)gQuery, 131072);
        wlQuEndDate.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.EndDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlQuEndDate);
        FormData fdlQuEndDate = new FormData();
        fdlQuEndDate.top = new FormAttachment((Control)this.wQuStartDate, this.margin);
        fdlQuEndDate.left = new FormAttachment(0, 0);
        fdlQuEndDate.right = new FormAttachment(this.middle, -this.margin);
        wlQuEndDate.setLayoutData((Object)fdlQuEndDate);
        this.wQuEndDate = new TextVar(this.variables, (Composite)gQuery, 18436);
        this.wQuEndDate.addModifyListener(this.lsMod);
        this.wQuEndDate.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.EndDate.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wQuEndDate);
        FormData fdQuEndDate = new FormData();
        fdQuEndDate.top = new FormAttachment((Control)this.wQuStartDate, this.margin);
        fdQuEndDate.left = new FormAttachment(this.middle, 0);
        fdQuEndDate.right = new FormAttachment(100, 0);
        this.wQuEndDate.setLayoutData((Object)fdQuEndDate);
        Label wlQuDimensions = new Label((Composite)gQuery, 131072);
        wlQuDimensions.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Dimensions.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlQuDimensions);
        FormData fdlQuDimensions = new FormData();
        fdlQuDimensions.top = new FormAttachment((Control)this.wQuEndDate, this.margin);
        fdlQuDimensions.left = new FormAttachment(0, 0);
        fdlQuDimensions.right = new FormAttachment(this.middle, -this.margin);
        wlQuDimensions.setLayoutData((Object)fdlQuDimensions);
        this.wQuDimensions = new TextVar(this.variables, (Composite)gQuery, 18436);
        this.wQuDimensions.addModifyListener(this.lsMod);
        this.wQuDimensions.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Dimensions.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wQuDimensions);
        Link wQuDimensionsReference = new Link((Composite)gQuery, 4);
        wQuDimensionsReference.setText(BaseMessages.getString(PKG, (String)CONST_GOOGLE_ANALYTICS_DIALOG_QUERY_REFERENCE_LABEL, (String[])new String[0]));
        PropsUi.setLook((Widget)wQuDimensionsReference);
        wQuDimensionsReference.addListener(13, ev -> BareBonesBrowserLaunch.openURL(REFERENCE_DIMENSIONS_URI));
        wQuDimensionsReference.pack(true);
        FormData fdQuDimensions = new FormData();
        fdQuDimensions.top = new FormAttachment((Control)this.wQuEndDate, this.margin);
        fdQuDimensions.left = new FormAttachment(this.middle, 0);
        fdQuDimensions.right = new FormAttachment(100, -wQuDimensionsReference.getBounds().width - this.margin);
        this.wQuDimensions.setLayoutData((Object)fdQuDimensions);
        FormData fdQuDimensionsReference = new FormData();
        fdQuDimensionsReference.top = new FormAttachment((Control)this.wQuEndDate, this.margin);
        fdQuDimensionsReference.left = new FormAttachment((Control)this.wQuDimensions, 0);
        fdQuDimensionsReference.right = new FormAttachment(100, 0);
        wQuDimensionsReference.setLayoutData((Object)fdQuDimensionsReference);
        Label wlQuMetrics = new Label((Composite)gQuery, 131072);
        wlQuMetrics.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Metrics.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlQuMetrics);
        FormData fdlQuMetrics = new FormData();
        fdlQuMetrics.top = new FormAttachment((Control)this.wQuDimensions, this.margin);
        fdlQuMetrics.left = new FormAttachment(0, 0);
        fdlQuMetrics.right = new FormAttachment(this.middle, -this.margin);
        wlQuMetrics.setLayoutData((Object)fdlQuMetrics);
        this.wQuMetrics = new TextVar(this.variables, (Composite)gQuery, 18436);
        this.wQuMetrics.addModifyListener(this.lsMod);
        this.wQuMetrics.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Metrics.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wQuMetrics);
        Link wQuMetricsReference = new Link((Composite)gQuery, 4);
        wQuMetricsReference.setText(BaseMessages.getString(PKG, (String)CONST_GOOGLE_ANALYTICS_DIALOG_QUERY_REFERENCE_LABEL, (String[])new String[0]));
        PropsUi.setLook((Widget)wQuMetricsReference);
        wQuMetricsReference.addListener(13, ev -> BareBonesBrowserLaunch.openURL(REFERENCE_METRICS_URI));
        wQuMetricsReference.pack(true);
        FormData fdQuMetrics = new FormData();
        fdQuMetrics.top = new FormAttachment((Control)this.wQuDimensions, this.margin);
        fdQuMetrics.left = new FormAttachment(this.middle, 0);
        fdQuMetrics.right = new FormAttachment(100, -wQuMetricsReference.getBounds().width - this.margin);
        this.wQuMetrics.setLayoutData((Object)fdQuMetrics);
        FormData fdQuMetricsReference = new FormData();
        fdQuMetricsReference.top = new FormAttachment((Control)this.wQuDimensions, this.margin);
        fdQuMetricsReference.left = new FormAttachment((Control)this.wQuMetrics, 0);
        fdQuMetricsReference.right = new FormAttachment(100, 0);
        wQuMetricsReference.setLayoutData((Object)fdQuMetricsReference);
        Label wlQuSort = new Label((Composite)gQuery, 131072);
        wlQuSort.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Sort.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlQuSort);
        FormData fdlQuSort = new FormData();
        fdlQuSort.top = new FormAttachment((Control)this.wQuMetrics, this.margin);
        fdlQuSort.left = new FormAttachment(0, 0);
        fdlQuSort.right = new FormAttachment(this.middle, -this.margin);
        wlQuSort.setLayoutData((Object)fdlQuSort);
        this.wQuSort = new TextVar(this.variables, (Composite)gQuery, 18436);
        this.wQuSort.addModifyListener(this.lsMod);
        this.wQuSort.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Query.Sort.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wQuSort);
        Link wQuSortReference = new Link((Composite)gQuery, 4);
        wQuSortReference.setText(BaseMessages.getString(PKG, (String)CONST_GOOGLE_ANALYTICS_DIALOG_QUERY_REFERENCE_LABEL, (String[])new String[0]));
        PropsUi.setLook((Widget)wQuSortReference);
        wQuSortReference.addListener(13, ev -> BareBonesBrowserLaunch.openURL(REFERENCE_SORT_URI));
        wQuSortReference.pack(true);
        FormData fdQuSort = new FormData();
        fdQuSort.top = new FormAttachment((Control)this.wQuMetrics, this.margin);
        fdQuSort.left = new FormAttachment(this.middle, 0);
        fdQuSort.right = new FormAttachment(100, -wQuSortReference.getBounds().width - this.margin);
        this.wQuSort.setLayoutData((Object)fdQuSort);
        FormData fdQuSortReference = new FormData();
        fdQuSortReference.top = new FormAttachment((Control)this.wQuMetrics, this.margin);
        fdQuSortReference.left = new FormAttachment((Control)this.wQuSort, 0);
        fdQuSortReference.right = new FormAttachment(100, 0);
        wQuSortReference.setLayoutData((Object)fdQuSortReference);
        FormData fdQueryGroup = new FormData();
        fdQueryGroup.left = new FormAttachment(0, 0);
        fdQueryGroup.right = new FormAttachment(100, 0);
        fdQueryGroup.top = new FormAttachment((Control)this.gConnect, this.margin);
        gQuery.setLayoutData((Object)fdQueryGroup);
        gQuery.setTabList(new Control[]{this.wQuStartDate, this.wQuEndDate, this.wQuDimensions, this.wQuMetrics, this.wQuSort});
        Label wlLimit = new Label((Composite)this.shell, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.LimitSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        fdlLimit.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        this.wLimit.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.LimitSize.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(this.lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        fdLimit.top = new FormAttachment((Control)wlLimit, 0, 0x1000000);
        this.wLimit.setLayoutData((Object)fdLimit);
        Link wlFields = new Link((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.Return.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        wlFields.addListener(13, ev -> BareBonesBrowserLaunch.openURL(REFERENCE_DIMENSION_AND_METRIC_URI));
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)gQuery, this.margin);
        wlFields.setLayoutData((Object)fdlReturn);
        int fieldWidgetCols = 5;
        int fieldWidgetRows = this.getInput().getGoogleAnalyticsFields() != null ? this.getInput().getGoogleAnalyticsFields().size() : 1;
        ColumnInfo[] ciKeys = new ColumnInfo[fieldWidgetCols];
        ciKeys[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.FeedFieldType", (String[])new String[0]), 2, new String[]{"Dimension", "Metric", "Data Source Property", "Data Source Field"}, true);
        ciKeys[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.FeedField", (String[])new String[0]), 1, false, false);
        ciKeys[1].setUsingVariables(true);
        ciKeys[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.RenameTo", (String[])new String[0]), 1, false, false);
        ciKeys[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaBase.getTypes());
        ciKeys[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.ColumnInfo.Format", (String[])new String[0]), 5, 4);
        this.setTableView(new TableView(this.variables, (Composite)this.shell, 68354, ciKeys, fieldWidgetRows, this.lsMod, this.props));
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlFields, this.margin);
        fdReturn.right = new FormAttachment(100, 0);
        fdReturn.bottom = new FormAttachment((Control)this.wLimit, -this.margin);
        this.getTableView().setLayoutData((Object)fdReturn);
        this.fileChooser.addListener(13, this::browseKeyFile);
        this.getData();
        this.getInput().setChanged(this.backupChanged);
        this.wTransformName.setFocus();
        this.shell.setTabList(new Control[]{this.wTransformName, this.gConnect, gQuery, this.getTableView()});
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void browseKeyFile(Event e) {
        BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.keyFilename, (IVariables)this.variables, (String[])new String[]{"*.properties", "*.*"}, (String[])new String[]{"Properties files (*.properties)", "All Files (*.*)"}, (boolean)true);
    }

    private RunReportResponse getReportResponse() {
        BetaAnalyticsDataClient analyticsData = null;
        try {
            FileInputStream inputStream = new FileInputStream(this.keyFilename.getText());
            ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
            String[] settings = ((BetaAnalyticsDataSettings.Builder)BetaAnalyticsDataSettings.newHttpJsonBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
            analyticsData = BetaAnalyticsDataClient.create((BetaAnalyticsDataSettings)settings);
        }
        catch (IOException e) {
            new ErrorDialog(this.shell, "Error creating connection", "Error reading key file or creating Google Analytics connection", (Exception)e);
        }
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        String dimensionString = this.wQuDimensions.getText();
        for (String dimension : dimensionString.split(",")) {
            dimensionList.add(Dimension.newBuilder().setName(dimension).build());
        }
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        String metricsString = this.wQuMetrics.getText();
        for (String metric : metricsString.split(",")) {
            metricList.add(Metric.newBuilder().setName(metric).build());
        }
        RunReportRequest request = RunReportRequest.newBuilder().setProperty("properties/" + this.wGaPropertyId.getText()).addAllDimensions(dimensionList).addAllMetrics(metricList).addDateRanges(DateRange.newBuilder().setStartDate(this.wQuStartDate.getText()).setEndDate(this.wQuEndDate.getText())).build();
        return analyticsData.runReport(request);
    }

    void getFields() {
        this.getTableView().removeAll();
        RunReportResponse response = this.getReportResponse();
        List dimensionHeaders = response.getDimensionHeadersList();
        List metricHeaders = response.getMetricHeadersList();
        if (response == null || dimensionHeaders.isEmpty() || metricHeaders.isEmpty()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText("Query yields empty feed");
            mb.setMessage("The feed did not give any results. Please specify a query that returns data.");
            mb.open();
            return;
        }
        int i = 0;
        this.getTableView().table.setItemCount(dimensionHeaders.size() + metricHeaders.size());
        for (DimensionHeader colHeader : dimensionHeaders) {
            String name = colHeader.getName();
            TableItem item = this.getTableView().table.getItem(i);
            item.setText(1, "Dimension");
            item.setText(2, name);
            item.setText(3, name);
            item.setText(4, ValueMetaBase.getTypeDesc((int)2));
            item.setText(5, "");
            ++i;
        }
        for (MetricHeader metricHeader : metricHeaders) {
            TableItem item = this.getTableView().table.getItem(i);
            String name = metricHeader.getName();
            item.setText(1, "Metric");
            item.setText(2, name);
            item.setText(3, name);
            MetricType metricType = metricHeader.getType();
            if (metricType.equals((Object)MetricType.TYPE_INTEGER)) {
                item.setText(4, ValueMetaBase.getTypeDesc((int)5));
                item.setText(5, "#;-#");
            } else if (metricType.equals((Object)MetricType.TYPE_FLOAT) || metricType.equals((Object)MetricType.TYPE_SECONDS) || metricType.equals((Object)MetricType.TYPE_MILLISECONDS) || metricType.equals((Object)MetricType.TYPE_MINUTES) || metricType.equals((Object)MetricType.TYPE_HOURS) || metricType.equals((Object)MetricType.TYPE_STANDARD) || metricType.equals((Object)MetricType.TYPE_CURRENCY) || metricType.equals((Object)MetricType.TYPE_FEET) || metricType.equals((Object)MetricType.TYPE_MILES) || metricType.equals((Object)MetricType.TYPE_METERS) || metricType.equals((Object)MetricType.TYPE_KILOMETERS)) {
                item.setText(4, ValueMetaBase.getTypeDesc((int)1));
                item.setText(5, "#.#;-#.#");
            } else {
                item.setText(4, ValueMetaBase.getTypeDesc((int)2));
                item.setText(5, "");
            }
            ++i;
        }
        this.getTableView().removeEmptyRows();
        this.getTableView().setRowNums();
        this.getTableView().optWidth(true);
        this.getInput().setChanged();
    }

    private void getInfo(GoogleAnalyticsMeta meta) {
        this.transformName = this.wTransformName.getText();
        meta.setGaAppName(this.wGaAppName.getText());
        meta.setOAuthServiceAccount(this.wOauthAccount.getText());
        meta.setOAuthKeyFile(this.keyFilename.getText());
        meta.setGaProperty(this.wGaPropertyId.getText());
        meta.setStartDate(this.wQuStartDate.getText());
        meta.setEndDate(this.wQuEndDate.getText());
        meta.setDimensions(this.wQuDimensions.getText());
        meta.setMetrics(this.wQuMetrics.getText());
        meta.setSort(this.wQuSort.getText());
        int nrFields = this.getTableView().nrNonEmpty();
        ArrayList<GoogleAnalyticsField> googleAnalyticsFields = new ArrayList<GoogleAnalyticsField>();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.getTableView().getNonEmpty(i);
            GoogleAnalyticsField field = new GoogleAnalyticsField();
            field.setFeedFieldType(item.getText(1));
            field.setFeedField(item.getText(2));
            field.setOutputFieldName(item.getText(3));
            field.setType(item.getText(4));
            field.setInputFormat(item.getText(5));
            googleAnalyticsFields.add(field);
        }
        meta.setGoogleAnalyticsFields(googleAnalyticsFields);
        meta.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
    }

    private void preview() {
        GoogleAnalyticsMeta oneMeta = new GoogleAnalyticsMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    public void getData() {
        if (this.getInput().getGaAppName() != null) {
            this.wGaAppName.setText(this.getInput().getGaAppName());
        }
        this.wOauthAccount.setText(Const.NVL((String)this.getInput().getOAuthServiceAccount(), (String)""));
        this.keyFilename.setText(Const.NVL((String)this.getInput().getOAuthKeyFile(), (String)""));
        this.wGaPropertyId.setText(Const.NVL((String)this.getInput().getGaProperty(), (String)""));
        if (this.getInput().getStartDate() != null) {
            this.wQuStartDate.setText(this.getInput().getStartDate());
        }
        if (this.getInput().getEndDate() != null) {
            this.wQuEndDate.setText(this.getInput().getEndDate());
        }
        if (this.getInput().getDimensions() != null) {
            this.wQuDimensions.setText(this.getInput().getDimensions());
        }
        if (this.getInput().getMetrics() != null) {
            this.wQuMetrics.setText(this.getInput().getMetrics());
        }
        if (this.getInput().getSort() != null) {
            this.wQuSort.setText(this.getInput().getSort());
        }
        this.wFields.removeAll();
        this.wFields.removeEmptyRows();
        if (!this.input.getGoogleAnalyticsFields().isEmpty()) {
            this.wFields.table.setItemCount(this.input.getGoogleAnalyticsFields().size());
            List<GoogleAnalyticsField> googleAnalyticsFields = this.input.getGoogleAnalyticsFields();
            int i = 0;
            for (GoogleAnalyticsField field : googleAnalyticsFields) {
                TableItem item = this.wFields.table.getItem(i);
                if (!Utils.isEmpty((CharSequence)field.getType())) {
                    item.setText(1, field.getFeedFieldType());
                }
                if (!Utils.isEmpty((CharSequence)field.getFeedField())) {
                    item.setText(2, field.getFeedField());
                }
                if (!Utils.isEmpty((CharSequence)field.getOutputFieldName())) {
                    item.setText(3, field.getOutputFieldName());
                }
                if (!Utils.isEmpty((CharSequence)field.getType())) {
                    item.setText(4, field.getType());
                }
                if (!Utils.isEmpty((CharSequence)field.getInputFormat())) {
                    item.setText(5, field.getType());
                }
                ++i;
            }
        }
        this.wFields.removeEmptyRows();
        this.getTableView().setRowNums();
        this.getTableView().optWidth(true);
        this.wLimit.setText("" + this.getInput().getRowLimit());
        this.setActive();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.getInput().setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        this.getInfo(this.getInput());
        this.dispose();
    }

    private void createOauthServiceCredentialsControls() {
        Label wlOauthAccount = new Label((Composite)this.gConnect, 131072);
        wlOauthAccount.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.OauthAccount.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOauthAccount);
        FormData fdlOathAccount = new FormData();
        fdlOathAccount.left = new FormAttachment(0, 0);
        fdlOathAccount.top = new FormAttachment((Control)this.wGaAppName, this.margin);
        fdlOathAccount.right = new FormAttachment(this.middle, -this.margin);
        wlOauthAccount.setLayoutData((Object)fdlOathAccount);
        this.wOauthAccount = new TextVar(this.variables, (Composite)this.gConnect, 18436);
        this.wOauthAccount.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.OauthAccount.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOauthAccount);
        this.wOauthAccount.addModifyListener(this.lsMod);
        FormData fdOathAccount = new FormData();
        fdOathAccount.left = new FormAttachment(this.middle, 0);
        fdOathAccount.top = new FormAttachment((Control)this.wGaAppName, this.margin);
        fdOathAccount.right = new FormAttachment(100, -this.margin);
        this.wOauthAccount.setLayoutData((Object)fdOathAccount);
        this.fileChooser = new Button((Composite)this.gConnect, 0x1000008);
        this.fileChooser.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        PropsUi.setLook((Widget)this.fileChooser);
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wOauthAccount, this.margin);
        this.fileChooser.setLayoutData((Object)fdbFilename);
        Label wlFilename = new Label((Composite)this.gConnect, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.KeyFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.top = new FormAttachment((Control)this.wOauthAccount, this.margin);
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.keyFilename = new TextVar(this.variables, (Composite)this.gConnect, 18436);
        this.keyFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.KeyFilename.Tooltip", (String[])new String[0]));
        this.keyFilename.addModifyListener(this.lsMod);
        PropsUi.setLook((Widget)this.keyFilename);
        FormData fdFilename = new FormData();
        fdFilename.top = new FormAttachment((Control)this.wOauthAccount, this.margin);
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment((Control)this.fileChooser, -this.margin);
        this.keyFilename.setLayoutData((Object)fdFilename);
        Label wlGaPropertyId = new Label((Composite)this.gConnect, 131072);
        wlGaPropertyId.setText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.PropertyId.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGaPropertyId);
        FormData fdlGaPropertyId = new FormData();
        fdlGaPropertyId.top = new FormAttachment((Control)this.keyFilename, this.margin);
        fdlGaPropertyId.left = new FormAttachment(0, 0);
        fdlGaPropertyId.right = new FormAttachment(this.middle, -this.margin);
        wlGaPropertyId.setLayoutData((Object)fdlGaPropertyId);
        this.wGaPropertyId = new TextVar(this.variables, (Composite)this.gConnect, 18436);
        this.wGaPropertyId.setToolTipText(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.PropertyId.Tooltip", (String[])new String[0]));
        this.wGaPropertyId.addModifyListener(this.lsMod);
        PropsUi.setLook((Widget)this.wGaPropertyId);
        FormData fdGaPropertyId = new FormData();
        fdGaPropertyId.top = new FormAttachment((Control)this.keyFilename, this.margin);
        fdGaPropertyId.left = new FormAttachment(this.middle, 0);
        fdGaPropertyId.right = new FormAttachment(100, -this.margin);
        this.wGaPropertyId.setLayoutData((Object)fdGaPropertyId);
    }

    TableView getTableView() {
        return this.wFields;
    }

    void setTableView(TableView wFields) {
        this.wFields = wFields;
    }

    GoogleAnalyticsMeta getInput() {
        return this.input;
    }

    void setInput(GoogleAnalyticsMeta input) {
        this.input = input;
    }
}

