/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.as400command;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.as400command.ActionAs400Command;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionAs400CommandDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionAs400CommandDialog.class;
    private ActionAs400Command action;
    private boolean changed;
    private Text wName;
    private LabelTextVar wServerName;
    private LabelTextVar wUserName;
    private LabelTextVar wPassword;
    private LabelTextVar wProxyHost;
    private LabelTextVar wProxyPort;
    private LabelTextVar wCommand;

    public ActionAs400CommandDialog(Shell parent, ActionAs400Command action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        this.shell.setMinimumSize(new Point(600, 400));
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.shell.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wicon);
        Label wlName = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.top = new FormAttachment((Control)wicon, 0, 0x1000000);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.right = new FormAttachment((Control)wicon, -margin);
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment((Control)wlName, margin);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)wicon, 0);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Group systemGroup = new Group((Composite)this.shell, 32);
        systemGroup.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.System.Group.Label", (String[])new String[0]));
        FormLayout systemGroupLayout = new FormLayout();
        systemGroupLayout.marginWidth = PropsUi.getFormMargin();
        systemGroupLayout.marginHeight = PropsUi.getFormMargin();
        systemGroup.setLayout((Layout)systemGroupLayout);
        systemGroup.setLayoutData((Object)new FormDataBuilder().top((Control)spacer, PropsUi.getFormMargin()).fullWidth().result());
        PropsUi.setLook((Widget)systemGroup);
        this.wServerName = new LabelTextVar(this.variables, (Composite)systemGroup, BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Server.Tooltip", (String[])new String[0]));
        this.wServerName.addModifyListener(lsMod);
        this.wServerName.setLayoutData((Object)new FormDataBuilder().top().fullWidth().result());
        PropsUi.setLook((Widget)this.wServerName);
        this.wUserName = new LabelTextVar(this.variables, (Composite)systemGroup, BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.User.Tooltip", (String[])new String[0]));
        this.wUserName.setLayoutData((Object)new FormDataBuilder().top((Control)this.wServerName).fullWidth().result());
        this.wUserName.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wUserName);
        this.wPassword = new LabelTextVar(this.variables, (Composite)systemGroup, BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Password.Tooltip", (String[])new String[0]));
        this.wPassword.setEchoChar('*');
        this.wPassword.setLayoutData((Object)new FormDataBuilder().top((Control)this.wUserName).fullWidth().result());
        this.wPassword.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wPassword);
        Group proxyGroup = new Group((Composite)this.shell, 32);
        proxyGroup.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Proxy.Group.Label", (String[])new String[0]));
        FormLayout proxyGroupLayout = new FormLayout();
        proxyGroupLayout.marginWidth = PropsUi.getFormMargin();
        proxyGroupLayout.marginHeight = PropsUi.getFormMargin();
        proxyGroup.setLayout((Layout)proxyGroupLayout);
        proxyGroup.setLayoutData((Object)new FormDataBuilder().top((Control)systemGroup, PropsUi.getFormMargin()).fullWidth().result());
        PropsUi.setLook((Widget)proxyGroup);
        this.wProxyHost = new LabelTextVar(this.variables, (Composite)proxyGroup, BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.ProxyHost.Tooltip", (String[])new String[0]));
        this.wProxyHost.addModifyListener(lsMod);
        this.wProxyHost.setLayoutData((Object)new FormDataBuilder().top().fullWidth().result());
        PropsUi.setLook((Widget)this.wProxyHost);
        this.wProxyPort = new LabelTextVar(this.variables, (Composite)proxyGroup, BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.ProxyPort.Tooltip", (String[])new String[0]));
        this.wProxyPort.setLayoutData((Object)new FormDataBuilder().top((Control)this.wProxyHost).fullWidth().result());
        this.wProxyPort.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wProxyPort);
        Group commandGroup = new Group((Composite)this.shell, 32);
        commandGroup.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Command.Group.Label", (String[])new String[0]));
        FormLayout commandGroupLayout = new FormLayout();
        commandGroupLayout.marginWidth = PropsUi.getFormMargin();
        commandGroupLayout.marginHeight = PropsUi.getFormMargin();
        commandGroup.setLayout((Layout)commandGroupLayout);
        commandGroup.setLayoutData((Object)new FormDataBuilder().top((Control)proxyGroup, PropsUi.getFormMargin()).fullWidth().result());
        PropsUi.setLook((Widget)commandGroup);
        this.wCommand = new LabelTextVar(this.variables, (Composite)commandGroup, BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Command.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.Command.Tooltip", (String[])new String[0]));
        this.wCommand.setLayoutData((Object)new FormDataBuilder().fullWidth().result());
        this.wCommand.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wCommand);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        Button wTest = new Button((Composite)this.shell, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.TestConnection.Label", (String[])new String[0]));
        wTest.addListener(13, e -> this.onTest());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wTest, wOk, wCancel}, (int)PropsUi.getMargin(), null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        this.wServerName.setText(Const.NVL((String)this.action.getServer(), (String)""));
        this.wUserName.setText(Const.NVL((String)this.action.getUser(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wCommand.setText(Const.NVL((String)this.action.getCommand(), (String)""));
        this.wProxyHost.setText(Const.NVL((String)this.action.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.action.getProxyPort(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setServer(this.wServerName.getText());
        this.action.setUser(this.wUserName.getText());
        this.action.setPassword(this.wPassword.getText());
        this.action.setCommand(this.wCommand.getText());
        this.action.setProxyHost(this.wProxyHost.getText());
        this.action.setProxyPort(this.wProxyPort.getText());
        this.dispose();
    }

    protected void onTest() {
        String server = this.wServerName.getText();
        String user = this.wUserName.getText();
        String password = this.wPassword.getText();
        String proxyHost = this.wProxyHost.getText();
        String proxyPort = this.wProxyPort.getText();
        try {
            this.action.test(this.variables, server, user, password, proxyHost, proxyPort);
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.TestConnection.Shell.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.TestConnection.Success", (String[])new String[]{server}));
            mb.open();
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.TestConnection.Shell.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionAs400CommandDialog.TestConnection.Failed", (String[])new String[]{server, e.getMessage()}));
            mb.open();
        }
    }
}

