/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.svg;

import java.io.InputStream;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.hop.core.svg.SvgImage;
import org.w3c.dom.Document;

public class SvgSupport {
    private static final String SVG_EXTENSION = ".svg";
    private static final String PNG_EXTENSION = ".png";
    private static final String PARSER = XMLResourceDescriptor.getXMLParserClassName();
    private static final ThreadLocal<SAXSVGDocumentFactory> SVG_FACTORY_THREAD_LOCAL = new ThreadLocal();

    private static SAXSVGDocumentFactory createFactory() {
        return new SAXSVGDocumentFactory(PARSER);
    }

    private static SAXSVGDocumentFactory getSvgFactory() {
        SAXSVGDocumentFactory factory = SVG_FACTORY_THREAD_LOCAL.get();
        if (factory == null) {
            factory = SvgSupport.createFactory();
            SVG_FACTORY_THREAD_LOCAL.set(factory);
        }
        return factory;
    }

    public static boolean isSvgEnabled() {
        return true;
    }

    public static SvgImage loadSvgImage(InputStream in) throws Exception {
        Document document = SvgSupport.getSvgFactory().createDocument(null, in);
        return new SvgImage(document);
    }

    public static boolean isSvgName(String name) {
        return name.toLowerCase().endsWith(SVG_EXTENSION);
    }

    public static String toPngName(String name) {
        if (SvgSupport.isSvgName((String)name)) {
            name = ((String)name).substring(0, ((String)name).length() - 4) + PNG_EXTENSION;
        }
        return name;
    }

    public static boolean isPngName(String name) {
        return name.toLowerCase().endsWith(PNG_EXTENSION);
    }

    public static String toSvgName(String name) {
        if (SvgSupport.isPngName((String)name)) {
            name = ((String)name).substring(0, ((String)name).length() - 4) + SVG_EXTENSION;
        }
        return name;
    }
}

