/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeinput;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInputData;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInputMeta;

public class CubeInput
extends BaseTransform<CubeInputMeta, CubeInputData> {
    private static final Class<?> PKG = CubeInputMeta.class;
    private int realRowLimit;

    public CubeInput(TransformMeta transformMeta, CubeInputMeta meta, CubeInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            this.realRowLimit = Const.toInt((String)this.resolve(((CubeInputMeta)this.meta).getRowLimit()), (int)0);
        }
        try {
            Object[] r = ((CubeInputData)this.data).meta.readData(((CubeInputData)this.data).dis);
            this.putRow(((CubeInputData)this.data).meta, r);
            this.incrementLinesInput();
            if (this.realRowLimit > 0 && this.getLinesInput() >= (long)this.realRowLimit) {
                this.setOutputDone();
                return false;
            }
        }
        catch (HopEofException eof) {
            this.setOutputDone();
            return false;
        }
        catch (SocketTimeoutException e) {
            throw new HopException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"CubeInput.Log.LineNumber", (String[])new String[0]) + this.getLinesInput());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            try {
                String filename = this.resolve(((CubeInputMeta)this.meta).getFile().getName());
                if (((CubeInputMeta)this.meta).isAddFilenameResult()) {
                    ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filename, (IVariables)this.variables), this.getPipelineMeta().getName(), this.toString());
                    resultFile.setComment("File was read by a Cube Input transform");
                    this.addResultFile(resultFile);
                }
                ((CubeInputData)this.data).fis = HopVfs.getInputStream((String)filename, (IVariables)this.variables);
                ((CubeInputData)this.data).zip = new GZIPInputStream(((CubeInputData)this.data).fis);
                ((CubeInputData)this.data).dis = new DataInputStream(((CubeInputData)this.data).zip);
                try {
                    ((CubeInputData)this.data).meta = new RowMeta(((CubeInputData)this.data).dis);
                    return true;
                }
                catch (HopFileException kfe) {
                    this.logError(BaseMessages.getString(PKG, (String)"CubeInput.Log.UnableToReadMetadata", (String[])new String[0]), kfe);
                    return false;
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"CubeInput.Log.ErrorReadingFromDataCube", (String[])new String[0]), e);
            }
        }
        return false;
    }

    public void dispose() {
        try {
            if (((CubeInputData)this.data).dis != null) {
                ((CubeInputData)this.data).dis.close();
                ((CubeInputData)this.data).dis = null;
            }
            if (((CubeInputData)this.data).zip != null) {
                ((CubeInputData)this.data).zip.close();
                ((CubeInputData)this.data).zip = null;
            }
            if (((CubeInputData)this.data).fis != null) {
                ((CubeInputData)this.data).fis.close();
                ((CubeInputData)this.data).fis = null;
            }
        }
        catch (IOException e) {
            this.logError(BaseMessages.getString(PKG, (String)"CubeInput.Log.ErrorClosingCube", (String[])new String[0]) + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        super.dispose();
    }
}

