/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.combinationlookup;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopConfigException;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.combinationlookup.CFields;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookupData;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookupMeta;
import org.apache.hop.pipeline.transforms.combinationlookup.KeyField;
import org.apache.hop.pipeline.transforms.combinationlookup.ReturnFields;

public class CombinationLookup
extends BaseTransform<CombinationLookupMeta, CombinationLookupData> {
    private static final Class<?> PKG = CombinationLookupMeta.class;
    private static final int CREATION_METHOD_AUTOINC = 1;
    private static final int CREATION_METHOD_SEQUENCE = 2;
    private static final int CREATION_METHOD_TABLEMAX = 3;
    public static final String CONST_UNABLE_TO_RETRIEVE_AUTO_INCREMENT_OF_COMBI_INSERT_KEY = "Unable to retrieve auto-increment of combi insert key : ";
    public static final String CONST_COMBINATION_LOOKUP_LOG_UNEXPECTED_ERROR = "CombinationLookup.Log.UnexpectedError";
    private int techKeyCreation;

    public CombinationLookup(TransformMeta transformMeta, CombinationLookupMeta meta, CombinationLookupData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void setTechKeyCreation(int method) {
        this.techKeyCreation = method;
    }

    private int getTechKeyCreation() {
        return this.techKeyCreation;
    }

    private void determineTechKeyCreation() {
        String keyCreation = ((CombinationLookupMeta)this.meta).getFields().getReturnFields().getTechKeyCreation();
        if (((CombinationLookupMeta)this.meta).getDatabaseMeta().supportsAutoinc() && "autoinc".equals(keyCreation)) {
            this.setTechKeyCreation(1);
        } else if (((CombinationLookupMeta)this.meta).getDatabaseMeta().supportsSequences() && "sequence".equals(keyCreation)) {
            this.setTechKeyCreation(2);
        } else {
            this.setTechKeyCreation(3);
        }
    }

    private Long lookupInCache(IRowMeta rowMeta, Object[] row) {
        if (((CombinationLookupMeta)this.meta).getCacheSize() == -1) {
            return null;
        }
        return ((CombinationLookupData)this.data).cache.get(new RowMetaAndData(rowMeta, row));
    }

    private void addToCache(IRowMeta rowMeta, Object[] row, Long tk) throws HopValueException {
        if (((CombinationLookupMeta)this.meta).getCacheSize() == -1) {
            return;
        }
        ((CombinationLookupData)this.data).cache.put(new RowMetaAndData(rowMeta, row), tk);
        int tenPercent = ((CombinationLookupMeta)this.meta).getCacheSize() / 10;
        if (((CombinationLookupMeta)this.meta).getCacheSize() > 0 && ((CombinationLookupData)this.data).cache.size() > ((CombinationLookupMeta)this.meta).getCacheSize() + tenPercent) {
            Long value;
            RowMetaAndData key;
            int i;
            ArrayList<RowMetaAndData> keys = new ArrayList<RowMetaAndData>(((CombinationLookupData)this.data).cache.keySet());
            int sizeBefore = keys.size();
            ArrayList<Long> samples = new ArrayList<Long>();
            int transformsize = keys.size() / 5;
            if (transformsize < 1) {
                transformsize = 1;
            }
            for (i = 0; i < keys.size(); i += transformsize) {
                key = (RowMetaAndData)keys.get(i);
                value = ((CombinationLookupData)this.data).cache.get(key);
                if (value == null) continue;
                samples.add(value);
            }
            Collections.sort(samples);
            ((CombinationLookupData)this.data).smallestCacheKey = samples.size() > 1 ? ((Long)samples.get(1)).longValue() : ((Long)samples.get(0)).longValue();
            for (i = 0; i < keys.size(); ++i) {
                key = (RowMetaAndData)keys.get(i);
                value = ((CombinationLookupData)this.data).cache.get(key);
                if (value == null || value > ((CombinationLookupData)this.data).smallestCacheKey) continue;
                ((CombinationLookupData)this.data).cache.remove(key);
            }
            int sizeAfter = ((CombinationLookupData)this.data).cache.size();
            this.logDetailed("Reduced the lookup cache from " + sizeBefore + " to " + sizeAfter + " rows.");
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Cache store: key=" + rowMeta.getString(row) + "    key=" + tk);
        }
    }

    protected boolean isAutoIncrement() {
        return this.techKeyCreation == 1;
    }

    private Object[] lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        int i;
        Long valKey = null;
        Long valHash = null;
        Object[] hashRow = null;
        CFields fields = ((CombinationLookupMeta)this.meta).getFields();
        List<KeyField> keyFields = fields.getKeyFields();
        ReturnFields returnFields = fields.getReturnFields();
        Object[] lookupRow = new Object[((CombinationLookupData)this.data).lookupRowMeta.size()];
        int lookupIndex = 0;
        if (((CombinationLookupMeta)this.meta).isUseHash() || ((CombinationLookupMeta)this.meta).getCacheSize() >= 0) {
            hashRow = new Object[((CombinationLookupData)this.data).hashRowMeta.size()];
            for (i = 0; i < keyFields.size(); ++i) {
                hashRow[i] = row[((CombinationLookupData)this.data).keynrs[i]];
            }
            if (((CombinationLookupMeta)this.meta).isUseHash()) {
                valHash = ((CombinationLookupData)this.data).hashRowMeta.hashCode(hashRow);
                lookupRow[lookupIndex] = valHash;
                ++lookupIndex;
            }
        }
        for (i = 0; i < keyFields.size(); ++i) {
            int rowIndex = ((CombinationLookupData)this.data).keynrs[i];
            lookupRow[lookupIndex] = row[rowIndex];
            lookupRow[++lookupIndex] = ((CombinationLookupMeta)this.meta).getDatabaseMeta().requiresCastToVariousForIsNull() && rowMeta.getValueMeta(rowIndex).getType() == 2 ? (rowMeta.getValueMeta(rowIndex).isNull(row[rowIndex]) ? null : "NotNull") : row[((CombinationLookupData)this.data).keynrs[i]];
            ++lookupIndex;
        }
        valKey = this.lookupInCache(((CombinationLookupData)this.data).hashRowMeta, hashRow);
        if (valKey == null) {
            ((CombinationLookupData)this.data).db.setValues(((CombinationLookupData)this.data).lookupRowMeta, lookupRow, ((CombinationLookupData)this.data).prepStatementLookup);
            Object[] add = ((CombinationLookupData)this.data).db.getLookup(((CombinationLookupData)this.data).prepStatementLookup);
            this.incrementLinesInput();
            if (add == null) {
                switch (this.getTechKeyCreation()) {
                    case 3: {
                        valKey = ((CombinationLookupData)this.data).db.getNextValue(((CombinationLookupData)this.data).realSchemaName, ((CombinationLookupData)this.data).realTableName, returnFields.getTechnicalKeyField());
                        break;
                    }
                    case 1: {
                        valKey = 0L;
                        break;
                    }
                    case 2: {
                        valKey = ((CombinationLookupData)this.data).db.getNextSequenceValue(((CombinationLookupData)this.data).realSchemaName, fields.getSequenceFrom(), returnFields.getTechnicalKeyField());
                        if (valKey == null || !this.isRowLevel()) break;
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.FoundNextSequenceValue", (String[])new String[0]) + valKey.toString());
                        break;
                    }
                }
                valKey = this.combiInsert(rowMeta, row, valKey, valHash);
                this.incrementLinesOutput();
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.AddedDimensionEntry", (String[])new String[0]) + valKey);
                }
                this.addToCache(((CombinationLookupData)this.data).hashRowMeta, hashRow, valKey);
            } else {
                valKey = ((CombinationLookupData)this.data).db.getReturnRowMeta().getInteger(add, 0);
                this.addToCache(((CombinationLookupData)this.data).hashRowMeta, hashRow, valKey);
            }
        }
        Object[] outputRow = new Object[((CombinationLookupData)this.data).outputRowMeta.size()];
        int outputIndex = 0;
        if (((CombinationLookupMeta)this.meta).isReplaceFields()) {
            for (int i2 = 0; i2 < rowMeta.size(); ++i2) {
                if (((CombinationLookupData)this.data).removeField[i2]) continue;
                outputRow[outputIndex] = row[i2];
                ++outputIndex;
            }
        } else {
            for (outputIndex = 0; outputIndex < rowMeta.size(); ++outputIndex) {
                outputRow[outputIndex] = row[outputIndex];
            }
        }
        outputRow[outputIndex] = valKey;
        return outputRow;
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((CombinationLookupData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((CombinationLookupMeta)this.meta).getFields(((CombinationLookupData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((CombinationLookupData)this.data).schemaTable = ((CombinationLookupMeta)this.meta).getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, ((CombinationLookupData)this.data).realSchemaName, ((CombinationLookupData)this.data).realTableName);
            this.determineTechKeyCreation();
            List<KeyField> keyFields = ((CombinationLookupMeta)this.meta).getFields().getKeyFields();
            ((CombinationLookupData)this.data).keynrs = new int[keyFields.size()];
            for (i = 0; i < keyFields.size(); ++i) {
                KeyField keyField = keyFields.get(i);
                ((CombinationLookupData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(keyField.getName());
                if (((CombinationLookupData)this.data).keynrs[i] >= 0) continue;
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CombinationLookup.Exception.FieldNotFound", (String[])new String[]{keyField.getName()}));
            }
            ((CombinationLookupData)this.data).removeField = new boolean[this.getInputRowMeta().size()];
            for (i = 0; i < this.getInputRowMeta().size(); ++i) {
                IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(i);
                int idx = ((CombinationLookupMeta)this.meta).getFields().indexOfKeyField(valueMeta.getName());
                ((CombinationLookupData)this.data).removeField[i] = idx >= 0;
            }
            ((CombinationLookupData)this.data).hashRowMeta = new RowMeta();
            for (i = 0; i < ((CombinationLookupMeta)this.meta).getFields().getKeyFields().size(); ++i) {
                ((CombinationLookupData)this.data).hashRowMeta.addValueMeta(this.getInputRowMeta().getValueMeta(((CombinationLookupData)this.data).keynrs[i]));
            }
            this.setCombiLookup(this.getInputRowMeta());
            this.preloadCache(((CombinationLookupData)this.data).hashRowMeta);
        }
        try {
            Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
            this.putRow(((CombinationLookupData)this.data).outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (HopException e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, Const.getStackTracker((Throwable)e), null, "CBL001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public void setCombiLookup(IRowMeta inputRowMeta) throws HopDatabaseException {
        DatabaseMeta databaseMeta = ((CombinationLookupMeta)this.meta).getDatabaseMeta();
        CFields fields = ((CombinationLookupMeta)this.meta).getFields();
        List<KeyField> keyFields = fields.getKeyFields();
        ReturnFields returnFields = fields.getReturnFields();
        Object sql = "";
        ((CombinationLookupData)this.data).lookupRowMeta = new RowMeta();
        sql = (String)sql + "SELECT " + databaseMeta.quoteField(returnFields.getTechnicalKeyField()) + Const.CR;
        sql = (String)sql + "FROM " + ((CombinationLookupData)this.data).schemaTable + Const.CR;
        sql = (String)sql + "WHERE ";
        boolean comma = false;
        if (((CombinationLookupMeta)this.meta).isUseHash()) {
            sql = (String)sql + databaseMeta.quoteField(((CombinationLookupMeta)this.meta).getHashField()) + " = ? " + Const.CR;
            comma = true;
            ((CombinationLookupData)this.data).lookupRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(((CombinationLookupMeta)this.meta).getHashField()));
        } else {
            sql = (String)sql + "( ( ";
        }
        for (int i = 0; i < keyFields.size(); ++i) {
            KeyField keyField = keyFields.get(i);
            if (comma) {
                sql = (String)sql + " AND ( ( ";
            } else {
                comma = true;
            }
            sql = (String)sql + databaseMeta.quoteField(keyField.getLookup()) + " = ? ) OR ( " + databaseMeta.quoteField(keyField.getLookup());
            ((CombinationLookupData)this.data).lookupRowMeta.addValueMeta(inputRowMeta.getValueMeta(((CombinationLookupData)this.data).keynrs[i]));
            sql = (String)sql + " IS NULL AND ";
            sql = databaseMeta.requiresCastToVariousForIsNull() ? (String)sql + "CAST(? AS VARCHAR(256)) IS NULL" : (String)sql + "? IS NULL";
            ((CombinationLookupData)this.data).lookupRowMeta.addValueMeta(inputRowMeta.getValueMeta(((CombinationLookupData)this.data).keynrs[i]).clone());
            sql = (String)sql + " ) )";
            sql = (String)sql + Const.CR;
        }
        try {
            if (this.log.isDebug()) {
                this.logDebug("preparing combi-lookup statement:" + Const.CR + (String)sql);
            }
            ((CombinationLookupData)this.data).prepStatementLookup = ((CombinationLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR((String)sql));
            if (databaseMeta.supportsSetMaxRows()) {
                ((CombinationLookupData)this.data).prepStatementLookup.setMaxRows(1);
            }
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare combi-lookup statement", (Throwable)ex);
        }
    }

    public Long combiInsert(IRowMeta rowMeta, Object[] row, Long valKey, Long valCrc) throws HopDatabaseException {
        block41: {
            String debug = "Combination insert";
            DatabaseMeta databaseMeta = ((CombinationLookupMeta)this.meta).getDatabaseMeta();
            CFields fields = ((CombinationLookupMeta)this.meta).getFields();
            List<KeyField> keyFields = fields.getKeyFields();
            ReturnFields returnFields = fields.getReturnFields();
            try {
                if (((CombinationLookupData)this.data).prepStatementInsert == null) {
                    int i;
                    debug = "First: construct prepared statement";
                    ((CombinationLookupData)this.data).insertRowMeta = new RowMeta();
                    Object sql = "";
                    sql = (String)sql + "INSERT INTO " + ((CombinationLookupData)this.data).schemaTable + "( ";
                    boolean comma = false;
                    if (!this.isAutoIncrement()) {
                        sql = (String)sql + databaseMeta.quoteField(returnFields.getTechnicalKeyField());
                        ((CombinationLookupData)this.data).insertRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(returnFields.getTechnicalKeyField()));
                        comma = true;
                    } else if (databaseMeta.needsPlaceHolder()) {
                        sql = (String)sql + "0";
                        ((CombinationLookupData)this.data).insertRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(returnFields.getTechnicalKeyField()));
                        comma = true;
                    }
                    if (((CombinationLookupMeta)this.meta).isUseHash()) {
                        if (comma) {
                            sql = (String)sql + ", ";
                        }
                        sql = (String)sql + databaseMeta.quoteField(((CombinationLookupMeta)this.meta).getHashField());
                        ((CombinationLookupData)this.data).insertRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(((CombinationLookupMeta)this.meta).getHashField()));
                        comma = true;
                    }
                    if (!Utils.isEmpty((CharSequence)returnFields.getLastUpdateField())) {
                        if (comma) {
                            sql = (String)sql + ", ";
                        }
                        sql = (String)sql + databaseMeta.quoteField(returnFields.getLastUpdateField());
                        ((CombinationLookupData)this.data).insertRowMeta.addValueMeta((IValueMeta)new ValueMetaDate(returnFields.getLastUpdateField()));
                        comma = true;
                    }
                    for (i = 0; i < keyFields.size(); ++i) {
                        KeyField keyField = keyFields.get(i);
                        if (comma) {
                            sql = (String)sql + ", ";
                        }
                        sql = (String)sql + databaseMeta.quoteField(keyField.getLookup());
                        ((CombinationLookupData)this.data).insertRowMeta.addValueMeta(rowMeta.getValueMeta(((CombinationLookupData)this.data).keynrs[i]));
                        comma = true;
                    }
                    sql = (String)sql + ") VALUES (";
                    comma = false;
                    if (!this.isAutoIncrement()) {
                        sql = (String)sql + "?";
                        comma = true;
                    }
                    if (((CombinationLookupMeta)this.meta).isUseHash()) {
                        if (comma) {
                            sql = (String)sql + ",";
                        }
                        sql = (String)sql + "?";
                        comma = true;
                    }
                    if (!Utils.isEmpty((CharSequence)returnFields.getLastUpdateField())) {
                        if (comma) {
                            sql = (String)sql + ",";
                        }
                        sql = (String)sql + "?";
                        comma = true;
                    }
                    for (i = 0; i < keyFields.size(); ++i) {
                        if (comma) {
                            sql = (String)sql + ",";
                        } else {
                            comma = true;
                        }
                        sql = (String)sql + "?";
                    }
                    Object sqlStatement = sql = (String)sql + " )";
                    try {
                        debug = "First: prepare statement";
                        if (this.isAutoIncrement() && databaseMeta.supportsAutoGeneratedKeys()) {
                            this.logDetailed("SQL with return keys: " + (String)sqlStatement);
                            ((CombinationLookupData)this.data).prepStatementInsert = ((CombinationLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR((String)sqlStatement), 1);
                        } else {
                            this.logDetailed("SQL without return keys: " + (String)sqlStatement);
                            ((CombinationLookupData)this.data).prepStatementInsert = ((CombinationLookupData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR((String)sqlStatement));
                        }
                    }
                    catch (SQLException ex) {
                        throw new HopDatabaseException("Unable to prepare combi insert statement : " + Const.CR + (String)sqlStatement, (Throwable)ex);
                    }
                    catch (Exception ex) {
                        throw new HopDatabaseException("Unable to prepare combi insert statement : " + Const.CR + (String)sqlStatement, (Throwable)ex);
                    }
                }
                debug = "Create new insert row rins";
                Object[] insertRow = new Object[((CombinationLookupData)this.data).insertRowMeta.size()];
                int insertIndex = 0;
                if (!this.isAutoIncrement()) {
                    insertRow[insertIndex] = valKey;
                    ++insertIndex;
                }
                if (((CombinationLookupMeta)this.meta).isUseHash()) {
                    insertRow[insertIndex] = valCrc;
                    ++insertIndex;
                }
                if (!Utils.isEmpty((CharSequence)returnFields.getLastUpdateField())) {
                    insertRow[insertIndex] = new Date();
                    ++insertIndex;
                }
                for (int i = 0; i < ((CombinationLookupData)this.data).keynrs.length; ++i) {
                    insertRow[insertIndex] = row[((CombinationLookupData)this.data).keynrs[i]];
                    ++insertIndex;
                }
                if (this.isRowLevel()) {
                    this.logRowlevel("rins=" + ((CombinationLookupData)this.data).insertRowMeta.getString(insertRow));
                }
                debug = "Set values on insert";
                ((CombinationLookupData)this.data).db.setValues(((CombinationLookupData)this.data).insertRowMeta, insertRow, ((CombinationLookupData)this.data).prepStatementInsert);
                debug = "Insert row";
                ((CombinationLookupData)this.data).db.insertRow(((CombinationLookupData)this.data).prepStatementInsert);
                debug = "Retrieve key";
                if (!this.isAutoIncrement() || !databaseMeta.supportsAutoGeneratedKeys()) break block41;
                ResultSet keys = null;
                try {
                    keys = ((CombinationLookupData)this.data).prepStatementInsert.getGeneratedKeys();
                    if (keys.next()) {
                        valKey = keys.getLong(1);
                        break block41;
                    }
                    throw new HopDatabaseException(CONST_UNABLE_TO_RETRIEVE_AUTO_INCREMENT_OF_COMBI_INSERT_KEY + returnFields.getTechnicalKeyField() + ", no fields in resultset");
                }
                catch (SQLException ex) {
                    throw new HopDatabaseException(CONST_UNABLE_TO_RETRIEVE_AUTO_INCREMENT_OF_COMBI_INSERT_KEY + returnFields.getTechnicalKeyField(), (Throwable)ex);
                }
                finally {
                    try {
                        if (keys != null) {
                            keys.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new HopDatabaseException(CONST_UNABLE_TO_RETRIEVE_AUTO_INCREMENT_OF_COMBI_INSERT_KEY + returnFields.getTechnicalKeyField(), (Throwable)ex);
                    }
                }
            }
            catch (Exception e) {
                this.logError(Const.getStackTracker((Throwable)e));
                throw new HopDatabaseException("Unexpected error in combination insert in part [" + debug + "] : " + e.toString(), (Throwable)e);
            }
        }
        return valKey;
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public boolean init() {
        if (super.init()) {
            ((CombinationLookupData)this.data).realSchemaName = this.resolve(((CombinationLookupMeta)this.meta).getSchemaName());
            ((CombinationLookupData)this.data).realTableName = this.resolve(((CombinationLookupMeta)this.meta).getTableName());
            ((CombinationLookupData)this.data).cache = ((CombinationLookupMeta)this.meta).getCacheSize() > 0 ? new HashMap<RowMetaAndData, Long>((int)((double)((CombinationLookupMeta)this.meta).getCacheSize() * 1.5)) : new HashMap<RowMetaAndData, Long>();
            if (((CombinationLookupMeta)this.meta).getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            ((CombinationLookupData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((CombinationLookupMeta)this.meta).getDatabaseMeta());
            try {
                ((CombinationLookupData)this.data).db.connect();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.ConnectedToDB", (String[])new String[0]));
                }
                ((CombinationLookupData)this.data).db.setCommit(((CombinationLookupMeta)this.meta).getCommitSize());
                return true;
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.UnableToConnectDB", (String[])new String[0]) + dbe.getMessage());
            }
        }
        return false;
    }

    public void dispose() {
        if (((CombinationLookupData)this.data).db != null) {
            try {
                if (!((CombinationLookupData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((CombinationLookupData)this.data).db.commit();
                    } else {
                        ((CombinationLookupData)this.data).db.rollback();
                    }
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)CONST_COMBINATION_LOOKUP_LOG_UNEXPECTED_ERROR, (String[])new String[0]) + " : " + e.toString());
            }
            finally {
                ((CombinationLookupData)this.data).db.disconnect();
            }
        }
        super.dispose();
    }

    private void preloadCache(IRowMeta hashRowMeta) throws HopDatabaseException, HopValueException, HopConfigException {
        if (((CombinationLookupMeta)this.meta).isPreloadCache() && ((CombinationLookupMeta)this.meta).getCacheSize() >= 0) {
            if (hashRowMeta == null) {
                throw new HopConfigException(BaseMessages.getString(PKG, (String)CONST_COMBINATION_LOOKUP_LOG_UNEXPECTED_ERROR, (String[])new String[0]));
            }
            DatabaseMeta databaseMeta = ((CombinationLookupMeta)this.meta).getDatabaseMeta();
            if (databaseMeta == null) {
                throw new HopConfigException(BaseMessages.getString(PKG, (String)CONST_COMBINATION_LOOKUP_LOG_UNEXPECTED_ERROR, (String[])new String[0]));
            }
            Object lookupKeys = "";
            Object sql = "";
            CFields fields = ((CombinationLookupMeta)this.meta).getFields();
            List<KeyField> keyFields = fields.getKeyFields();
            ReturnFields returnFields = fields.getReturnFields();
            for (int i = 0; i < keyFields.size(); ++i) {
                KeyField keyField = keyFields.get(i);
                lookupKeys = (String)lookupKeys + databaseMeta.quoteField(keyField.getLookup());
                if (i >= keyFields.size() - 1) continue;
                lookupKeys = (String)lookupKeys + "," + Const.CR;
            }
            sql = (String)sql + "SELECT " + Const.CR;
            sql = (String)sql + "MIN(" + databaseMeta.quoteField(returnFields.getTechnicalKeyField()) + ") as " + databaseMeta.quoteField(returnFields.getTechnicalKeyField()) + "," + Const.CR;
            sql = (String)sql + (String)lookupKeys + Const.CR;
            sql = (String)sql + "FROM " + ((CombinationLookupData)this.data).schemaTable + Const.CR;
            sql = (String)sql + "GROUP BY" + Const.CR;
            sql = (String)sql + (String)lookupKeys + Const.CR;
            if (this.log.isDebug()) {
                this.logDebug("Using preload cache statement:" + Const.CR + (String)sql);
            }
            List cacheValues = ((CombinationLookupData)this.data).db.getRows(databaseMeta.stripCR((String)sql), ((CombinationLookupMeta)this.meta).getCacheSize());
            for (Object[] cacheRow : cacheValues) {
                Object[] hashRow = new Object[((CombinationLookupData)this.data).hashRowMeta.size()];
                System.arraycopy(cacheRow, 1, hashRow, 0, hashRow.length);
                this.addToCache(hashRowMeta, hashRow, (Long)cacheRow[0]);
                this.incrementLinesInput();
            }
        }
    }
}

