/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AclUpdatePolicy;
import com.dropbox.core.v2.sharing.FolderAction;
import com.dropbox.core.v2.sharing.LinkSettings;
import com.dropbox.core.v2.sharing.MemberPolicy;
import com.dropbox.core.v2.sharing.SharedLinkPolicy;
import com.dropbox.core.v2.sharing.ViewerInfoPolicy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class UpdateFolderPolicyArg {
    @Nonnull
    protected final String sharedFolderId;
    @Nullable
    protected final MemberPolicy memberPolicy;
    @Nullable
    protected final AclUpdatePolicy aclUpdatePolicy;
    @Nullable
    protected final ViewerInfoPolicy viewerInfoPolicy;
    @Nullable
    protected final SharedLinkPolicy sharedLinkPolicy;
    @Nullable
    protected final LinkSettings linkSettings;
    @Nullable
    protected final List<FolderAction> actions;

    public UpdateFolderPolicyArg(@Nonnull String sharedFolderId, @Nullable MemberPolicy memberPolicy, @Nullable AclUpdatePolicy aclUpdatePolicy, @Nullable ViewerInfoPolicy viewerInfoPolicy, @Nullable SharedLinkPolicy sharedLinkPolicy, @Nullable LinkSettings linkSettings, @Nullable List<FolderAction> actions) {
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        this.memberPolicy = memberPolicy;
        this.aclUpdatePolicy = aclUpdatePolicy;
        this.viewerInfoPolicy = viewerInfoPolicy;
        this.sharedLinkPolicy = sharedLinkPolicy;
        this.linkSettings = linkSettings;
        if (actions != null) {
            for (FolderAction x : actions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'actions' is null");
            }
        }
        this.actions = actions;
    }

    public UpdateFolderPolicyArg(@Nonnull String sharedFolderId) {
        this(sharedFolderId, null, null, null, null, null, null);
    }

    @Nonnull
    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    @Nullable
    public MemberPolicy getMemberPolicy() {
        return this.memberPolicy;
    }

    @Nullable
    public AclUpdatePolicy getAclUpdatePolicy() {
        return this.aclUpdatePolicy;
    }

    @Nullable
    public ViewerInfoPolicy getViewerInfoPolicy() {
        return this.viewerInfoPolicy;
    }

    @Nullable
    public SharedLinkPolicy getSharedLinkPolicy() {
        return this.sharedLinkPolicy;
    }

    @Nullable
    public LinkSettings getLinkSettings() {
        return this.linkSettings;
    }

    @Nullable
    public List<FolderAction> getActions() {
        return this.actions;
    }

    public static Builder newBuilder(String sharedFolderId) {
        return new Builder(sharedFolderId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedFolderId, this.memberPolicy, this.aclUpdatePolicy, this.viewerInfoPolicy, this.sharedLinkPolicy, this.linkSettings, this.actions});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdateFolderPolicyArg other = (UpdateFolderPolicyArg)obj;
            return (this.sharedFolderId == other.sharedFolderId || this.sharedFolderId.equals(other.sharedFolderId)) && (this.memberPolicy == other.memberPolicy || this.memberPolicy != null && this.memberPolicy.equals((Object)other.memberPolicy)) && (this.aclUpdatePolicy == other.aclUpdatePolicy || this.aclUpdatePolicy != null && this.aclUpdatePolicy.equals((Object)other.aclUpdatePolicy)) && (this.viewerInfoPolicy == other.viewerInfoPolicy || this.viewerInfoPolicy != null && this.viewerInfoPolicy.equals((Object)other.viewerInfoPolicy)) && (this.sharedLinkPolicy == other.sharedLinkPolicy || this.sharedLinkPolicy != null && this.sharedLinkPolicy.equals((Object)other.sharedLinkPolicy)) && (this.linkSettings == other.linkSettings || this.linkSettings != null && this.linkSettings.equals(other.linkSettings)) && (this.actions == other.actions || this.actions != null && this.actions.equals(other.actions));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UpdateFolderPolicyArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UpdateFolderPolicyArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("shared_folder_id");
            StoneSerializers.string().serialize(value.sharedFolderId, g);
            if (value.memberPolicy != null) {
                g.writeFieldName("member_policy");
                StoneSerializers.nullable(MemberPolicy.Serializer.INSTANCE).serialize(value.memberPolicy, g);
            }
            if (value.aclUpdatePolicy != null) {
                g.writeFieldName("acl_update_policy");
                StoneSerializers.nullable(AclUpdatePolicy.Serializer.INSTANCE).serialize(value.aclUpdatePolicy, g);
            }
            if (value.viewerInfoPolicy != null) {
                g.writeFieldName("viewer_info_policy");
                StoneSerializers.nullable(ViewerInfoPolicy.Serializer.INSTANCE).serialize(value.viewerInfoPolicy, g);
            }
            if (value.sharedLinkPolicy != null) {
                g.writeFieldName("shared_link_policy");
                StoneSerializers.nullable(SharedLinkPolicy.Serializer.INSTANCE).serialize(value.sharedLinkPolicy, g);
            }
            if (value.linkSettings != null) {
                g.writeFieldName("link_settings");
                StoneSerializers.nullableStruct(LinkSettings.Serializer.INSTANCE).serialize(value.linkSettings, g);
            }
            if (value.actions != null) {
                g.writeFieldName("actions");
                StoneSerializers.nullable(StoneSerializers.list(FolderAction.Serializer.INSTANCE)).serialize(value.actions, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdateFolderPolicyArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<FolderAction> f_actions;
            LinkSettings f_linkSettings;
            SharedLinkPolicy f_sharedLinkPolicy;
            ViewerInfoPolicy f_viewerInfoPolicy;
            AclUpdatePolicy f_aclUpdatePolicy;
            MemberPolicy f_memberPolicy;
            String f_sharedFolderId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sharedFolderId = null;
                f_memberPolicy = null;
                f_aclUpdatePolicy = null;
                f_viewerInfoPolicy = null;
                f_sharedLinkPolicy = null;
                f_linkSettings = null;
                f_actions = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_policy".equals(field)) {
                        f_memberPolicy = StoneSerializers.nullable(MemberPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("acl_update_policy".equals(field)) {
                        f_aclUpdatePolicy = StoneSerializers.nullable(AclUpdatePolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("viewer_info_policy".equals(field)) {
                        f_viewerInfoPolicy = StoneSerializers.nullable(ViewerInfoPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("shared_link_policy".equals(field)) {
                        f_sharedLinkPolicy = StoneSerializers.nullable(SharedLinkPolicy.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("link_settings".equals(field)) {
                        f_linkSettings = StoneSerializers.nullableStruct(LinkSettings.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("actions".equals(field)) {
                        f_actions = StoneSerializers.nullable(StoneSerializers.list(FolderAction.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sharedFolderId == null) {
                    throw new JsonParseException(p, "Required field \"shared_folder_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UpdateFolderPolicyArg value = new UpdateFolderPolicyArg(f_sharedFolderId, f_memberPolicy, f_aclUpdatePolicy, f_viewerInfoPolicy, f_sharedLinkPolicy, f_linkSettings, f_actions);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String sharedFolderId;
        protected MemberPolicy memberPolicy;
        protected AclUpdatePolicy aclUpdatePolicy;
        protected ViewerInfoPolicy viewerInfoPolicy;
        protected SharedLinkPolicy sharedLinkPolicy;
        protected LinkSettings linkSettings;
        protected List<FolderAction> actions;

        protected Builder(String sharedFolderId) {
            if (sharedFolderId == null) {
                throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            this.memberPolicy = null;
            this.aclUpdatePolicy = null;
            this.viewerInfoPolicy = null;
            this.sharedLinkPolicy = null;
            this.linkSettings = null;
            this.actions = null;
        }

        public Builder withMemberPolicy(MemberPolicy memberPolicy) {
            this.memberPolicy = memberPolicy;
            return this;
        }

        public Builder withAclUpdatePolicy(AclUpdatePolicy aclUpdatePolicy) {
            this.aclUpdatePolicy = aclUpdatePolicy;
            return this;
        }

        public Builder withViewerInfoPolicy(ViewerInfoPolicy viewerInfoPolicy) {
            this.viewerInfoPolicy = viewerInfoPolicy;
            return this;
        }

        public Builder withSharedLinkPolicy(SharedLinkPolicy sharedLinkPolicy) {
            this.sharedLinkPolicy = sharedLinkPolicy;
            return this;
        }

        public Builder withLinkSettings(LinkSettings linkSettings) {
            this.linkSettings = linkSettings;
            return this;
        }

        public Builder withActions(List<FolderAction> actions) {
            if (actions != null) {
                for (FolderAction x : actions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'actions' is null");
                }
            }
            this.actions = actions;
            return this;
        }

        public UpdateFolderPolicyArg build() {
            return new UpdateFolderPolicyArg(this.sharedFolderId, this.memberPolicy, this.aclUpdatePolicy, this.viewerInfoPolicy, this.sharedLinkPolicy, this.linkSettings, this.actions);
        }
    }
}

