/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import com.google.auto.value.AutoValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.schemas.utils.AutoValue_ReflectUtils_ClassWithSchema;
import org.apache.beam.sdk.schemas.utils.AutoValue_ReflectUtils_TypeDescriptorWithSchema;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimaps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Primitives;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ReflectUtils {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Method>> DECLARED_METHODS = Maps.newConcurrentMap();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Method> ANNOTATED_CONSTRUCTORS = Maps.newConcurrentMap();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field>> DECLARED_FIELDS = Maps.newConcurrentMap();

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Method> getMethods(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return DECLARED_METHODS.computeIfAbsent(clazz, c -> Arrays.stream(c.getDeclaredMethods()).filter(m -> !m.isBridge()).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> !Modifier.isStatic(m.getModifiers())).collect(Collectors.toList()));
    }

    public static @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Method> getMethodsMap(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return Multimaps.index(ReflectUtils.getMethods(clazz), Method::getName);
    }

    public static @Nullable @UnknownKeyFor @Initialized Constructor getAnnotatedConstructor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> m.getAnnotation(SchemaCreate.class) != null).findFirst().orElse(null);
    }

    public static @Nullable @UnknownKeyFor @Initialized Method getAnnotatedCreateMethod(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return ANNOTATED_CONSTRUCTORS.computeIfAbsent(clazz, c -> {
            Method method = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getAnnotation(SchemaCreate.class) != null).findFirst().orElse(null);
            if (method != null && !clazz.isAssignableFrom(method.getReturnType())) {
                throw new InvalidParameterException("A method marked with SchemaCreate in class " + clazz + " does not return a type assignable to " + clazz);
            }
            return method;
        });
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> getFields(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return DECLARED_FIELDS.computeIfAbsent(clazz, c -> {
            LinkedHashMap<String, Field> types = new LinkedHashMap<String, Field>();
            while (c.getPackage() == null || !c.getPackage().getName().startsWith("java.")) {
                for (Field field : c.getDeclaredFields()) {
                    if ((field.getModifiers() & 0x88) != 0 || (field.getModifiers() & 6) != 0) continue;
                    Preconditions.checkArgument((types.put(field.getName(), field) == null ? 1 : 0) != 0, (Object)(c.getSimpleName() + " contains two fields named: " + field));
                }
                if ((c = c.getSuperclass()) != null) continue;
            }
            return Lists.newArrayList(types.values());
        });
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isGetter(@UnknownKeyFor @NonNull @Initialized Method method) {
        if (Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        if (method.getName().startsWith("get") && method.getName().length() > 3) {
            return true;
        }
        return method.getName().startsWith("is") && method.getName().length() > 2 && method.getParameterCount() == 0 && (Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType()));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isSetter(@UnknownKeyFor @NonNull @Initialized Method method) {
        return method.getParameterCount() == 1 && method.getName().startsWith("set");
    }

    public static @UnknownKeyFor @NonNull @Initialized String stripPrefix(@UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        if (!methodName.startsWith(prefix)) {
            return methodName;
        }
        String firstLetter = methodName.substring(prefix.length(), prefix.length() + 1).toLowerCase();
        return methodName.length() == prefix.length() + 1 ? firstLetter : firstLetter + methodName.substring(prefix.length() + 1, methodName.length());
    }

    public static @UnknownKeyFor @NonNull @Initialized String stripGetterPrefix(@UnknownKeyFor @NonNull @Initialized String method) {
        if (method.startsWith("get")) {
            return ReflectUtils.stripPrefix(method, "get");
        }
        return ReflectUtils.stripPrefix(method, "is");
    }

    public static @UnknownKeyFor @NonNull @Initialized String stripSetterPrefix(@UnknownKeyFor @NonNull @Initialized String method) {
        return ReflectUtils.stripPrefix(method, "set");
    }

    public static @Nullable @UnknownKeyFor @Initialized TypeDescriptor getIterableComponentType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor valueType) {
        TypeDescriptor<?> componentType = null;
        if (valueType.isArray()) {
            Type component = valueType.getComponentType().getType();
            if (!component.equals(Byte.TYPE)) {
                componentType = TypeDescriptor.of(component);
            }
        } else if (valueType.isSubtypeOf(TypeDescriptor.of(Iterable.class))) {
            TypeDescriptor<Iterable> collection = valueType.getSupertype(Iterable.class);
            if (collection.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)collection.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument((params.length == 1 ? 1 : 0) != 0);
                componentType = TypeDescriptor.of(params[0]);
            } else {
                throw new RuntimeException("Collection parameter is not parameterized!");
            }
        }
        return componentType;
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor getMapType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor valueType, @UnknownKeyFor @NonNull @Initialized int index) {
        TypeDescriptor<?> mapType = null;
        if (valueType.isSubtypeOf(TypeDescriptor.of(Map.class))) {
            TypeDescriptor<Map> map = valueType.getSupertype(Map.class);
            if (map.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)map.getType();
                Type[] params = ptype.getActualTypeArguments();
                mapType = TypeDescriptor.of(params[index]);
            } else {
                throw new RuntimeException("Map type is not parameterized! " + map);
            }
        }
        return mapType;
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor boxIfPrimitive(@UnknownKeyFor @NonNull @Initialized TypeDescriptor typeDescriptor) {
        return typeDescriptor.getRawType().isPrimitive() ? TypeDescriptor.of(Primitives.wrap(typeDescriptor.getRawType())) : typeDescriptor;
    }

    @AutoValue
    public static abstract class TypeDescriptorWithSchema<@UnknownKeyFor T> {
        public abstract @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getTypeDescriptor();

        public abstract @UnknownKeyFor @NonNull @Initialized Schema getSchema();

        public static <T> @UnknownKeyFor @NonNull @Initialized TypeDescriptorWithSchema<T> create(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            return new AutoValue_ReflectUtils_TypeDescriptorWithSchema<T>(typeDescriptor, schema);
        }
    }

    @AutoValue
    public static abstract class ClassWithSchema {
        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getClazz();

        public abstract @UnknownKeyFor @NonNull @Initialized Schema getSchema();

        public static @UnknownKeyFor @NonNull @Initialized ClassWithSchema create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            return new AutoValue_ReflectUtils_ClassWithSchema(clazz, schema);
        }
    }
}

