/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ZstdCoder<@UnknownKeyFor T>
extends Coder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder;
    @Nullable
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] dict;
    private final @UnknownKeyFor @NonNull @Initialized int level;

    public static <T> @UnknownKeyFor @NonNull @Initialized ZstdCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dict, @UnknownKeyFor @NonNull @Initialized int level) {
        return new ZstdCoder<T>(innerCoder, dict, level);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ZstdCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dict) {
        return new ZstdCoder<T>(innerCoder, dict, Zstd.defaultCompressionLevel());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ZstdCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder, @UnknownKeyFor @NonNull @Initialized int level) {
        return new ZstdCoder<T>(innerCoder, null, level);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ZstdCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder) {
        return new ZstdCoder<T>(innerCoder, null, Zstd.defaultCompressionLevel());
    }

    private ZstdCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> innerCoder, @Nullable @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized [] dict, @UnknownKeyFor @NonNull @Initialized int level) {
        this.innerCoder = innerCoder;
        this.dict = dict;
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(this.level);
            ctx.setMagicless(true);
            ctx.setDictID(false);
            ctx.loadDict(this.dict);
            byte[] encoded = CoderUtils.encodeToByteArray(this.innerCoder, value);
            byte[] compressed = ctx.compress(encoded);
            ByteArrayCoder.of().encode(compressed, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ZstdDecompressCtx ctx = new ZstdDecompressCtx();){
            ctx.setMagicless(true);
            ctx.loadDict(this.dict);
            byte[] compressed = ByteArrayCoder.of().decode(is);
            int decompressedSize = (int)Zstd.decompressedSize((byte[])compressed, (int)0, (int)compressed.length, (boolean)true);
            byte[] encoded = ctx.decompress(compressed, decompressedSize);
            T t = CoderUtils.decodeFromByteArray(this.innerCoder, encoded);
            return t;
        }
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return ImmutableList.of(this.innerCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.innerCoder.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.innerCoder.consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(T value) {
        return this.innerCoder.structuralValue(value);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZstdCoder that = (ZstdCoder)o;
        return this.innerCoder.equals(that.innerCoder) && Arrays.equals(this.dict, that.dict) && this.level == that.level;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.innerCoder, Arrays.hashCode(this.dict), this.level);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("innerCoder", this.innerCoder).add("dict", this.dict == null ? null : "base64:" + BaseEncoding.base64().encode(this.dict)).add("level", this.level).toString();
    }
}

