/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import org.apache.beam.runners.flink.metrics.FlinkMetricContainerBase;
import org.apache.beam.runners.flink.metrics.MetricsAccumulator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.MetricGroup;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMetricContainer
extends FlinkMetricContainerBase {
    public static final @UnknownKeyFor @NonNull @Initialized String ACCUMULATOR_NAME = "__metricscontainers";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkMetricContainer.class);
    private final @UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext;

    public FlinkMetricContainer(@UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext) {
        super((MetricGroup)runtimeContext.getMetricGroup());
        this.runtimeContext = runtimeContext;
    }

    public void registerMetricsForPipelineResult() {
        Object metricsAccumulator = this.runtimeContext.getAccumulator(ACCUMULATOR_NAME);
        if (metricsAccumulator == null) {
            metricsAccumulator = new MetricsAccumulator();
            try {
                this.runtimeContext.addAccumulator(ACCUMULATOR_NAME, metricsAccumulator);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                LOG.error("Failed to create metrics accumulator.", (Throwable)e);
            }
        }
        metricsAccumulator.add((Object)this.metricsContainers);
    }
}

