/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.addxml;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.addxml.AddXmlMeta;
import org.apache.hop.pipeline.transforms.xml.addxml.XmlField;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AddXmlDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AddXmlMeta.class;
    private Button wOmitXMLHeader;
    private Button wOmitNullValues;
    private CCombo wEncoding;
    private CCombo wOutputValue;
    private CCombo wRepeatElement;
    private TableView wFields;
    private final AddXmlMeta input;
    private boolean gotEncodings = false;
    private ColumnInfo[] colinf;
    private final Map<String, Integer> inputFields;

    public AddXmlDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (AddXmlMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Label wlEncoding = new Label(wContentComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment(null, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment(null, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)AddXmlDialog.this.shell.getDisplay(), 1);
                AddXmlDialog.this.shell.setCursor(busy);
                AddXmlDialog.this.setEncodings();
                AddXmlDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlOutputValue = new Label(wContentComp, 131072);
        wlOutputValue.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.OutputValue.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOutputValue);
        FormData fdlOutputValue = new FormData();
        fdlOutputValue.left = new FormAttachment(0, 0);
        fdlOutputValue.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlOutputValue.right = new FormAttachment(middle, -margin);
        wlOutputValue.setLayoutData((Object)fdlOutputValue);
        this.wOutputValue = new CCombo(wContentComp, 2056);
        this.wOutputValue.setEditable(true);
        this.props.setLook((Control)this.wOutputValue);
        this.wOutputValue.addModifyListener(lsMod);
        FormData fdOutputValue = new FormData();
        fdOutputValue.left = new FormAttachment(middle, 0);
        fdOutputValue.top = new FormAttachment((Control)this.wEncoding, margin);
        fdOutputValue.right = new FormAttachment(100, 0);
        this.wOutputValue.setLayoutData((Object)fdOutputValue);
        Label wlRepeatElement = new Label(wContentComp, 131072);
        wlRepeatElement.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.RepeatElement.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRepeatElement);
        FormData fdlRepeatElement = new FormData();
        fdlRepeatElement.left = new FormAttachment(0, 0);
        fdlRepeatElement.top = new FormAttachment((Control)this.wOutputValue, margin);
        fdlRepeatElement.right = new FormAttachment(middle, -margin);
        wlRepeatElement.setLayoutData((Object)fdlRepeatElement);
        this.wRepeatElement = new CCombo(wContentComp, 2056);
        this.wRepeatElement.setEditable(true);
        this.props.setLook((Control)this.wRepeatElement);
        this.wRepeatElement.addModifyListener(lsMod);
        FormData fdRepeatElement = new FormData();
        fdRepeatElement.left = new FormAttachment(middle, 0);
        fdRepeatElement.top = new FormAttachment((Control)this.wOutputValue, margin);
        fdRepeatElement.right = new FormAttachment(100, 0);
        this.wRepeatElement.setLayoutData((Object)fdRepeatElement);
        Label wlOmitXMLHeader = new Label(wContentComp, 131072);
        wlOmitXMLHeader.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.OmitXMLHeader.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOmitXMLHeader);
        FormData fdlOmitXMLHeader = new FormData();
        fdlOmitXMLHeader.left = new FormAttachment(0, 0);
        fdlOmitXMLHeader.top = new FormAttachment((Control)this.wRepeatElement, margin);
        fdlOmitXMLHeader.right = new FormAttachment(middle, -margin);
        wlOmitXMLHeader.setLayoutData((Object)fdlOmitXMLHeader);
        this.wOmitXMLHeader = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wOmitXMLHeader);
        FormData fdOmitXMLHeader = new FormData();
        fdOmitXMLHeader.left = new FormAttachment(middle, 0);
        fdOmitXMLHeader.top = new FormAttachment((Control)wlOmitXMLHeader, 0, 0x1000000);
        fdOmitXMLHeader.right = new FormAttachment(100, 0);
        this.wOmitXMLHeader.setLayoutData((Object)fdOmitXMLHeader);
        this.wOmitXMLHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddXmlDialog.this.input.setChanged();
            }
        });
        Label wlOmitNullValues = new Label(wContentComp, 131072);
        wlOmitNullValues.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.OmitNullValues.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOmitNullValues);
        FormData fdlOmitNullValues = new FormData();
        fdlOmitNullValues.left = new FormAttachment(0, 0);
        fdlOmitNullValues.top = new FormAttachment((Control)this.wOmitXMLHeader, margin);
        fdlOmitNullValues.right = new FormAttachment(middle, -margin);
        wlOmitNullValues.setLayoutData((Object)fdlOmitNullValues);
        this.wOmitNullValues = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wOmitNullValues);
        FormData fdOmitNullValues = new FormData();
        fdOmitNullValues.left = new FormAttachment(middle, 0);
        fdOmitNullValues.top = new FormAttachment((Control)wlOmitNullValues, 0, 0x1000000);
        fdOmitNullValues.right = new FormAttachment(100, 0);
        this.wOmitNullValues.setLayoutData((Object)fdOmitNullValues);
        this.wOmitNullValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddXmlDialog.this.input.setChanged();
            }
        });
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.Get.Button", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"AddXMLDialog.Get.Tooltip", (String[])new String[0]));
        Button wMinWidth = new Button(wFieldsComp, 8);
        wMinWidth.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.MinWidth.Label", (String[])new String[0]));
        wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"AddXMLDialog.MinWidth.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet, wMinWidth}, margin, null);
        int FieldsRows = this.input.getOutputFields().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.ElementName.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Type.Column", (String[])new String[0]), 2, ValueMetaBase.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Format.Column", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Null.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Attribute.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.AttributeParentName.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        wMinWidth.addListener(13, e -> this.setMinimalWidth());
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            } else {
                this.wEncoding.select(Const.indexOfString((String)"UTF-8", (String[])this.wEncoding.getItems()));
            }
        }
    }

    public void getData() {
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getValueName() != null) {
            this.wOutputValue.setText(this.input.getValueName());
        }
        if (this.input.getRootNode() != null) {
            this.wRepeatElement.setText(this.input.getRootNode());
        }
        this.wOmitXMLHeader.setSelection(this.input.isOmitXMLheader());
        this.wOmitNullValues.setSelection(this.input.isOmitNullValues());
        this.logDebug(BaseMessages.getString(PKG, (String)"AddXMLDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            XmlField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            if (field.getFieldName() != null) {
                item.setText(1, field.getFieldName());
            }
            if (field.getElementName() != null) {
                item.setText(2, field.getElementName());
            }
            item.setText(3, field.getTypeDesc());
            if (field.getFormat() != null) {
                item.setText(4, field.getFormat());
            }
            if (field.getLength() >= 0) {
                item.setText(5, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                item.setText(6, "" + field.getPrecision());
            }
            if (field.getCurrencySymbol() != null) {
                item.setText(7, field.getCurrencySymbol());
            }
            if (field.getDecimalSymbol() != null) {
                item.setText(8, field.getDecimalSymbol());
            }
            if (field.getGroupingSymbol() != null) {
                item.setText(9, field.getGroupingSymbol());
            }
            if (field.getNullString() != null) {
                item.setText(10, field.getNullString());
            }
            item.setText(11, field.isAttribute() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            if (field.getAttributeParentName() == null) continue;
            item.setText(12, field.getAttributeParentName());
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(AddXmlMeta tfoi) {
        tfoi.setEncoding(this.wEncoding.getText());
        tfoi.setValueName(this.wOutputValue.getText());
        tfoi.setRootNode(this.wRepeatElement.getText());
        tfoi.setOmitXMLheader(this.wOmitXMLHeader.getSelection());
        tfoi.setOmitNullValues(this.wOmitNullValues.getSelection());
        int nrFields = this.wFields.nrNonEmpty();
        tfoi.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            XmlField field = new XmlField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setFieldName(item.getText(1));
            field.setElementName(item.getText(2));
            if (field.getFieldName().equals(field.getElementName())) {
                field.setElementName("");
            }
            field.setType(item.getText(3));
            field.setFormat(item.getText(4));
            field.setLength(Const.toInt((String)item.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(6), (int)-1));
            field.setCurrencySymbol(item.getText(7));
            field.setDecimalSymbol(item.getText(8));
            field.setGroupingSymbol(item.getText(9));
            field.setNullString(item.getText(10));
            field.setAttribute(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equals(item.getText(11)));
            field.setAttributeParentName(item.getText(12));
            tfoi.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)5, (int)6, (tableItem, v) -> {
                    if (v.isNumber() && v.getLength() > 0) {
                        int m;
                        int le = v.getLength();
                        int pr = v.getPrecision();
                        if (v.getPrecision() <= 0) {
                            pr = 0;
                        }
                        Object mask = " ";
                        for (m = 0; m < le - pr; ++m) {
                            mask = (String)mask + "0";
                        }
                        if (pr > 0) {
                            mask = (String)mask + ".";
                        }
                        for (m = 0; m < pr; ++m) {
                            mask = (String)mask + "0";
                        }
                        tableItem.setText(4, (String)mask);
                    }
                    return true;
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(5, "");
            item.setText(6, "");
            int type = ValueMetaBase.getType((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(4, "");
                    continue block6;
                }
                case 5: {
                    item.setText(4, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(4, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        this.wFields.optWidth(true);
    }
}

