/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishMessagesFn
extends DoFn<HopRow, PubsubMessage> {
    private String rowMetaJson;
    private int fieldIndex;
    private String transformName;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(PublishMessagesFn.class);
    private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamPublishTransformErrors");
    private IRowMeta rowMeta;
    private transient Counter initCounter;
    private transient Counter readCounter;
    private transient Counter outputCounter;

    public PublishMessagesFn(String transformName, int fieldIndex, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.fieldIndex = fieldIndex;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
            this.outputCounter = Metrics.counter((String)"output", (String)this.transformName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in setup of pub/sub publish messages function", (Throwable)e);
            throw new RuntimeException("Error in setup of pub/sub publish messages function", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            HopRow hopRow = (HopRow)processContext.element();
            this.readCounter.inc();
            try {
                byte[] bytes = this.rowMeta.getBinary(hopRow.getRow(), this.fieldIndex);
                PubsubMessage message = new PubsubMessage(bytes, new HashMap());
                processContext.output((Object)message);
                this.outputCounter.inc();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to pass message", e);
            }
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in pub/sub publish messages function", (Throwable)e);
            throw new RuntimeException("Error in pub/sub publish messages function", e);
        }
    }
}

