/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.hbase.adapters.admin.ColumnDescriptorAdapter;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class ModifyTableBuilder {
    private final ModifyColumnFamiliesRequest request;

    private ModifyTableBuilder(String tableId) {
        this.request = ModifyColumnFamiliesRequest.of(tableId);
    }

    public static ModifyTableBuilder newBuilder(TableName tableName) {
        return new ModifyTableBuilder(tableName.getNameAsString());
    }

    private static Set<String> getColumnNames(HTableDescriptor tableDescriptor) {
        HashSet<String> names = new HashSet<String>();
        for (byte[] name : tableDescriptor.getFamiliesKeys()) {
            names.add(Bytes.toString((byte[])name));
        }
        return names;
    }

    public static ModifyTableBuilder buildModifications(HTableDescriptor newTableDesc, HTableDescriptor currentTableDesc) {
        Preconditions.checkNotNull(newTableDesc);
        Preconditions.checkNotNull(currentTableDesc);
        ModifyTableBuilder requestBuilder = ModifyTableBuilder.newBuilder(currentTableDesc.getTableName());
        Set<String> currentColumnNames = ModifyTableBuilder.getColumnNames(currentTableDesc);
        Set<String> newColumnNames = ModifyTableBuilder.getColumnNames(newTableDesc);
        for (HColumnDescriptor hColumnDescriptor : newTableDesc.getFamilies()) {
            String columnName = hColumnDescriptor.getNameAsString();
            if (currentColumnNames.contains(columnName)) {
                requestBuilder.modify(hColumnDescriptor);
                continue;
            }
            requestBuilder.add(hColumnDescriptor);
        }
        HashSet<String> columnsToRemove = new HashSet<String>(currentColumnNames);
        columnsToRemove.removeAll(newColumnNames);
        for (String column : columnsToRemove) {
            requestBuilder.delete(column);
        }
        return requestBuilder;
    }

    public ModifyTableBuilder add(HColumnDescriptor addColumnFamily) {
        this.request.addFamily(addColumnFamily.getNameAsString(), ColumnDescriptorAdapter.buildGarbageCollectionRule(addColumnFamily));
        return this;
    }

    public ModifyTableBuilder modify(HColumnDescriptor modifyColumnFamily) {
        this.request.updateFamily(modifyColumnFamily.getNameAsString(), ColumnDescriptorAdapter.buildGarbageCollectionRule(modifyColumnFamily));
        return this;
    }

    public ModifyTableBuilder delete(String familyId) {
        this.request.dropFamily(familyId);
        return this;
    }

    public ModifyColumnFamiliesRequest build() {
        return this.request;
    }
}

