/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingSettings;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@BetaApi(value="This surface is likely to change as the batching surface evolves.")
public class BigtableBulkReadRowsCallSettings
extends UnaryCallSettings<Query, List<Row>> {
    private final BatchingCallSettings<ByteString, Row, Query, List<Row>> batchingCallSettings;

    private BigtableBulkReadRowsCallSettings(Builder builder) {
        super(builder);
        this.batchingCallSettings = ((BatchingCallSettings.Builder)((BatchingCallSettings.Builder)BatchingCallSettings.newBuilder(builder.batchingDescriptor).setBatchingSettings(builder.batchingSettings).setRetrySettings(builder.getRetrySettings())).setRetryableCodes((Set)builder.getRetryableCodes())).build();
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingCallSettings.getBatchingSettings();
    }

    BatchingDescriptor<ByteString, Row, Query, List<Row>> getBatchingDescriptor() {
        return this.batchingCallSettings.getBatchingDescriptor();
    }

    static Builder newBuilder(BatchingDescriptor<ByteString, Row, Query, List<Row>> batchingDescriptor) {
        return new Builder(batchingDescriptor);
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends UnaryCallSettings.Builder<Query, List<Row>> {
        private BatchingDescriptor<ByteString, Row, Query, List<Row>> batchingDescriptor;
        private BatchingSettings batchingSettings;

        private Builder(@Nonnull BatchingDescriptor<ByteString, Row, Query, List<Row>> batchingDescriptor) {
            this.batchingDescriptor = Preconditions.checkNotNull(batchingDescriptor, "batching descriptor can't be null");
        }

        private Builder(@Nonnull BigtableBulkReadRowsCallSettings settings) {
            super(settings);
            this.batchingDescriptor = settings.getBatchingDescriptor();
            this.batchingSettings = settings.getBatchingSettings();
        }

        public Builder setBatchingSettings(@Nonnull BatchingSettings batchingSettings) {
            Preconditions.checkNotNull(batchingSettings, "batching settings can't be null");
            this.batchingSettings = batchingSettings;
            return this;
        }

        public BatchingSettings getBatchingSettings() {
            return this.batchingSettings;
        }

        public Builder setRetryableCodes(StatusCode.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        public Builder setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        public Builder setRetrySettings(@Nonnull RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public BigtableBulkReadRowsCallSettings build() {
            return new BigtableBulkReadRowsCallSettings(this);
        }
    }
}

