/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.stats.stackdriver;

import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.stats.stackdriver.AutoValue_StackdriverStatsConfiguration;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.stats.stackdriver.StackdriverExportUtils;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelKey;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.repackaged.com.google.cloud.ServiceOptions;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class StackdriverStatsConfiguration {
    static final Duration DEFAULT_INTERVAL = Duration.create(60L, 0);
    static final MonitoredResource DEFAULT_RESOURCE = StackdriverExportUtils.getDefaultResource();
    static final String DEFAULT_PROJECT_ID = Strings.nullToEmpty(ServiceOptions.getDefaultProjectId());
    static final Duration DEFAULT_DEADLINE = Duration.create(60L, 0);

    StackdriverStatsConfiguration() {
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getProjectId();

    public abstract Duration getExportInterval();

    public abstract MonitoredResource getMonitoredResource();

    @Nullable
    public abstract String getMetricNamePrefix();

    @Nullable
    public abstract String getDisplayNamePrefix();

    public abstract Map<LabelKey, LabelValue> getConstantLabels();

    public abstract Duration getDeadline();

    @Nullable
    public abstract MetricServiceStub getMetricServiceStub();

    public static Builder builder() {
        return new AutoValue_StackdriverStatsConfiguration.Builder().setProjectId(DEFAULT_PROJECT_ID).setConstantLabels(StackdriverExportUtils.DEFAULT_CONSTANT_LABELS).setExportInterval(DEFAULT_INTERVAL).setMonitoredResource(DEFAULT_RESOURCE).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.fromMillis(0L);

        Builder() {
        }

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setExportInterval(Duration var1);

        public abstract Builder setMonitoredResource(MonitoredResource var1);

        public abstract Builder setMetricNamePrefix(String var1);

        public abstract Builder setDisplayNamePrefix(String var1);

        public abstract Builder setConstantLabels(Map<LabelKey, LabelValue> var1);

        public abstract Builder setDeadline(Duration var1);

        public abstract Builder setMetricServiceStub(MetricServiceStub var1);

        abstract String getProjectId();

        abstract Map<LabelKey, LabelValue> getConstantLabels();

        abstract Duration getDeadline();

        abstract StackdriverStatsConfiguration autoBuild();

        public StackdriverStatsConfiguration build() {
            this.setConstantLabels(Collections.unmodifiableMap(new LinkedHashMap<LabelKey, LabelValue>(this.getConstantLabels())));
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.getProjectId()), "Cannot find a project ID from either configurations or application default.");
            for (Map.Entry<LabelKey, LabelValue> constantLabel : this.getConstantLabels().entrySet()) {
                Preconditions.checkNotNull(constantLabel.getKey(), "constant label key");
                Preconditions.checkNotNull(constantLabel.getValue(), "constant label value");
            }
            Preconditions.checkArgument(this.getDeadline().compareTo(ZERO) > 0, "Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

