/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalAwareExecutorService
implements LocalAwareExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLocalAwareExecutorService.class);

    protected abstract void addTask(FutureTask<?> var1);

    protected abstract void onCompletion();

    public <T> FutureTask<T> submit(Callable<T> task) {
        return this.submit(this.newTaskFor(task));
    }

    public FutureTask<?> submit(Runnable task) {
        return this.submit(this.newTaskFor(task, null));
    }

    public <T> FutureTask<T> submit(Runnable task, T result) {
        return this.submit(this.newTaskFor(task, result));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    protected <T> FutureTask<T> newTaskFor(Runnable runnable, T result) {
        return this.newTaskFor(runnable, result, ExecutorLocals.create());
    }

    protected <T> FutureTask<T> newTaskFor(Runnable runnable, T result, ExecutorLocals locals) {
        if (locals != null) {
            if (runnable instanceof LocalSessionFutureTask) {
                return (LocalSessionFutureTask)runnable;
            }
            return new LocalSessionFutureTask<T>(runnable, result, locals);
        }
        if (runnable instanceof FutureTask) {
            return (FutureTask)runnable;
        }
        return new FutureTask<T>(runnable, result);
    }

    protected <T> FutureTask<T> newTaskFor(Callable<T> callable) {
        if (Tracing.isTracing()) {
            if (callable instanceof LocalSessionFutureTask) {
                return (LocalSessionFutureTask)((Object)callable);
            }
            return new LocalSessionFutureTask<T>(callable, ExecutorLocals.create());
        }
        if (callable instanceof FutureTask) {
            return (FutureTask)((Object)callable);
        }
        return new FutureTask<T>(callable);
    }

    private <T> FutureTask<T> submit(FutureTask<T> task) {
        this.addTask(task);
        return task;
    }

    @Override
    public void execute(Runnable command) {
        this.addTask(this.newTaskFor(command, ExecutorLocals.create()));
    }

    @Override
    public void execute(Runnable command, ExecutorLocals locals) {
        this.addTask(this.newTaskFor(command, null, locals));
    }

    class FutureTask<T>
    extends SimpleCondition
    implements Future<T>,
    Runnable {
        private boolean failure;
        private Object result = this;
        private final Callable<T> callable;

        public FutureTask(Callable<T> callable) {
            this.callable = callable;
        }

        public FutureTask(Runnable runnable, T result) {
            this(Executors.callable(runnable, result));
        }

        @Override
        public void run() {
            try {
                this.result = this.callable.call();
            }
            catch (Throwable t) {
                logger.error("Uncaught exception on thread {}", (Object)Thread.currentThread(), (Object)t);
                this.result = t;
                this.failure = true;
                JVMStabilityInspector.inspectThrowable(t);
            }
            finally {
                this.signalAll();
                AbstractLocalAwareExecutorService.this.onCompletion();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.isSignaled();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.await();
            Object result = this.result;
            if (this.failure) {
                throw new ExecutionException((Throwable)result);
            }
            return (T)result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.await(timeout, unit)) {
                throw new TimeoutException();
            }
            Object result = this.result;
            if (this.failure) {
                throw new ExecutionException((Throwable)result);
            }
            return (T)result;
        }
    }

    private class LocalSessionFutureTask<T>
    extends FutureTask<T> {
        private final ExecutorLocals locals;

        public LocalSessionFutureTask(Callable<T> callable, ExecutorLocals locals) {
            super(callable);
            this.locals = locals;
        }

        public LocalSessionFutureTask(Runnable runnable, T result, ExecutorLocals locals) {
            super(runnable, result);
            this.locals = locals;
        }

        @Override
        public void run() {
            ExecutorLocals old = ExecutorLocals.create();
            ExecutorLocals.set(this.locals);
            try {
                super.run();
            }
            finally {
                ExecutorLocals.set(old);
            }
        }
    }
}

