/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.fnexecution.control.DefaultExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ReferenceCountingExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.transforms.SerializableFunction;

public class SparkExecutableStageContextFactory
implements ExecutableStageContext.Factory {
    private static final SparkExecutableStageContextFactory instance = new SparkExecutableStageContextFactory();
    private static final ConcurrentMap<String, ExecutableStageContext.Factory> jobFactories = new ConcurrentHashMap<String, ExecutableStageContext.Factory>();

    private SparkExecutableStageContextFactory() {
    }

    public static SparkExecutableStageContextFactory getInstance() {
        return instance;
    }

    public ExecutableStageContext get(JobInfo jobInfo) {
        ExecutableStageContext.Factory jobFactory = jobFactories.computeIfAbsent(jobInfo.jobId(), k -> ReferenceCountingExecutableStageContextFactory.create(DefaultExecutableStageContext::create, (SerializableFunction & Serializable)caller -> false));
        return jobFactory.get(jobInfo);
    }
}

