/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaTransformReadConfiguration;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializers;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
class PubsubSchemaTransformMessageToRowFactory {
    private static final String DEFAULT_FORMAT = "json";
    private static final Schema.FieldType ATTRIBUTE_MAP_FIELD_TYPE = Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING.withNullable(false), (Schema.FieldType)Schema.FieldType.STRING);
    private static final Schema ATTRIBUTE_ARRAY_ENTRY_SCHEMA = Schema.builder().addStringField("key").addStringField("value").build();
    private static final Schema.FieldType ATTRIBUTE_ARRAY_FIELD_TYPE = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)ATTRIBUTE_ARRAY_ENTRY_SCHEMA));
    private static final String THRIFT_CLASS_KEY = "thriftClass";
    private static final String THRIFT_PROTOCOL_FACTORY_CLASS_KEY = "thriftProtocolFactoryClass";
    private static final String PROTO_CLASS_KEY = "protoClass";
    private final PubsubSchemaTransformReadConfiguration configuration;

    static PubsubSchemaTransformMessageToRowFactory from(PubsubSchemaTransformReadConfiguration configuration) {
        return new PubsubSchemaTransformMessageToRowFactory(configuration);
    }

    PubsubMessageToRow buildMessageToRow() {
        PubsubMessageToRow.Builder builder = PubsubMessageToRow.builder().messageSchema(this.configuration.getDataSchema()).useDlq(this.configuration.getDeadLetterQueue() != null && !this.configuration.getDeadLetterQueue().isEmpty()).useFlatSchema(!this.shouldUseNestedSchema());
        if (this.needsSerializer()) {
            builder = builder.serializerProvider(this.serializer());
        }
        return builder.build();
    }

    private PubsubSchemaTransformMessageToRowFactory(PubsubSchemaTransformReadConfiguration configuration) {
        this.configuration = configuration;
    }

    private PayloadSerializer payloadSerializer() {
        Schema schema = this.configuration.getDataSchema();
        String format = DEFAULT_FORMAT;
        if (this.configuration.getFormat() != null && !this.configuration.getFormat().isEmpty()) {
            format = this.configuration.getFormat();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.configuration.getThriftClass() != null && !this.configuration.getThriftClass().isEmpty()) {
            params.put(THRIFT_CLASS_KEY, this.configuration.getThriftClass());
        }
        if (this.configuration.getThriftProtocolFactoryClass() != null && !this.configuration.getThriftProtocolFactoryClass().isEmpty()) {
            params.put(THRIFT_PROTOCOL_FACTORY_CLASS_KEY, this.configuration.getThriftProtocolFactoryClass());
        }
        if (this.configuration.getProtoClass() != null && !this.configuration.getProtoClass().isEmpty()) {
            params.put(PROTO_CLASS_KEY, this.configuration.getProtoClass());
        }
        return PayloadSerializers.getSerializer((String)format, (Schema)schema, params);
    }

    PubsubMessageToRow.SerializerProvider serializer() {
        return (PubsubMessageToRow.SerializerProvider & Serializable)input -> this.payloadSerializer();
    }

    boolean needsSerializer() {
        return !this.shouldUseNestedSchema() || !this.fieldPresent("payload", Schema.FieldType.BYTES);
    }

    boolean shouldUseNestedSchema() {
        return this.schemaHasValidPayloadField() && this.schemaHasValidAttributesField();
    }

    boolean schemaHasValidPayloadField() {
        Schema schema = this.configuration.getDataSchema();
        if (!schema.hasField("payload")) {
            return false;
        }
        if (this.fieldPresent("payload", Schema.FieldType.BYTES)) {
            return true;
        }
        return schema.getField("payload").getType().getTypeName().equals((Object)Schema.TypeName.ROW);
    }

    boolean schemaHasValidAttributesField() {
        return this.fieldPresent("attributes", ATTRIBUTE_MAP_FIELD_TYPE) || this.fieldPresent("attributes", ATTRIBUTE_ARRAY_FIELD_TYPE);
    }

    boolean fieldPresent(String field, Schema.FieldType expectedType) {
        Schema schema = this.configuration.getDataSchema();
        return schema.hasField(field) && expectedType.equivalent(schema.getField(field).getType(), Schema.EquivalenceNullablePolicy.IGNORE);
    }
}

