/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics;

import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.LabelKey;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.LabelValue;

@ThreadSafe
public abstract class LongGauge {
    public abstract LongPoint getOrCreateTimeSeries(List<LabelValue> var1);

    public abstract LongPoint getDefaultTimeSeries();

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static LongGauge newNoopLongGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopLongGauge.create(name, description, unit, labelKeys);
    }

    private static final class NoopLongGauge
    extends LongGauge {
        private final int labelKeysSize;

        static NoopLongGauge create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopLongGauge(name, description, unit, labelKeys);
        }

        NoopLongGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public NoopLongPoint getOrCreateTimeSeries(List<LabelValue> labelValues) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopLongPoint.INSTANCE;
        }

        @Override
        public NoopLongPoint getDefaultTimeSeries() {
            return NoopLongPoint.INSTANCE;
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }

        private static final class NoopLongPoint
        extends LongPoint {
            private static final NoopLongPoint INSTANCE = new NoopLongPoint();

            private NoopLongPoint() {
            }

            @Override
            public void add(long amt) {
            }

            @Override
            public void set(long val) {
            }
        }
    }

    public static abstract class LongPoint {
        public abstract void add(long var1);

        public abstract void set(long var1);
    }
}

