/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.s3.s3.vfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.StorageUnitConverter;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.vfs.s3.s3.vfs.S3FileObject;
import org.apache.hop.vfs.s3.s3common.S3CommonFileSystem;
import org.apache.hop.vfs.s3.s3common.S3HopProperty;

public class S3FileSystem
extends S3CommonFileSystem {
    private static final Class<?> PKG = S3FileSystem.class;
    private static final ILogChannel consoleLog = new LogChannel((Object)BaseMessages.getString(PKG, (String)"TITLE.S3File", (String[])new String[0]));
    public StorageUnitConverter storageUnitConverter;
    public S3HopProperty s3HopProperty;
    private static final String MIN_PART_SIZE = "5MB";
    private static final String MAX_PART_SIZE = "5GB";

    public S3FileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        this(rootName, fileSystemOptions, new StorageUnitConverter(), new S3HopProperty());
    }

    public S3FileSystem(FileName rootName, FileSystemOptions fileSystemOptions, StorageUnitConverter storageUnitConverter, S3HopProperty s3HopProperty) {
        super(rootName, fileSystemOptions);
        this.storageUnitConverter = storageUnitConverter;
        this.s3HopProperty = s3HopProperty;
    }

    @Override
    public FileObject createFile(AbstractFileName name) throws Exception {
        return new S3FileObject(name, this);
    }

    public int getPartSize() {
        long parsedPartSize = this.parsePartSize(this.s3HopProperty.getPartSize());
        return this.convertToInt(parsedPartSize);
    }

    public long parsePartSize(String partSizeString) {
        long parsePartSize = this.convertToLong(partSizeString);
        if (parsePartSize < this.convertToLong(MIN_PART_SIZE)) {
            consoleLog.logBasic(BaseMessages.getString(PKG, (String)"WARN.S3MultiPart.DefaultPartSize", (String[])new String[]{partSizeString, MIN_PART_SIZE}));
            parsePartSize = this.convertToLong(MIN_PART_SIZE);
        }
        if (parsePartSize > this.convertToLong(MAX_PART_SIZE)) {
            consoleLog.logBasic(BaseMessages.getString(PKG, (String)"WARN.S3MultiPart.MaximumPartSize", (String[])new String[]{partSizeString, MAX_PART_SIZE}));
        }
        return parsePartSize;
    }

    public int convertToInt(long parsedPartSize) {
        return (int)Long.min(Integer.MAX_VALUE, parsedPartSize);
    }

    public long convertToLong(String partSize) {
        return this.storageUnitConverter.displaySizeToByteCount(partSize);
    }
}

