/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

@Internal
public class DoFnOutputReceivers {
    public static <T> DoFn.OutputReceiver<T> windowedReceiver(DoFn.WindowedContext context, @Nullable TupleTag<T> outputTag) {
        return new WindowedContextOutputReceiver<T>(context, outputTag);
    }

    public static <T> DoFn.MultiOutputReceiver windowedMultiReceiver(DoFn.WindowedContext context, @Nullable Map<TupleTag<?>, Coder<?>> outputCoders) {
        return new WindowedContextMultiOutputReceiver(context, outputCoders);
    }

    public static <T> DoFn.MultiOutputReceiver windowedMultiReceiver(DoFn.WindowedContext context) {
        return new WindowedContextMultiOutputReceiver(context);
    }

    public static <T> DoFn.OutputReceiver<Row> rowReceiver(DoFn.WindowedContext context, @Nullable TupleTag<T> outputTag, SchemaCoder<T> schemaCoder) {
        return new RowOutputReceiver<T>(context, outputTag, schemaCoder);
    }

    private static class WindowedContextMultiOutputReceiver
    implements DoFn.MultiOutputReceiver {
        DoFn.WindowedContext context;
        @Nullable Map<TupleTag<?>, Coder<?>> outputCoders;

        public WindowedContextMultiOutputReceiver(DoFn.WindowedContext context, @Nullable Map<TupleTag<?>, Coder<?>> outputCoders) {
            this.context = context;
            this.outputCoders = outputCoders;
        }

        public WindowedContextMultiOutputReceiver(DoFn.WindowedContext context) {
            this.context = context;
        }

        @Override
        public <T> DoFn.OutputReceiver<T> get(TupleTag<T> tag) {
            return DoFnOutputReceivers.windowedReceiver(this.context, tag);
        }

        @Override
        public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
            Coder outputCoder = (Coder)((Map)Preconditions.checkNotNull(this.outputCoders)).get(tag);
            Preconditions.checkState((outputCoder != null ? 1 : 0) != 0, (Object)("No output tag for " + tag));
            Preconditions.checkState((boolean)(outputCoder instanceof SchemaCoder), (Object)("Output with tag " + tag + " must have a schema in order to call  getRowReceiver"));
            return DoFnOutputReceivers.rowReceiver(this.context, tag, (SchemaCoder)outputCoder);
        }
    }

    private static class WindowedContextOutputReceiver<T>
    implements DoFn.OutputReceiver<T> {
        DoFn.WindowedContext context;
        @Nullable TupleTag<T> outputTag;

        public WindowedContextOutputReceiver(DoFn.WindowedContext context, @Nullable TupleTag<T> outputTag) {
            this.context = context;
            this.outputTag = outputTag;
        }

        @Override
        public void output(T output) {
            if (this.outputTag != null) {
                this.context.output(this.outputTag, output);
            } else {
                this.context.output(output);
            }
        }

        @Override
        public void outputWithTimestamp(T output, Instant timestamp) {
            if (this.outputTag != null) {
                this.context.outputWithTimestamp(this.outputTag, output, timestamp);
            } else {
                this.context.outputWithTimestamp(output, timestamp);
            }
        }
    }

    private static class RowOutputReceiver<T>
    implements DoFn.OutputReceiver<Row> {
        WindowedContextOutputReceiver<T> outputReceiver;
        SchemaCoder<T> schemaCoder;

        public RowOutputReceiver(DoFn.WindowedContext context, @Nullable TupleTag<T> outputTag, SchemaCoder<T> schemaCoder) {
            this.outputReceiver = new WindowedContextOutputReceiver<T>(context, outputTag);
            this.schemaCoder = (SchemaCoder)Preconditions.checkNotNull(schemaCoder);
        }

        @Override
        public void output(Row output) {
            this.outputReceiver.output(this.schemaCoder.getFromRowFunction().apply(output));
        }

        @Override
        public void outputWithTimestamp(Row output, Instant timestamp) {
            this.outputReceiver.outputWithTimestamp(this.schemaCoder.getFromRowFunction().apply(output), timestamp);
        }
    }
}

