/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.KeyedDataQueueEntry;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class KeyedDataQueue
extends BaseDataQueue {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    int keyLength_ = 0;

    public KeyedDataQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing KeyedDataQueue object.");
        }
    }

    public KeyedDataQueue(AS400 aS400, String string) {
        super(aS400, string);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing KeyedDataQueue object.");
        }
    }

    private byte[] convertKey(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        int n = this.getKeyLength();
        byte[] byArray = this.stringToByteArray(string);
        if (byArray.length == n) {
            return byArray;
        }
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        Trace.log(2, "Length of parameter 'key' is not valid: " + string);
        throw new ExtendedIllegalArgumentException("key (" + string + ")", 1);
    }

    public void clear(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing keyed data queue.");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (byArray.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", byArray.length);
            throw new ExtendedIllegalArgumentException("key.length (" + byArray.length + ")", 1);
        }
        this.open();
        this.impl_.clear(byArray);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(0);
        }
    }

    public void clear(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        this.clear(this.convertKey(string));
    }

    public void create(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.create(n, n2, "*LIBCRTAUT", false, false, "");
    }

    public void create(int n, int n2, String string, boolean bl, boolean bl2, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating keyed data queue.");
        }
        if (n < 1 || n > 256) {
            Trace.log(2, "Value of parameter 'keyLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("keyLength (" + n + ")", 4);
        }
        if (n2 < 1 || n2 > 64512) {
            Trace.log(2, "Value of parameter 'maxEntryLength' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("maxEntryLength (" + n2 + ")", 4);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        if (!((string = string.toUpperCase().trim()).equals("*LIBCRTAUT") || string.equals("*ALL") || string.equals("*CHANGE") || string.equals("*EXCLUDE") || string.equals("*USE"))) {
            Trace.log(2, "Value of parameter 'authority' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("authority (" + string + ")", 2);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (string2.length() > 50) {
            Trace.log(2, "Length of parameter 'description' is not valid: " + string2);
            throw new ExtendedIllegalArgumentException("description (" + string2 + ")", 1);
        }
        this.chooseImpl();
        this.attributesRetrieved_ = false;
        this.maxEntryLength_ = n2;
        this.saveSenderInformation_ = bl;
        this.FIFO_ = true;
        this.forceToAuxiliaryStorage_ = bl2;
        this.description_ = string2;
        this.keyLength_ = n;
        this.impl_.create(n2, string, bl, true, n, bl2, string2);
        if (this.objectListeners_ != null) {
            this.fireObjectEvent(1);
        }
        this.attributesRetrieved_ = true;
    }

    public int getKeyLength() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting key length.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Key length:", this.keyLength_);
        }
        return this.keyLength_;
    }

    public KeyedDataQueueEntry peek(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.peek(byArray, 0, "EQ");
    }

    public KeyedDataQueueEntry peek(byte[] byArray, int n, String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Peeking keyed data queue.");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (byArray.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", byArray.length);
            throw new ExtendedIllegalArgumentException("key.length (" + byArray.length + ")", 1);
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", n);
            throw new ExtendedIllegalArgumentException("wait (" + n + ")", 2);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'searchType' is null.");
            throw new NullPointerException("searchType");
        }
        String string2 = string.toUpperCase();
        if (!(string2.equals("EQ") || string2.equals("NE") || string2.equals("LT") || string2.equals("LE") || string2.equals("GT") || string2.equals("GE"))) {
            Trace.log(2, "Value of parameter 'searchType' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("searchType (" + string + ")", 2);
        }
        this.open();
        DQReceiveRecord dQReceiveRecord = this.impl_.read(string2, n, true, byArray);
        if (dQReceiveRecord == null) {
            return null;
        }
        KeyedDataQueueEntry keyedDataQueueEntry = new KeyedDataQueueEntry(this, dQReceiveRecord.key_, dQReceiveRecord.data_, dQReceiveRecord.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(1);
        }
        return keyedDataQueueEntry;
    }

    public KeyedDataQueueEntry peek(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.peek(string, 0, "EQ");
    }

    public KeyedDataQueueEntry peek(String string, int n, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        return this.peek(this.convertKey(string), n, string2);
    }

    public KeyedDataQueueEntry read(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.read(byArray, 0, "EQ");
    }

    public KeyedDataQueueEntry read(byte[] byArray, int n, String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Reading data queue.");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (byArray.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", byArray.length);
            throw new ExtendedIllegalArgumentException("key.length (" + byArray.length + ")", 1);
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'wait' is not valid:", n);
            throw new ExtendedIllegalArgumentException("wait (" + n + ")", 2);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'searchType' is null.");
            throw new NullPointerException("searchType");
        }
        String string2 = string.toUpperCase();
        if (!(string2.equals("EQ") || string2.equals("NE") || string2.equals("LT") || string2.equals("LE") || string2.equals("GT") || string2.equals("GE"))) {
            Trace.log(2, "Value of parameter 'searchType' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("searchType (" + string + ")", 2);
        }
        this.open();
        DQReceiveRecord dQReceiveRecord = this.impl_.read(string2, n, false, byArray);
        if (dQReceiveRecord == null) {
            return null;
        }
        KeyedDataQueueEntry keyedDataQueueEntry = new KeyedDataQueueEntry(this, dQReceiveRecord.key_, dQReceiveRecord.data_, dQReceiveRecord.senderInformation_);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(2);
        }
        return keyedDataQueueEntry;
    }

    public KeyedDataQueueEntry read(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        return this.read(string, 0, "EQ");
    }

    public KeyedDataQueueEntry read(String string, int n, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        return this.read(this.convertKey(string), n, string2);
    }

    void retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving keyed data queue attributes.");
        }
        DQQueryRecord dQQueryRecord = this.impl_.retrieveAttributes(true);
        this.maxEntryLength_ = dQQueryRecord.maxEntryLength_;
        this.saveSenderInformation_ = dQQueryRecord.saveSenderInformation_;
        this.FIFO_ = true;
        this.forceToAuxiliaryStorage_ = dQQueryRecord.forceToAuxiliaryStorage_;
        this.description_ = dQQueryRecord.description_;
        this.keyLength_ = dQQueryRecord.keyLength_;
        this.attributesRetrieved_ = true;
    }

    public String toString() {
        return "KeyedDataQueue " + super.toString();
    }

    public void write(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing keyed data queue.");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (byArray.length > 256) {
            Trace.log(2, "Length of parameter 'key' is not valid:", byArray.length);
            throw new ExtendedIllegalArgumentException("key.length (" + byArray.length + ")", 1);
        }
        if (byArray2 == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        if (byArray2.length > 64512) {
            Trace.log(2, "Length of parameter 'data' is not valid:", byArray2.length);
            throw new ExtendedIllegalArgumentException("data.length (" + byArray2.length + ")", 1);
        }
        this.open();
        this.impl_.write(byArray, byArray2);
        if (this.dataQueueListeners_ != null) {
            this.fireDataQueueEvent(3);
        }
    }

    public void write(String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'key' is null.");
            throw new NullPointerException("key");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        this.write(this.convertKey(string), this.stringToByteArray(string2));
    }
}

